/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core.settings;

import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.openide.ErrorManager;

public final class FindBugsSettings {
    private static UserPreferences userPreferences;
    private static String SETTINGS_DIR;
    private static String SETTINGS_FILE;

    public static UserPreferences getUserPreferences() {
        if (null == userPreferences) {
            userPreferences = FindBugsSettings.createUserPreferences();
        }
        return userPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UserPreferences createUserPreferences() {
        UserPreferences up;
        block13: {
            up = UserPreferences.createDefaultUserPreferences();
            File settingsDir = new File(SETTINGS_DIR);
            File settingsFile = new File(SETTINGS_DIR + File.separator + SETTINGS_FILE);
            if (!settingsDir.exists()) {
                settingsDir.mkdirs();
            }
            try {
                if (!settingsFile.exists()) {
                    FileOutputStream fos = null;
                    try {
                        if (settingsFile.createNewFile()) {
                            fos = new FileOutputStream(settingsFile);
                            FindBugsSettings.presetPrefs(up);
                            up.write((OutputStream)fos);
                        }
                        break block13;
                    }
                    finally {
                        if (null != fos) {
                            fos.close();
                        }
                    }
                }
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(settingsFile);
                    up.read((InputStream)fis);
                }
                finally {
                    if (null != fis) {
                        fis.close();
                    }
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
        return up;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        if (null != userPreferences) {
            try {
                FileOutputStream fos = null;
                try {
                    File settingsFile = new File(SETTINGS_DIR + File.separator + SETTINGS_FILE);
                    fos = new FileOutputStream(settingsFile);
                    FindBugsSettings.getUserPreferences().write((OutputStream)fos);
                }
                finally {
                    if (null != fos) {
                        fos.close();
                    }
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }

    static void presetPrefs(UserPreferences up) {
        Iterator pluginIterator = DetectorFactoryCollection.instance().pluginIterator();
        while (pluginIterator.hasNext()) {
            Plugin plugin = (Plugin)pluginIterator.next();
            if ("FindBugs project".equals(plugin.getProvider())) continue;
            Iterator detectorFactoryIterator = plugin.detectorFactoryIterator();
            while (detectorFactoryIterator.hasNext()) {
                DetectorFactory detectorFactory = (DetectorFactory)detectorFactoryIterator.next();
                up.enableDetector(detectorFactory, false);
            }
        }
    }

    static {
        SETTINGS_DIR = System.getProperty("netbeans.user") + File.separatorChar + "config" + File.separatorChar + "findbugs";
        SETTINGS_FILE = "UserPreferences.findbugs";
    }
}

