/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core.option;

import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.gui.DefaultSortedTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.layout.GroupLayout;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.settings.FindBugsSettings;

public class ConfigureDetectorsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int SPEED_COLUMN = 1;
    private static final int ENABLED_COLUMN = 2;
    private DefaultComboBoxModel pluginSelector;
    private ListCellRenderer pluginRenderer;
    private UserPreferences userPreferences = null;
    private JEditorPane detectorDescription;
    private JScrollPane detectorDescriptionScrollPane;
    private JTable detectorTable;
    private JScrollPane detectorTableScrollPane;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JButton restoreDefaultsButton;
    private JButton restoreDefaultsButton1;
    private ArrayList<DetectorFactory> factoryList = new ArrayList();

    public ConfigureDetectorsPanel() {
        this(FindBugsSettings.getUserPreferences());
    }

    public ConfigureDetectorsPanel(UserPreferences userPreferences) {
        this.preInitComponents();
        this.initComponents();
        this.setUserPreferences(userPreferences);
    }

    private void preInitComponents() {
        Vector<Plugin> plugins = new Vector<Plugin>();
        Iterator pluginIterator = DetectorFactoryCollection.instance().pluginIterator();
        while (pluginIterator.hasNext()) {
            Plugin plugin = (Plugin)pluginIterator.next();
            plugins.add(plugin);
        }
        this.pluginSelector = new DefaultComboBoxModel(plugins);
        this.pluginRenderer = new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object o = value;
                if (null != value) {
                    Plugin plugin = (Plugin)value;
                    o = plugin.getProvider() + "(" + plugin.getPluginId() + ")";
                }
                return super.getListCellRendererComponent((JList<?>)list, o, index, isSelected, cellHasFocus);
            }
        };
    }

    public void setUserPreferences(UserPreferences userPreferences) {
        this.userPreferences = userPreferences;
        this.postInitComponents();
    }

    private void initComponents() {
        this.detectorTableScrollPane = new JScrollPane();
        this.detectorTable = new JTable();
        this.detectorDescriptionScrollPane = new JScrollPane();
        this.detectorDescription = new JEditorPane();
        this.jComboBox1 = new JComboBox();
        this.restoreDefaultsButton = new JButton();
        this.jLabel1 = new JLabel();
        this.restoreDefaultsButton1 = new JButton();
        this.detectorTableScrollPane.setBorder(BorderFactory.createBevelBorder(1));
        this.detectorTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Bug Detector", "Speed", "Enabled"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.populateTable();
        this.detectorTable.getColumnModel().getColumn(2).setMaxWidth(60);
        this.detectorTable.getColumnModel().getColumn(1).setMaxWidth(60);
        this.detectorTable.setSelectionMode(0);
        DefaultTableModel m = (DefaultTableModel)this.detectorTable.getModel();
        m.setColumnIdentifiers(new String[]{L10N.getLocalString((String)"dlg.bugdetector_lbl", (String)"Bug Detector"), L10N.getLocalString((String)"dlg.speed_lbl", (String)"Speed"), L10N.getLocalString((String)"dlg.enabled_lbl", (String)"Enabled")});
        DefaultSortedTableModel sortedModel = new DefaultSortedTableModel((AbstractTableModel)m, this.detectorTable.getTableHeader());
        this.detectorTable.setModel((TableModel)sortedModel);
        this.detectorTableScrollPane.setViewportView(this.detectorTable);
        this.detectorDescriptionScrollPane.setBorder(BorderFactory.createBevelBorder(1));
        this.detectorDescriptionScrollPane.setPreferredSize(new Dimension(110, 120));
        this.detectorDescription.setEditorKit(new HTMLEditorKit());
        this.detectorDescriptionScrollPane.setViewportView(this.detectorDescription);
        this.jComboBox1.setModel(this.pluginSelector);
        this.jComboBox1.setRenderer(this.pluginRenderer);
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigureDetectorsPanel.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.restoreDefaultsButton.setText("Restore Defaults");
        this.restoreDefaultsButton.setHorizontalAlignment(2);
        this.restoreDefaultsButton.setText(L10N.getLocalString((String)"dlg.restoredefaults_btn", (String)"Restore Defaults"));
        this.restoreDefaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigureDetectorsPanel.this.restoreDefaultsButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Plugin Id");
        this.restoreDefaultsButton1.setText("Disable All Detectors");
        this.restoreDefaultsButton1.setHorizontalAlignment(2);
        this.restoreDefaultsButton.setText(L10N.getLocalString((String)"dlg.restoredefaults_btn", (String)"Restore Defaults"));
        this.restoreDefaultsButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigureDetectorsPanel.this.disableAllButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.detectorDescriptionScrollPane, -1, 537, Short.MAX_VALUE).add(1, (Component)this.detectorTableScrollPane, -1, 537, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jComboBox1, 0, 492, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.restoreDefaultsButton).addPreferredGap(0).add((Component)this.restoreDefaultsButton1))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBox1, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((Component)this.detectorTableScrollPane, -2, 228, -2).addPreferredGap(0).add((Component)this.detectorDescriptionScrollPane, -1, 180, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.restoreDefaultsButton).add((Component)this.restoreDefaultsButton1)).addContainerGap()));
    }

    private void disableAllButton1ActionPerformed(ActionEvent evt) {
        Plugin plugin = (Plugin)this.jComboBox1.getSelectedItem();
        Iterator i = plugin.detectorFactoryIterator();
        DefaultSortedTableModel sorter = (DefaultSortedTableModel)this.detectorTable.getModel();
        TableModel model = sorter.getBaseTableModel();
        int row = 0;
        while (i.hasNext()) {
            DetectorFactory factory = (DetectorFactory)i.next();
            if (factory.isHidden()) continue;
            model.setValueAt(false, row++, 2);
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.applyDetectorChangesToUserPreferences(this.userPreferences);
        this.populateTable();
    }

    private void restoreDefaultsButtonActionPerformed(ActionEvent evt) {
        Plugin plugin = (Plugin)this.jComboBox1.getSelectedItem();
        Iterator i = plugin.detectorFactoryIterator();
        DefaultSortedTableModel sorter = (DefaultSortedTableModel)this.detectorTable.getModel();
        TableModel model = sorter.getBaseTableModel();
        int row = 0;
        while (i.hasNext()) {
            DetectorFactory factory = (DetectorFactory)i.next();
            if (factory.isHidden()) continue;
            model.setValueAt(factory.isDefaultEnabled() ? Boolean.TRUE : Boolean.FALSE, row++, 2);
        }
    }

    private void postInitComponents() {
        ListSelectionModel rowSM = this.detectorTable.getSelectionModel();
        rowSM.addListSelectionListener(new DetectorListListener());
        this.populateTable();
    }

    private void viewDetectorDetails(DetectorFactory factory) {
        String detailHTML = factory.getDetailHTML();
        if (detailHTML == null) {
            this.detectorDescription.setText("");
        } else {
            this.detectorDescription.setContentType("text/html");
            this.detectorDescription.setText(detailHTML);
            StringBuffer toolTip = new StringBuffer(100);
            toolTip.append("<html><body><b>");
            toolTip.append(factory.getFullName());
            toolTip.append("</b><br><br><table border='1' width='100%'><tr><th>");
            toolTip.append(L10N.getLocalString((String)"msg.bugpatternsreported_txt", (String)"Bug Patterns Reported"));
            toolTip.append("</th></tr>");
            Set patterns = factory.getReportedBugPatterns();
            for (BugPattern pattern : patterns) {
                toolTip.append("<tr><td align='center'>");
                toolTip.append("[");
                toolTip.append(pattern.getAbbrev());
                toolTip.append("] ");
                toolTip.append(pattern.getType());
                toolTip.append("</td></tr>");
            }
            toolTip.append("</body></html>");
            this.detectorDescription.setToolTipText(toolTip.toString());
        }
    }

    private void populateTable() {
        UserPreferences prefs = this.userPreferences;
        DefaultTableModel model = new DefaultTableModel(new Object[0][], new String[]{"Bug Detector", "Speed", "Enabled"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
        model.setColumnIdentifiers(new String[]{L10N.getLocalString((String)"dlg.bugdetector_lbl", (String)"Bug Detector"), L10N.getLocalString((String)"dlg.speed_lbl", (String)"Speed"), L10N.getLocalString((String)"dlg.enabled_lbl", (String)"Enabled")});
        Plugin plugin = (Plugin)this.jComboBox1.getSelectedItem();
        if (null == plugin) {
            this.detectorTable.setModel(model);
            return;
        }
        this.factoryList.clear();
        Iterator i = plugin.detectorFactoryIterator();
        while (i.hasNext()) {
            DetectorFactory factory = (DetectorFactory)i.next();
            if (factory.isHidden()) continue;
            model.addRow(new Object[]{factory.getShortName(), factory.getSpeed(), prefs.isDetectorEnabled(factory) ? Boolean.TRUE : Boolean.FALSE});
            this.factoryList.add(factory);
        }
        DefaultSortedTableModel sortedModel = new DefaultSortedTableModel((AbstractTableModel)model, this.detectorTable.getTableHeader());
        this.detectorTable.setModel((TableModel)sortedModel);
    }

    public void applyDetectorChangesToUserPreferences(UserPreferences userPreferences) {
        int num = this.factoryList.size();
        DefaultSortedTableModel sorter = (DefaultSortedTableModel)this.detectorTable.getModel();
        TableModel model = sorter.getBaseTableModel();
        for (int i = 0; i < num; ++i) {
            DetectorFactory factory = this.factoryList.get(i);
            Boolean enabled = (Boolean)model.getValueAt(i, 2);
            userPreferences.enableDetector(factory, enabled.booleanValue());
        }
    }

    private class DetectorListListener
    implements ListSelectionListener {
        private DetectorListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selectedRow = lsm.getMinSelectionIndex();
                DefaultSortedTableModel sorter = (DefaultSortedTableModel)ConfigureDetectorsPanel.this.detectorTable.getModel();
                ConfigureDetectorsPanel.this.viewDetectorDetails((DetectorFactory)ConfigureDetectorsPanel.this.factoryList.get(sorter.getBaseModelIndex(selectedRow)));
            }
        }
    }
}

