/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core.annotations;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.nbheaven.sqe.codedefects.core.api.QualityResult;
import org.nbheaven.sqe.codedefects.core.api.SQEAnnotationProcessor;
import org.nbheaven.sqe.core.java.search.ClassElementDescriptor;
import org.nbheaven.sqe.core.java.search.JavaElement;
import org.nbheaven.sqe.core.java.search.MethodElementDescriptor;
import org.nbheaven.sqe.core.java.search.SearchUtilities;
import org.nbheaven.sqe.core.java.search.VariableElementDescriptor;
import org.nbheaven.sqe.core.java.utils.JavaSourceProvider;
import org.nbheaven.sqe.core.java.utils.TypeUtilities;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsResult;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.annotations.FindBugsAnnotation;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.search.impl.ClassElementDescriptorImpl;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.search.impl.MethodElementDescriptorImpl;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.search.impl.VariableElementDescriptorImpl;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Line;

public final class BugAnnotationProcessor
implements SQEAnnotationProcessor {
    public static final SQEAnnotationProcessor INSTANCE = new BugAnnotationProcessor();

    private BugAnnotationProcessor() {
    }

    private static Line getLineForSourceAnnotation(DataObject dao, SourceLineAnnotation sourceLineAnnotation) {
        LineCookie cookie = (LineCookie)dao.getLookup().lookup(LineCookie.class);
        Line.Set lineset = cookie.getLineSet();
        int lineNum = sourceLineAnnotation.getStartLine();
        return lineset.getCurrent(lineNum - 1);
    }

    private static void annotate(BugInstance bugInstance, JavaElement javaElement, Project project) {
        if (javaElement == null) {
            return;
        }
        FindBugsAnnotation annotation = FindBugsAnnotation.createNewInstance(project);
        annotation.setErrorMessage(bugInstance.getMessage());
        Line line = javaElement.getLine();
        Line.Part linePart = line.createPart(javaElement.getBeginColumn(), javaElement.getEndColumn());
        annotation.attach((Annotatable)linePart);
        line.addPropertyChangeListener((PropertyChangeListener)annotation);
    }

    private static void annotate(BugInstance bugInstance, Line line, Project project) {
        FindBugsAnnotation annotation = FindBugsAnnotation.createNewInstance(project);
        annotation.setErrorMessage(bugInstance.getMessage());
        annotation.attach((Annotatable)line);
        line.addPropertyChangeListener((PropertyChangeListener)annotation);
    }

    private static void openSourceFileAndAnnotate(BugInstance bugInstance, final Line line, Project project) {
        BugAnnotationProcessor.annotate(bugInstance, line, project);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
            }
        });
    }

    public static void openSourceFile(BugInstance bugInstance, SourceLineAnnotation sourceLineAnnotation, Project project) {
        FileObject fo = BugAnnotationProcessor.findFileObjectForAnnotatedClass(sourceLineAnnotation.getClassName(), project);
        if (fo == null) {
            return;
        }
        try {
            DataObject dao = DataObject.find((FileObject)fo);
            Line line = BugAnnotationProcessor.getLineForSourceAnnotation(dao, sourceLineAnnotation);
            BugAnnotationProcessor.openSourceFileAndAnnotate(bugInstance, line, project);
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public static void openSourceFile(BugInstance bugInstance, Project project) {
        SourceLineAnnotation sourceLineAnnotation = bugInstance.getPrimarySourceLineAnnotation();
        if (null != sourceLineAnnotation && sourceLineAnnotation.getStartLine() > 0) {
            BugAnnotationProcessor.openSourceFile(bugInstance, sourceLineAnnotation, project);
            return;
        }
        FieldAnnotation fieldAnnotation = bugInstance.getPrimaryField();
        if (null != fieldAnnotation) {
            VariableElementDescriptorImpl desc = new VariableElementDescriptorImpl(bugInstance.getPrimaryClass(), fieldAnnotation, project);
            JavaElement findFieldElement = SearchUtilities.findVariableElement((VariableElementDescriptor)desc);
            if (findFieldElement != null) {
                findFieldElement.open();
            }
            return;
        }
        MethodAnnotation methodAnnotation = bugInstance.getPrimaryMethod();
        if (null != methodAnnotation) {
            MethodElementDescriptorImpl desc = new MethodElementDescriptorImpl(bugInstance.getPrimaryClass(), methodAnnotation, project);
            JavaElement findMethodElement = SearchUtilities.findMethodElement((MethodElementDescriptor)desc);
            if (findMethodElement != null) {
                findMethodElement.open();
            }
            return;
        }
        ClassAnnotation classAnnotation = bugInstance.getPrimaryClass();
        if (null != classAnnotation) {
            ClassElementDescriptorImpl desc = new ClassElementDescriptorImpl(classAnnotation, project);
            JavaElement findClassElement = SearchUtilities.findClassElement((ClassElementDescriptor)desc);
            if (findClassElement != null) {
                findClassElement.open();
            }
            return;
        }
    }

    public static void openSourceFile(BugInstance bugInstance, FieldAnnotation fieldAnnotation, Project project) {
        VariableElementDescriptorImpl desc = new VariableElementDescriptorImpl(bugInstance.getPrimaryClass(), fieldAnnotation, project);
        JavaElement findMethodElement = SearchUtilities.findVariableElement((VariableElementDescriptor)desc);
        if (findMethodElement != null) {
            findMethodElement.open();
        }
    }

    public static void openSourceFile(BugInstance bugInstance, MethodAnnotation methodAnnotation, Project project) {
        MethodElementDescriptorImpl desc = new MethodElementDescriptorImpl(bugInstance.getPrimaryClass(), methodAnnotation, project);
        JavaElement findMethodElement = SearchUtilities.findMethodElement((MethodElementDescriptor)desc);
        if (findMethodElement != null) {
            findMethodElement.open();
        }
    }

    public static void openSourceFile(BugInstance bugInstance, ClassAnnotation classAnnotation, Project project) {
        ClassElementDescriptorImpl desc = new ClassElementDescriptorImpl(classAnnotation, project);
        JavaElement findClassElement = SearchUtilities.findClassElement((ClassElementDescriptor)desc);
        if (findClassElement != null) {
            findClassElement.open();
        }
    }

    public static FileObject findFileObjectForAnnotatedClass(String className, Project project) {
        String javaFileName = className;
        JavaSourceProvider javaSourceProvider = TypeUtilities.getJavaTypeElement((String)javaFileName, (Project)project);
        if (null == javaSourceProvider) {
            return null;
        }
        return javaSourceProvider.getFileObject();
    }

    public void annotateSourceFile(JavaSource javaSource, Project project, QualityResult qualityResult) {
        if (null == qualityResult) {
            return;
        }
        assert (qualityResult instanceof FindBugsResult) : "Illegal session passed to AnnotationProcessor";
        FindBugsResult result = (FindBugsResult)qualityResult;
        FileObject fileObject = (FileObject)javaSource.getFileObjects().iterator().next();
        Collection fqnClassNames = SearchUtilities.getFQNClassNames((FileObject)fileObject);
        for (String fqnClassName : fqnClassNames) {
            this.annotateClass(fqnClassName, fileObject, project, result);
        }
    }

    public void clearAllAnnotations(Project project) {
        FindBugsAnnotation.clearAll(project);
    }

    private void annotateClass(String className, FileObject fileObject, Project project, FindBugsResult result) {
        FindBugsResult.StringKey key;
        Map<FindBugsResult.ClassKey, Collection<BugInstance>> instanceMap = result.getInstanceByClass(true);
        Collection<BugInstance> bugs = instanceMap.get(key = new FindBugsResult.StringKey(className));
        if (null != bugs) {
            for (BugInstance bug : bugs) {
                try {
                    SourceLineAnnotation sourceLineAnnotation = null;
                    Iterator annotationIterator = bug.annotationIterator();
                    while (annotationIterator.hasNext()) {
                        BugAnnotation annotation = (BugAnnotation)annotationIterator.next();
                        if (!(annotation instanceof SourceLineAnnotation)) continue;
                        sourceLineAnnotation = (SourceLineAnnotation)annotation;
                        break;
                    }
                    if (null != sourceLineAnnotation && -1 != sourceLineAnnotation.getStartLine()) {
                        Line line = BugAnnotationProcessor.getLineForSourceAnnotation(DataObject.find((FileObject)fileObject), sourceLineAnnotation);
                        BugAnnotationProcessor.annotate(bug, line, project);
                        continue;
                    }
                    FieldAnnotation fieldAnnotation = bug.getPrimaryField();
                    if (null != fieldAnnotation) {
                        VariableElementDescriptorImpl desc = new VariableElementDescriptorImpl(bug.getPrimaryClass(), fieldAnnotation, project);
                        JavaElement findFieldElement = SearchUtilities.findVariableElement((VariableElementDescriptor)desc);
                        BugAnnotationProcessor.annotate(bug, findFieldElement, project);
                        continue;
                    }
                    MethodAnnotation methodAnnotation = bug.getPrimaryMethod();
                    if (null != methodAnnotation) {
                        MethodElementDescriptorImpl desc = new MethodElementDescriptorImpl(bug.getPrimaryClass(), methodAnnotation, project);
                        JavaElement findMethodElement = SearchUtilities.findMethodElement((MethodElementDescriptor)desc);
                        BugAnnotationProcessor.annotate(bug, findMethodElement, project);
                        continue;
                    }
                    ClassAnnotation classAnnotation = bug.getPrimaryClass();
                    if (null == classAnnotation) continue;
                    ClassElementDescriptorImpl desc = new ClassElementDescriptorImpl(classAnnotation, project);
                    JavaElement findClassElement = SearchUtilities.findClassElement((ClassElementDescriptor)desc);
                    BugAnnotationProcessor.annotate(bug, findClassElement, project);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
    }
}

