/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core.actions;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.util.SQECodedefectProperties;
import org.nbheaven.sqe.core.api.SQEManager;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsQualityProvider;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsSession;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.FindBugsTopComponent;
import org.netbeans.api.project.Project;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RunFindBugsAction
extends AbstractAction
implements LookupListener,
ContextAwareAction,
PropertyChangeListener {
    private Lookup context;
    private Lookup.Result<Project> lkpInfo;

    public RunFindBugsAction() {
        this(Utilities.actionsGlobalContext());
    }

    private RunFindBugsAction(Lookup context) {
        this.putValue("Name", NbBundle.getMessage(RunFindBugsAction.class, (String)"LBL_RunFindBugsAction"));
        this.putValue("SmallIcon", ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/nbheaven/sqe/tools/findbugs/codedefects/core/resources/findbugs.png")));
        this.context = context;
    }

    public Action createContextAwareInstance(Lookup context) {
        return new RunFindBugsAction(context);
    }

    public boolean isEnabled() {
        this.init();
        return super.isEnabled();
    }

    private void init() {
        assert (SwingUtilities.isEventDispatchThread()) : "this shall be called just from AWT thread";
        if (this.lkpInfo != null) {
            return;
        }
        SQECodedefectProperties.addPropertyChangeListener((String)SQECodedefectProperties.getPropertyNameActive((QualityProvider)FindBugsQualityProvider.getDefault()), (PropertyChangeListener)this);
        Lookup.Template tpl = new Lookup.Template(Project.class);
        this.lkpInfo = this.context.lookup(tpl);
        this.lkpInfo.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public void resultChanged(LookupEvent ev) {
        this.updateEnableState();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(SQECodedefectProperties.getPropertyNameActive((QualityProvider)FindBugsQualityProvider.getDefault()))) {
            this.updateEnableState();
        }
    }

    private void updateEnableState() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RunFindBugsAction.this.updateEnableState();
                }
            });
            return;
        }
        this.setEnabled(this.isEnabled(this.getActiveProject()));
    }

    private Project getActiveProject() {
        Collection projects = this.lkpInfo.allInstances();
        if (projects.size() == 1) {
            Project project = (Project)projects.iterator().next();
            return project;
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        Project project = this.getActiveProject();
        if (null != project && this.isEnabled(project)) {
            FindBugsSession session = this.getFindBugsSession(project);
            session.computeResult();
            SQEManager.getDefault().setActiveProject(project);
            FindBugsTopComponent tc = FindBugsTopComponent.findInstance();
            tc.open();
        }
    }

    private FindBugsSession getFindBugsSession(Project project) {
        return (FindBugsSession)((Object)project.getLookup().lookup(FindBugsSession.class));
    }

    private boolean isQualityProviderActive(Project project) {
        return SQECodedefectProperties.isQualityProviderActive((Project)project, (QualityProvider)FindBugsQualityProvider.getDefault());
    }

    private boolean isValidForProject(Project project) {
        return FindBugsQualityProvider.getDefault().isValidFor(project);
    }

    private boolean isEnabled(Project project) {
        return null != project && this.isValidForProject(project) && this.isQualityProviderActive(project) && null != this.getFindBugsSession(project);
    }
}

