/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core;

import edu.umd.cs.findbugs.FindBugsProgress;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.openide.util.Cancellable;

class NbFindBugsProgress
implements FindBugsProgress {
    private final ProgressHandle progressHandle;
    private Project p;
    private int analyzed = 0;
    private int analyzePass = 0;
    private int[] classesPerPass = null;

    NbFindBugsProgress(Project p, ProgressHandle progressHandle) {
        this.p = p;
        this.progressHandle = progressHandle;
    }

    public void reportNumberOfArchives(int numArchives) {
        this.setProgressHandleDisplayName("Scanning Archives");
    }

    public void startArchive(String archiveName) {
        this.setProgressHandleDisplayName("Scanning Archive:" + archiveName);
    }

    public void finishArchive() {
    }

    public void startAnalysis(int numClasses) {
        this.analyzed = 0;
        this.setProgressHandleDisplayName("Analyzing Classes - Pass " + this.analyzePass);
        this.getProgressHandle().switchToDeterminate(numClasses);
    }

    public void finishClass() {
        this.getProgressHandle().progress(++this.analyzed);
    }

    public void finishPerClassAnalysis() {
        this.getProgressHandle().switchToIndeterminate();
        ++this.analyzePass;
    }

    public ProgressHandle getProgressHandle() {
        return this.progressHandle;
    }

    public void predictPassCount(int[] classesPerPass) {
        this.classesPerPass = classesPerPass;
    }

    private void setProgressHandleDisplayName(String stage) {
        this.getProgressHandle().setDisplayName("FindBugs " + ProjectUtils.getInformation((Project)this.p).getDisplayName() + " - [" + stage + "] ");
    }

    private static class CancelCallback
    implements Cancellable {
        private boolean cancelled = false;

        public boolean cancel() {
            this.cancelled = true;
            return true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }
}

