/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core;

import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.classfile.JavaClass;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsResult;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.NbFindBugsProgress;

final class NbBugReporter
extends TextUIBugReporter {
    private static final Logger LOG = Logger.getLogger(NbBugReporter.class.getName());
    private FindBugsResult findbugsResult;
    private NbFindBugsProgress progressCallback;

    NbBugReporter(FindBugsResult findbugsResult, NbFindBugsProgress progressCallback) {
        this.progressCallback = progressCallback;
        this.findbugsResult = findbugsResult;
    }

    protected void doReportBug(BugInstance bugInstance) {
        this.findbugsResult.add(bugInstance);
    }

    public void finish() {
    }

    public void observeClass(JavaClass javaClass) {
        this.progressCallback.getProgressHandle().progress("Scanning " + javaClass.getClassName());
    }

    public void observeClass(ClassDescriptor classDescriptor) {
        this.progressCallback.getProgressHandle().progress("Scanning " + classDescriptor.getClassName());
    }

    public void reportAnalysisError(AnalysisError error) {
        LOG.log(Level.INFO, error.getMessage(), error.getException());
    }

    public void reportMissingClass(String message) {
        LOG.log(Level.FINE, "Missing class: {0}", message);
    }
}

