/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core;

import edu.umd.cs.findbugs.DetectorFactoryCollection;
import java.net.URL;
import java.util.ArrayList;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

class Installer {
    private static FileChangeListener updater;

    private Installer() {
    }

    public static synchronized void installPluginUpdater() {
        FileObject fo = FileUtil.getConfigFile((String)"FindBugs/Plugins");
        if (null != fo) {
            updater = new PluginListChangedListener(fo);
            fo.addFileChangeListener(updater);
            Installer.updatePluginList(fo);
        }
    }

    private static void updatePluginList(FileObject fo) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (FileObject pluginsFileObject : fo.getChildren()) {
            Object jar = pluginsFileObject.getAttribute("jar");
            urls.add((URL)jar);
        }
        try {
            DetectorFactoryCollection.rawInstance().setPluginList(urls.toArray(new URL[urls.size()]));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static class PluginListChangedListener
    implements FileChangeListener {
        private FileObject fo;

        PluginListChangedListener(FileObject fo) {
            this.fo = fo;
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            Installer.updatePluginList(this.fo);
        }

        public void fileChanged(FileEvent fileEvent) {
            Installer.updatePluginList(this.fo);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            Installer.updatePluginList(this.fo);
        }

        public void fileDeleted(FileEvent fileEvent) {
            Installer.updatePluginList(this.fo);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            Installer.updatePluginList(this.fo);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            Installer.updatePluginList(this.fo);
        }
    }
}

