/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.spi.AbstractQualitySession;
import org.nbheaven.sqe.codedefects.core.spi.SQECodedefectScanner;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsFileScannerJob;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsProjectScannerJob;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsQualityProvider;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsResult;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;

public class FindBugsSession
extends AbstractQualitySession {
    private FindBugsResult findBugsResult;
    private AtomicBoolean isRunning;
    private Lock waitResultLock = new ReentrantLock();
    private Condition waitForResult = this.waitResultLock.newCondition();

    public FindBugsSession(Project project) {
        super((QualityProvider)FindBugsQualityProvider.getDefault(), project);
        this.isRunning = new AtomicBoolean(false);
    }

    public FindBugsQualityProvider getProvider() {
        return (FindBugsQualityProvider)super.getProvider();
    }

    public FindBugsResult getResult() {
        return this.findBugsResult;
    }

    public FindBugsResult computeResultAndWait(FileObject sourceFile) {
        FindBugsFileScannerJob job = new FindBugsFileScannerJob(this.getProject(), sourceFile);
        SQECodedefectScanner.postAndWait((SQECodedefectScanner.Job)job);
        return job.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FindBugsResult computeResultAndWait() {
        this.waitResultLock.lock();
        try {
            this.computeResult();
            while (this.isRunning.get()) {
                this.waitForResult.awaitUninterruptibly();
            }
            FindBugsResult findBugsResult = this.findBugsResult;
            return findBugsResult;
        }
        finally {
            this.waitResultLock.unlock();
        }
    }

    public void computeResult() {
        if (!this.isRunning.getAndSet(true)) {
            FindBugsProjectScannerJob job = new FindBugsProjectScannerJob(this.getProject());
            SQECodedefectScanner.post((SQECodedefectScanner.Job)job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scanningDone() {
        this.waitResultLock.lock();
        try {
            this.isRunning.set(false);
            this.waitForResult.signalAll();
        }
        finally {
            this.waitResultLock.unlock();
        }
    }

    void setResult(FindBugsResult findBugsResult) {
        FindBugsResult oldResult = this.findBugsResult;
        this.findBugsResult = findBugsResult;
        this.resultChanged(oldResult, this.findBugsResult);
    }

    void resultChanged(FindBugsResult oldResult, FindBugsResult newResult) {
        this.fireResultChanged(oldResult, newResult);
    }
}

