/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FilterBugReporter;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.NoClassesFoundToAnalyzeException;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.Matcher;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nbheaven.sqe.codedefects.core.spi.SQECodedefectScanner;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsResult;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.Installer;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.NbBugReporter;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.NbFindBugsProgress;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.settings.FindBugsSettings;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.settings.FindBugsSettingsProvider;
import org.netbeans.api.project.ProjectUtils;

public abstract class FindBugsScannerJob
extends SQECodedefectScanner.Job {
    private static final Logger LOG = Logger.getLogger(FindBugsScannerJob.class.getName());
    private Project findBugsProject;
    private FindBugsResult findBugsResult;
    private org.netbeans.api.project.Project project;

    FindBugsScannerJob(org.netbeans.api.project.Project project) {
        this.project = project;
    }

    protected String getDisplayName() {
        return "FindBugs scanning " + ProjectUtils.getInformation((org.netbeans.api.project.Project)this.getProject()).getDisplayName();
    }

    protected void preScan() {
        super.preScan();
    }

    protected void scan() {
        this.getProgressHandle().progress("Setting up FindBugs Engine ");
        this.findBugsProject = this.createFindBugsProject();
        this.findBugsResult = new FindBugsResult(this.getProject());
        this.executeFindBugs();
    }

    protected final org.netbeans.api.project.Project getProject() {
        return this.project;
    }

    protected FindBugsResult getResult() {
        return this.findBugsResult;
    }

    protected abstract Project createFindBugsProject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeFindBugs() {
        UserPreferences prefs;
        if (this.findBugsProject == null) {
            return;
        }
        NbFindBugsProgress progressCallback = new NbFindBugsProgress(this.getProject(), this.getProgressHandle());
        NbBugReporter textReporter = new NbBugReporter(this.findBugsResult, progressCallback);
        textReporter.setPriorityThreshold(2);
        FindBugs2 engine = new FindBugs2();
        engine.setProject(this.findBugsProject);
        FindBugsSettingsProvider findBugsSettingsProvider = (FindBugsSettingsProvider)this.getProject().getLookup().lookup(FindBugsSettingsProvider.class);
        if (null == findBugsSettingsProvider) {
            prefs = FindBugsSettings.getUserPreferences();
        } else {
            String excludeFileName;
            prefs = findBugsSettingsProvider.getFindBugsSettings();
            String includeFileName = findBugsSettingsProvider.getIncludeFilter();
            if (null != includeFileName) {
                try {
                    Filter filter = new Filter(includeFileName);
                    textReporter = new FilterBugReporter((BugReporter)textReporter, (Matcher)filter, true);
                }
                catch (IOException ioe) {
                    LOG.log(Level.INFO, null, ioe);
                }
            }
            if (null != (excludeFileName = findBugsSettingsProvider.getExcludeFilter())) {
                try {
                    Filter filter = new Filter(excludeFileName);
                    textReporter = new FilterBugReporter((BugReporter)textReporter, (Matcher)filter, false);
                }
                catch (IOException ioe) {
                    LOG.log(Level.INFO, null, ioe);
                }
            }
        }
        engine.setBugReporter((BugReporter)textReporter);
        engine.setUserPreferences(prefs);
        engine.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        engine.setProgressCallback((FindBugsProgress)progressCallback);
        engine.setScanNestedArchives(false);
        engine.setAnalysisFeatureSettings(FindBugs.DEFAULT_EFFORT);
        try {
            engine.execute();
        }
        catch (NoClassesFoundToAnalyzeException ncftae) {
            LOG.log(Level.FINE, "coming from a " + ((Object)((Object)this)).getClass().getName(), ncftae);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        catch (InterruptedException iex) {
            LOG.log(Level.INFO, null, iex);
        }
        finally {
            progressCallback.getProgressHandle().finish();
        }
    }

    static {
        Installer.installPluginUpdater();
    }
}

