/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.nbheaven.sqe.codedefects.core.api.CodeDefectSeverity;
import org.nbheaven.sqe.codedefects.core.api.QualityResult;
import org.nbheaven.sqe.codedefects.core.api.QualityResultStatistic;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsSession;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.annotations.BugAnnotationProcessor;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.utils.FiBuUtil;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"})
public class FindBugsResult
implements QualityResult,
QualityResultStatistic {
    private Map<ClassKey, Collection<BugInstance>> instanceByClass = new TreeMap<ClassKey, Collection<BugInstance>>();
    private Map<PackageKey, Collection<BugInstance>> instanceByPackage = new TreeMap<PackageKey, Collection<BugInstance>>();
    private Map<CategoryKey, Collection<BugInstance>> instanceByCategory = new TreeMap<CategoryKey, Collection<BugInstance>>();
    private Map<BugPattern, Collection<BugInstance>> instanceByType = new TreeMap<BugPattern, Collection<BugInstance>>();
    private Map<ClassKey, Collection<BugInstance>> filteredInstanceByClass;
    private Map<PackageKey, Collection<BugInstance>> filteredInstanceByPackage;
    private Map<CategoryKey, Collection<BugInstance>> filteredInstanceByCategory;
    private Map<BugPattern, Collection<BugInstance>> filteredInstanceByType;
    private long bugCount = 0L;
    private long coreBugCount = 0L;
    private long infoBugCount = 0L;
    private long warningBugCount = 0L;
    private long errorBugCount = 0L;
    private Lookup lookup;
    private final FindBugsSession session;
    private Collection<BugInstance> storageOnly = new ArrayList<BugInstance>();
    private AtomicBoolean initialized = new AtomicBoolean(Boolean.FALSE);

    FindBugsResult(Project project) {
        this.lookup = Lookups.singleton((Object)this);
        this.session = (FindBugsSession)((Object)project.getLookup().lookup(FindBugsSession.class));
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private <T> void removeAllBugInstancesForBugPattern(BugPattern bugPattern, Map<T, Collection<BugInstance>> mapToClear) {
        for (Map.Entry<T, Collection<BugInstance>> entry : new HashMap<T, Collection<BugInstance>>(mapToClear).entrySet()) {
            for (BugInstance bugInstance : new ArrayList<BugInstance>(entry.getValue())) {
                if (!bugInstance.getBugPattern().equals((Object)bugPattern)) continue;
                entry.getValue().remove(bugInstance);
            }
            if (!entry.getValue().isEmpty()) continue;
            mapToClear.remove(entry.getKey());
        }
    }

    public void removeAllBugInstancesForBugPattern(BugPattern bugPattern) {
        if (null != this.instanceByType) {
            this.removeAllBugInstancesForBugPattern(bugPattern, this.instanceByType);
        }
        if (null != this.instanceByCategory) {
            this.removeAllBugInstancesForBugPattern(bugPattern, this.instanceByCategory);
        }
        if (null != this.instanceByClass) {
            this.removeAllBugInstancesForBugPattern(bugPattern, this.instanceByClass);
        }
        if (null != this.instanceByPackage) {
            this.removeAllBugInstancesForBugPattern(bugPattern, this.instanceByPackage);
        }
        this.session.resultChanged(null, this);
    }

    protected void add(BugInstance bugInstance) {
        this.storageOnly.add(bugInstance);
    }

    private synchronized void reallyUpdateMaps() {
        if (this.initialized.compareAndSet(false, true)) {
            for (BugInstance bugInstance : this.storageOnly) {
                ClassKey classKey;
                Collection<BugInstance> listByClass;
                ++this.bugCount;
                if (FiBuUtil.isBugPatternIssuedFromCore(bugInstance.getBugPattern())) {
                    ++this.coreBugCount;
                }
                if (null == (listByClass = this.instanceByClass.get(classKey = new ClassKey(bugInstance.getPrimaryClass(), this.session.getProject())))) {
                    listByClass = new ArrayList<BugInstance>();
                    this.instanceByClass.put(classKey, listByClass);
                }
                listByClass.add(bugInstance);
                PackageKey packageKey = new PackageKey(bugInstance.getPrimaryClass());
                Collection<BugInstance> listByPackage = this.instanceByPackage.get(packageKey);
                if (null == listByPackage) {
                    listByPackage = new ArrayList<BugInstance>();
                    this.instanceByPackage.put(packageKey, listByPackage);
                }
                listByPackage.add(bugInstance);
                CategoryKey categoryKey = new CategoryKey(bugInstance.getBugPattern());
                Collection<BugInstance> listByCategory = this.instanceByCategory.get(categoryKey);
                if (null == listByCategory) {
                    listByCategory = new ArrayList<BugInstance>();
                    this.instanceByCategory.put(categoryKey, listByCategory);
                }
                listByCategory.add(bugInstance);
                Collection<BugInstance> listByType = this.instanceByType.get(bugInstance.getBugPattern());
                if (null == listByType) {
                    listByType = new ArrayList<BugInstance>();
                    this.instanceByType.put(bugInstance.getBugPattern(), listByType);
                }
                listByType.add(bugInstance);
                if (1 == bugInstance.getPriority()) {
                    ++this.errorBugCount;
                    continue;
                }
                if (2 == bugInstance.getPriority()) {
                    ++this.warningBugCount;
                    continue;
                }
                ++this.infoBugCount;
            }
        }
    }

    public Map<ClassKey, Collection<BugInstance>> getInstanceByClass(boolean coreBugsOnly) {
        this.reallyUpdateMaps();
        if (coreBugsOnly) {
            if (null == this.filteredInstanceByClass) {
                this.filteredInstanceByClass = this.createFilteredMap(this.instanceByClass);
            }
            return this.filteredInstanceByClass;
        }
        return this.instanceByClass;
    }

    public Map<PackageKey, Collection<BugInstance>> getInstanceByPackage(boolean coreBugsOnly) {
        this.reallyUpdateMaps();
        if (coreBugsOnly) {
            if (null == this.filteredInstanceByPackage) {
                this.filteredInstanceByPackage = this.createFilteredMap(this.instanceByPackage);
            }
            return this.filteredInstanceByPackage;
        }
        return this.instanceByPackage;
    }

    public Map<CategoryKey, Collection<BugInstance>> getInstanceByCategory(boolean coreBugsOnly) {
        this.reallyUpdateMaps();
        if (coreBugsOnly) {
            if (null == this.filteredInstanceByCategory) {
                this.filteredInstanceByCategory = this.createFilteredMap(this.instanceByCategory);
            }
            return this.filteredInstanceByCategory;
        }
        return this.instanceByCategory;
    }

    public Map<BugPattern, Collection<BugInstance>> getInstanceByType(boolean coreBugsOnly) {
        this.reallyUpdateMaps();
        if (coreBugsOnly) {
            if (null == this.filteredInstanceByType) {
                this.filteredInstanceByType = this.createFilteredMap(this.instanceByType);
            }
            return this.filteredInstanceByType;
        }
        return this.instanceByType;
    }

    private <T> Map<T, Collection<BugInstance>> createFilteredMap(Map<T, Collection<BugInstance>> originalMap) {
        TreeMap<T, FilteredCollection<BugInstance>> filteredMap = new TreeMap<T, FilteredCollection<BugInstance>>();
        for (Map.Entry<T, Collection<BugInstance>> entry : originalMap.entrySet()) {
            filteredMap.put(entry.getKey(), new FilteredCollection<BugInstance>(entry.getValue()));
        }
        return filteredMap;
    }

    public long getBugCount() {
        this.reallyUpdateMaps();
        return this.bugCount;
    }

    public long getBugCount(boolean isFilterOn) {
        this.reallyUpdateMaps();
        if (isFilterOn) {
            return this.coreBugCount;
        }
        return this.bugCount;
    }

    public long getCodeDefectCountSum() {
        return this.getBugCount();
    }

    public long getCodeDefectCount(CodeDefectSeverity severity) {
        this.reallyUpdateMaps();
        if (CodeDefectSeverity.INFO == severity) {
            return this.infoBugCount;
        }
        if (CodeDefectSeverity.WARNING == severity) {
            return this.warningBugCount;
        }
        if (CodeDefectSeverity.ERROR == severity) {
            return this.errorBugCount;
        }
        return 0L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CategoryKey
    extends DisplayableKey<CategoryKey> {
        private BugPattern bugPattern;

        public CategoryKey(BugPattern bugPattern) {
            this.bugPattern = bugPattern;
        }

        @Override
        public String getDisplayName() {
            return this.bugPattern.getCategory();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassKey
    extends DisplayableKey<ClassKey> {
        private final ClassAnnotation classAnnotation;
        private final FileObject fileObject;

        public ClassKey(ClassAnnotation classAnnotation, Project project) {
            this.classAnnotation = classAnnotation;
            this.fileObject = BugAnnotationProcessor.findFileObjectForAnnotatedClass(classAnnotation.getClassName(), project);
        }

        @Override
        public String getDisplayName() {
            return this.classAnnotation.getClassName();
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DisplayableKey<T extends DisplayableKey>
    implements Comparable<T> {
        public abstract String getDisplayName();

        public final boolean equals(Object object) {
            if (object instanceof DisplayableKey) {
                return ((DisplayableKey)object).getDisplayName().equals(this.getDisplayName());
            }
            return false;
        }

        public final int hashCode() {
            return this.getDisplayName().hashCode();
        }

        @Override
        public final int compareTo(T object) {
            return this.getDisplayName().compareTo(((DisplayableKey)object).getDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredCollection<T extends BugInstance>
    extends AbstractCollection<T> {
        Collection<T> originalCollection;

        public FilteredCollection(Collection<T> originalCollection) {
            this.originalCollection = originalCollection;
        }

        @Override
        @SuppressWarnings(value={"DLS_DEAD_LOCAL_STORE"})
        public int size() {
            int i = 0;
            for (BugInstance instance : this) {
                ++i;
            }
            return i;
        }

        @Override
        public Iterator<T> iterator() {
            final Iterator<T> origIterator = this.originalCollection.iterator();
            return new Iterator<T>(){
                private T nextObject;
                private boolean hasNext;

                @Override
                public T next() {
                    if (this.hasNext) {
                        return this.nextObject;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    while (origIterator.hasNext()) {
                        this.nextObject = (BugInstance)origIterator.next();
                        BugPattern bugPattern = this.nextObject.getBugPattern();
                        if (!FiBuUtil.isBugPatternIssuedFromCore(bugPattern)) continue;
                        this.hasNext = true;
                        return true;
                    }
                    this.hasNext = false;
                    return false;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        CLASS("HINT_VIEW_BY_CLASS", "org/nbheaven/sqe/tools/findbugs/codedefects/core/resources/class.gif"){

            @Override
            public Map<?, Collection<BugInstance>> getInstanceList(FindBugsResult result, boolean coreBugsOnly) {
                return result.getInstanceByClass(coreBugsOnly);
            }
        }
        ,
        PACKAGE("HINT_VIEW_BY_PACKAGE", "org/nbheaven/sqe/tools/findbugs/codedefects/core/resources/package.gif"){

            @Override
            public Map<?, Collection<BugInstance>> getInstanceList(FindBugsResult result, boolean coreBugsOnly) {
                return result.getInstanceByPackage(coreBugsOnly);
            }
        }
        ,
        CATEGORY("HINT_VIEW_BY_CATEGORY", "edu/umd/cs/findbugs/gui/bug.png"){

            @Override
            public Map<?, Collection<BugInstance>> getInstanceList(FindBugsResult result, boolean coreBugsOnly) {
                return result.getInstanceByCategory(coreBugsOnly);
            }
        }
        ,
        TYPE("HINT_VIEW_BY_CATEGORY", "edu/umd/cs/findbugs/gui/bug2.png"){

            @Override
            public Map<?, Collection<BugInstance>> getInstanceList(FindBugsResult result, boolean coreBugsOnly) {
                return result.getInstanceByType(coreBugsOnly);
            }
        };

        private final String hint;
        private final Icon icon;

        private Mode(String hint, String iconPath) {
            this.hint = hint;
            this.icon = new ImageIcon(ImageUtilities.loadImage((String)iconPath));
        }

        public String getHint() {
            return this.hint;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public abstract Map<?, Collection<BugInstance>> getInstanceList(FindBugsResult var1, boolean var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PackageKey
    extends DisplayableKey<PackageKey> {
        private ClassAnnotation classAnnotation;

        public PackageKey(ClassAnnotation classAnnotation) {
            this.classAnnotation = classAnnotation;
        }

        @Override
        public String getDisplayName() {
            return this.classAnnotation.getPackageName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringKey
    extends DisplayableKey<StringKey> {
        private String displayName;

        public StringKey(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }
    }
}

