/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core;

import edu.umd.cs.findbugs.Project;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nbheaven.sqe.core.java.utils.CompileOnSaveHelper;
import org.nbheaven.sqe.core.java.utils.ProjectUtilities;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsScannerJob;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsSession;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.SourceGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class FindBugsProjectScannerJob
extends FindBugsScannerJob {
    private static final Logger LOG = Logger.getLogger(FindBugsProjectScannerJob.class.getName());
    private final FindBugsSession findBugsSession;

    FindBugsProjectScannerJob(org.netbeans.api.project.Project project) {
        super(project);
        this.findBugsSession = (FindBugsSession)((Object)project.getLookup().lookup(FindBugsSession.class));
    }

    protected void postScan() {
        this.findBugsSession.setResult(this.getResult());
        super.postScan();
        this.findBugsSession.scanningDone();
    }

    protected Project createFindBugsProject() {
        final Project fibuProject = new Project();
        for (SourceGroup g : ProjectUtilities.getJavaSourceGroups((org.netbeans.api.project.Project)this.getProject())) {
            final FileObject fo = g.getRootFolder();
            final ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
            File f = FileUtil.toFile((FileObject)fo);
            if (f != null) {
                LOG.log(Level.FINE, "addSourceDir: {0}", f);
                fibuProject.addSourceDir(f.getAbsolutePath());
            }
            final Callable<Void> r = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    URL url = CompileOnSaveHelper.forSourceRoot((FileObject)fo).binaryRoot(false);
                    if (url != null) {
                        File checkFile = FileUtil.archiveOrDirForURL((URL)url);
                        if (checkFile == null) {
                            LOG.warning("Skipping inconvertible binary entry " + url);
                            return null;
                        }
                        if (!checkFile.exists()) {
                            LOG.warning("Skipping nonexistent binary entry " + checkFile);
                            return null;
                        }
                        LOG.log(Level.FINE, "addFile: {0}", checkFile);
                        fibuProject.addFile(checkFile.getAbsolutePath());
                    }
                    if (null != cp) {
                        for (ClassPath.Entry entry : cp.entries()) {
                            url = entry.getURL();
                            try {
                                url = CompileOnSaveHelper.forClassPathEntry((URL)url).binaryRoot(false);
                            }
                            catch (IOException x) {
                                LOG.log(Level.INFO, null, x);
                            }
                            File checkFile = FileUtil.archiveOrDirForURL((URL)url);
                            if (checkFile == null) {
                                LOG.warning("Skipping inconvertible classpath entry " + url);
                                continue;
                            }
                            if (!checkFile.exists()) {
                                LOG.warning("Skipping nonexistent classpath entry " + checkFile);
                                continue;
                            }
                            LOG.log(Level.FINER, "addAuxClasspathEntry: {0}", checkFile);
                            fibuProject.addAuxClasspathEntry(checkFile.getAbsolutePath());
                        }
                    }
                    return null;
                }
            };
            ClassPath bcp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
            try {
                if (cp != null && bcp != null) {
                    JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)bcp, (ClassPath)cp, (ClassPath)ClassPath.getClassPath((FileObject)fo, (String)"classpath/source")), (FileObject[])new FileObject[0]).runWhenScanFinished((Task)new Task<CompilationController>(){

                        public void run(CompilationController parameter) throws Exception {
                            r.call();
                        }
                    }, true).get();
                    continue;
                }
                r.call();
            }
            catch (Exception x) {
                LOG.log(Level.INFO, null, x);
            }
        }
        return fibuProject;
    }
}

