/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core;

import edu.umd.cs.findbugs.Project;
import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nbheaven.sqe.core.java.utils.CompileOnSaveHelper;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsScannerJob;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class FindBugsFileScannerJob
extends FindBugsScannerJob {
    private static final Logger LOG = Logger.getLogger(FindBugsFileScannerJob.class.getName());
    private final FileObject sourceFile;

    FindBugsFileScannerJob(org.netbeans.api.project.Project project, FileObject sourceFile) {
        super(project);
        this.sourceFile = sourceFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Project createFindBugsProject() {
        Project fibuProject = new Project();
        ClassPath sourcePath = ClassPath.getClassPath((FileObject)this.sourceFile, (String)"classpath/source");
        if (sourcePath == null) {
            return fibuProject;
        }
        for (FileObject sourceRoot : sourcePath.getRoots()) {
            File sourceRootF = FileUtil.toFile((FileObject)sourceRoot);
            if (sourceRootF == null) continue;
            LOG.log(Level.FINER, "addSourceDir: {0}", sourceRootF);
            fibuProject.addSourceDir(sourceRootF.getAbsolutePath());
        }
        FileObject sourceRoot = sourcePath.findOwnerRoot(this.sourceFile);
        String binaryName = sourcePath.getResourceName(this.sourceFile, '/', false);
        try {
            URL binaryRootU = CompileOnSaveHelper.forSourceRoot((FileObject)sourceRoot).binaryRoot(false);
            if (binaryRootU != null && binaryRootU.getProtocol().equals("file")) {
                File binaryRoot = new File(binaryRootU.toURI());
                File clazz = new File(binaryRoot, binaryName + ".class");
                if (!clazz.isFile()) {
                    LOG.log(Level.WARNING, "No such file {0}", clazz);
                    return null;
                }
                LOG.log(Level.FINE, "addFile: {0}", clazz);
                fibuProject.addFile(clazz.getAbsolutePath());
                for (File kid : clazz.getParentFile().listFiles()) {
                    String n = kid.getName();
                    if (!n.endsWith(".class") || !n.startsWith(binaryName.replaceFirst(".+/", "") + "$")) continue;
                    LOG.log(Level.FINE, "addFile: {0}", kid);
                    fibuProject.addFile(kid.getAbsolutePath());
                }
            } else {
                LOG.log(Level.WARNING, "Bad or missing binary root {0} found for {1}", new Object[]{binaryRootU, sourceRoot});
                return null;
            }
            ClassPath cp = ClassPath.getClassPath((FileObject)sourceRoot, (String)"classpath/compile");
            if (cp == null) {
                LOG.log(Level.WARNING, "No compile CP found in {0}", sourceRoot);
                return null;
            }
            for (ClassPath.Entry entry : cp.entries()) {
                URL url = CompileOnSaveHelper.forClassPathEntry((URL)entry.getURL()).binaryRoot(false);
                File checkFile = FileUtil.archiveOrDirForURL((URL)url);
                if (checkFile != null && checkFile.exists()) {
                    LOG.log(Level.FINER, "addAuxClasspathEntry: {0}", checkFile);
                    fibuProject.addAuxClasspathEntry(checkFile.getAbsolutePath());
                    continue;
                }
                LOG.log(Level.WARNING, "Bad file on auxiliary classpath: {0}", checkFile);
            }
            return fibuProject;
        }
        catch (Exception x) {
            LOG.log(Level.INFO, null, x);
            return null;
        }
    }
}

