/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.actions;

import java.io.File;
import java.net.URL;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.jaxb.util.FileSysUtil;
import org.netbeans.modules.xml.jaxb.util.ProjectHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class JAXBRefreshAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        Node node = nodes[0];
        FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
        Project proj = (Project)node.getLookup().lookup(Project.class);
        String origLoc = (String)node.getValue("origLocation");
        Boolean origLocIsURL = (Boolean)node.getValue("orginLocationType");
        FileObject locSchemaRoot = (FileObject)node.getValue("localSchemaRoot");
        if (fo != null && origLoc != null) {
            try {
                if (fo.canWrite()) {
                    if (origLocIsURL.booleanValue()) {
                        URL url = new URL(origLoc);
                        ProjectHelper.retrieveResource(locSchemaRoot, url.toURI());
                    } else {
                        File projDir = FileUtil.toFile((FileObject)proj.getProjectDirectory());
                        File srcFile = FileSysUtil.Relative2AbsolutePath(projDir, origLoc);
                        ProjectHelper.retrieveResource(fo.getParent(), srcFile.toURI());
                    }
                } else {
                    String msg = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_CanNotRefreshFile");
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
                    d.setTitle(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LBL_RefreshFile"));
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                }
            }
            catch (Exception ex) {
                JAXBRefreshAction.log(ex);
            }
        }
    }

    private static void log(Exception ex) {
        Exceptions.printStackTrace((Throwable)ex);
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LBL_NodeRefresh");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] node) {
        return true;
    }
}

