/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.ClusterReceiver;
import org.apache.catalina.cluster.io.ListenCallback;
import org.apache.catalina.cluster.io.ObjectReader;
import org.apache.catalina.cluster.tcp.TcpReplicationThread;
import org.apache.catalina.cluster.tcp.ThreadPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplicationListener
implements Runnable,
ClusterReceiver {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$ReplicationListener == null ? (class$org$apache$catalina$cluster$tcp$ReplicationListener = ReplicationListener.class$("org.apache.catalina.cluster.tcp.ReplicationListener")) : class$org$apache$catalina$cluster$tcp$ReplicationListener));
    private ThreadPool pool = null;
    private boolean doListen = false;
    private ListenCallback callback;
    private InetAddress bind;
    private String tcpListenAddress;
    private int tcpThreadCount;
    private long tcpSelectorTimeout;
    private int tcpListenPort;
    private boolean isSenderSynchronized;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$ReplicationListener;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$TcpReplicationThread;

    public void start() {
        try {
            this.pool = new ThreadPool(this.tcpThreadCount, class$org$apache$catalina$cluster$tcp$TcpReplicationThread == null ? (class$org$apache$catalina$cluster$tcp$TcpReplicationThread = ReplicationListener.class$("org.apache.catalina.cluster.tcp.TcpReplicationThread")) : class$org$apache$catalina$cluster$tcp$TcpReplicationThread);
            if ("auto".equals(this.tcpListenAddress)) {
                this.tcpListenAddress = InetAddress.getLocalHost().getHostAddress();
            }
            this.bind = InetAddress.getByName(this.tcpListenAddress);
            Thread t = new Thread((Runnable)this, "ClusterReceiver");
            t.setDaemon(true);
            t.start();
        }
        catch (Exception x) {
            log.fatal((Object)"Unable to start cluster receiver", (Throwable)x);
        }
    }

    public void stop() {
        this.stopListening();
    }

    public void run() {
        try {
            this.listen();
        }
        catch (Exception x) {
            log.error((Object)"Unable to start cluster listener.", (Throwable)x);
        }
    }

    public void listen() throws Exception {
        this.doListen = true;
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        ServerSocket serverSocket = serverChannel.socket();
        Selector selector = Selector.open();
        serverSocket.bind(new InetSocketAddress(this.bind, this.tcpListenPort));
        serverChannel.configureBlocking(false);
        serverChannel.register(selector, 16);
        while (this.doListen) {
            try {
                int n = selector.select(this.tcpSelectorTimeout);
                if (n == 0) continue;
                Iterator<SelectionKey> it = selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    if (key.isAcceptable()) {
                        ServerSocketChannel server = (ServerSocketChannel)key.channel();
                        SocketChannel channel = server.accept();
                        this.registerChannel(selector, channel, 1, new ObjectReader(channel, selector, this.callback));
                    }
                    if (key.isReadable()) {
                        this.readDataFromSocket(key);
                    } else {
                        key.interestOps(key.interestOps() & ~4);
                    }
                    it.remove();
                }
            }
            catch (CancelledKeyException nx) {
                log.warn((Object)"Replication client disconnected, error when polling key. Ignoring client.");
            }
            catch (Exception x) {
                log.error((Object)"Unable to process request in ReplicationListener", (Throwable)x);
            }
        }
        serverChannel.close();
        selector.close();
    }

    public void stopListening() {
        this.doListen = false;
    }

    public void setCatalinaCluster(CatalinaCluster cluster) {
        this.callback = cluster;
    }

    protected void registerChannel(Selector selector, SelectableChannel channel, int ops, Object attach) throws Exception {
        if (channel == null) {
            return;
        }
        channel.configureBlocking(false);
        channel.register(selector, ops, attach);
    }

    protected void readDataFromSocket(SelectionKey key) throws Exception {
        TcpReplicationThread worker = (TcpReplicationThread)this.pool.getWorker();
        if (worker == null) {
            return;
        }
        worker.serviceChannel(key, this.isSenderSynchronized);
    }

    public String getTcpListenAddress() {
        return this.tcpListenAddress;
    }

    public void setTcpListenAddress(String tcpListenAddress) {
        this.tcpListenAddress = tcpListenAddress;
    }

    public int getTcpListenPort() {
        return this.tcpListenPort;
    }

    public void setTcpListenPort(int tcpListenPort) {
        this.tcpListenPort = tcpListenPort;
    }

    public long getTcpSelectorTimeout() {
        return this.tcpSelectorTimeout;
    }

    public void setTcpSelectorTimeout(long tcpSelectorTimeout) {
        this.tcpSelectorTimeout = tcpSelectorTimeout;
    }

    public int getTcpThreadCount() {
        return this.tcpThreadCount;
    }

    public void setTcpThreadCount(int tcpThreadCount) {
        this.tcpThreadCount = tcpThreadCount;
    }

    public boolean getIsSenderSynchronized() {
        return this.isSenderSynchronized;
    }

    public void setIsSenderSynchronized(boolean isSenderSynchronized) {
        this.isSenderSynchronized = isSenderSynchronized;
    }

    public String getHost() {
        return this.getTcpListenAddress();
    }

    public int getPort() {
        return this.getTcpListenPort();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

