/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.catalina.cluster.util.SmartQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncSocketSender
implements IDataSender {
    private static int threadCounter = 1;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$AsyncSocketSender == null ? (class$org$apache$catalina$cluster$tcp$AsyncSocketSender = AsyncSocketSender.class$("org.apache.catalina.cluster.tcp.AsyncSocketSender")) : class$org$apache$catalina$cluster$tcp$AsyncSocketSender));
    private InetAddress address;
    private int port;
    private Socket sc = null;
    private boolean isSocketConnected = false;
    private SmartQueue queue = new SmartQueue();
    private boolean suspect;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$AsyncSocketSender;

    public AsyncSocketSender(InetAddress host, int port) {
        this.address = host;
        this.port = port;
        QueueThread t = new QueueThread(this);
        t.setDaemon(true);
        t.start();
        log.info((Object)"Started async sender thread for TCP replication.");
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public void connect() throws IOException {
        this.sc = new Socket(this.getAddress(), this.getPort());
        this.isSocketConnected = true;
    }

    public void disconnect() {
        try {
            this.sc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isSocketConnected = false;
    }

    public boolean isConnected() {
        return this.isSocketConnected;
    }

    private synchronized void sendMessage(byte[] data) throws IOException {
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            this.sc.getOutputStream().write(data);
        }
        catch (IOException x) {
            this.disconnect();
            this.connect();
            this.sc.getOutputStream().write(data);
        }
    }

    public synchronized void sendMessage(String sessionId, byte[] data) throws IOException {
        SmartQueue.SmartEntry entry = new SmartQueue.SmartEntry(sessionId, data);
        this.queue.add(entry);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("SocketSender[");
        buf.append(this.getAddress()).append(":").append(this.getPort()).append("]");
        return buf.toString();
    }

    public boolean isSuspect() {
        return this.suspect;
    }

    public boolean getSuspect() {
        return this.suspect;
    }

    public void setSuspect(boolean suspect) {
        this.suspect = suspect;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class QueueThread
    extends Thread {
        AsyncSocketSender sender;

        public QueueThread(AsyncSocketSender sender) {
            this.sender = sender;
            this.setName("Cluster-AsyncSocketSender-" + threadCounter++);
        }

        public void run() {
            while (true) {
                SmartQueue.SmartEntry entry;
                if ((entry = this.sender.queue.remove()) == null) {
                    continue;
                }
                try {
                    byte[] data = (byte[])entry.getValue();
                    this.sender.sendMessage(data);
                    continue;
                }
                catch (Exception x) {
                    log.warn((Object)("Unable to asynchronously send session w/ id=" + entry.getKey() + " message will be ignored."));
                    continue;
                }
                break;
            }
        }
    }
}

