/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.util.HashMap;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.ClusterManager;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.SessionMessage;
import org.apache.catalina.cluster.session.ReplicatedSession;
import org.apache.catalina.cluster.session.ReplicationStream;
import org.apache.catalina.cluster.session.SerializablePrincipal;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.session.StandardManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleTcpReplicationManager
extends StandardManager
implements ClusterManager {
    public static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$session$SimpleTcpReplicationManager == null ? (class$org$apache$catalina$cluster$session$SimpleTcpReplicationManager = SimpleTcpReplicationManager.class$("org.apache.catalina.cluster.session.SimpleTcpReplicationManager")) : class$org$apache$catalina$cluster$session$SimpleTcpReplicationManager));
    protected String mChannelConfig = null;
    protected String mGroupName = "TomcatReplication";
    protected boolean mChannelStarted = false;
    protected boolean mPrintToScreen = true;
    protected boolean mManagerRunning = false;
    protected boolean synchronousReplication = true;
    protected boolean mExpireSessionsOnShutdown = true;
    protected boolean useDirtyFlag = false;
    protected String name;
    protected int debug = 0;
    protected boolean distributable = true;
    protected CatalinaCluster cluster;
    protected HashMap invalidatedSessions = new HashMap();
    protected boolean stateTransferred = false;
    static /* synthetic */ Class class$org$apache$catalina$cluster$session$SimpleTcpReplicationManager;

    public boolean isManagerRunning() {
        return this.mManagerRunning;
    }

    public void setUseDirtyFlag(boolean usedirtyflag) {
        this.useDirtyFlag = usedirtyflag;
    }

    public void setExpireSessionsOnShutdown(boolean expireSessionsOnShutdown) {
        this.mExpireSessionsOnShutdown = expireSessionsOnShutdown;
    }

    public void setCluster(CatalinaCluster cluster) {
        this.log("Cluster associated with SimpleTcpReplicationManager");
        this.cluster = cluster;
    }

    public boolean getExpireSessionsOnShutdown() {
        return this.mExpireSessionsOnShutdown;
    }

    public void setPrintToScreen(boolean printtoscreen) {
        this.log("Setting screen debug to:" + printtoscreen);
        this.mPrintToScreen = printtoscreen;
    }

    public void setSynchronousReplication(boolean flag) {
        this.synchronousReplication = flag;
    }

    public void unload() throws IOException {
        if (!this.getDistributable()) {
            super.unload();
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    protected Session createSession(boolean notify, boolean setId) {
        if (this.getMaxActiveSessions() >= 0 && this.sessions.size() >= this.getMaxActiveSessions()) {
            throw new IllegalStateException(sm.getString("standardManager.createSession.ise"));
        }
        ReplicatedSession session = new ReplicatedSession(this);
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        String sessionId = this.generateSessionId();
        String jvmRoute = this.getJvmRoute();
        if (jvmRoute != null) {
            sessionId = sessionId + '.' + jvmRoute;
        }
        if (setId) {
            session.setId(sessionId);
        }
        if (notify && this.cluster != null) {
            session.setIsDirty(true);
        }
        return session;
    }

    public Session createSession() {
        Session session = this.createSession(this.getDistributable(), true);
        this.add(session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionInvalidated(String sessionId) {
        HashMap hashMap = this.invalidatedSessions;
        synchronized (hashMap) {
            this.invalidatedSessions.put(sessionId, sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getInvalidatedSessions() {
        HashMap hashMap = this.invalidatedSessions;
        synchronized (hashMap) {
            String[] result = new String[this.invalidatedSessions.size()];
            this.invalidatedSessions.values().toArray(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionMessage requestCompleted(String sessionId) {
        block12: {
            if (!this.getDistributable()) {
                log.warn((Object)("Received requestCompleted message, although this context[" + this.getName() + "] is not distributable. Ignoring message"));
                return null;
            }
            try {
                if (this.invalidatedSessions.get(sessionId) != null) {
                    HashMap hashMap = this.invalidatedSessions;
                    synchronized (hashMap) {
                        this.invalidatedSessions.remove(sessionId);
                        SessionMessage msg = new SessionMessage(this.name, 2, null, sessionId);
                        return msg;
                    }
                }
                ReplicatedSession session = (ReplicatedSession)this.findSession(sessionId);
                if (session == null) break block12;
                if (this.useDirtyFlag && !session.isDirty()) {
                    long lastaccdist;
                    long interval = session.getMaxInactiveInterval();
                    if (interval * 1000L / (lastaccdist = System.currentTimeMillis() - session.getLastAccessWasDistributed()) < 3L) {
                        SessionMessage accmsg = new SessionMessage(this.name, 3, null, sessionId);
                        session.setLastAccessWasDistributed(System.currentTimeMillis());
                        return accmsg;
                    }
                    return null;
                }
                session.setIsDirty(false);
                if (this.getDebug() > 5) {
                    try {
                        log.debug((Object)("Sending session to cluster=" + session));
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                SessionMessage msg = new SessionMessage(this.name, 1, this.writeSession(session), session.getId());
                return msg;
            }
            catch (Exception x) {
                this.log("Unable to replicate session", x);
            }
        }
        return null;
    }

    protected byte[] writeSession(Session session) {
        try {
            ByteArrayOutputStream session_data = new ByteArrayOutputStream();
            ObjectOutputStream session_out = new ObjectOutputStream(session_data);
            session_out.flush();
            boolean hasPrincipal = session.getPrincipal() != null;
            session_out.writeBoolean(hasPrincipal);
            if (hasPrincipal) {
                session_out.writeObject(SerializablePrincipal.createPrincipal((GenericPrincipal)session.getPrincipal()));
            }
            ((ReplicatedSession)session).writeObjectData(session_out);
            return session_data.toByteArray();
        }
        catch (Exception x) {
            this.log("Failed to serialize the session!", x, 1);
            return null;
        }
    }

    protected Session readSession(byte[] data, String sessionId) {
        try {
            Session session;
            ByteArrayInputStream session_data = new ByteArrayInputStream(data);
            ReplicationStream session_in = new ReplicationStream(session_data, this.container.getLoader().getClassLoader());
            Session session2 = session = sessionId != null ? this.findSession(sessionId) : null;
            if (session != null) {
                ReplicatedSession rs = (ReplicatedSession)session;
                rs.expire(false);
                session = null;
            }
            if (session == null) {
                session = this.createSession(false, false);
            }
            boolean hasPrincipal = session_in.readBoolean();
            SerializablePrincipal p = null;
            if (hasPrincipal) {
                p = (SerializablePrincipal)session_in.readObject();
            }
            ((ReplicatedSession)session).readObjectData(session_in);
            if (hasPrincipal) {
                session.setPrincipal((Principal)p.getPrincipal(this.getContainer().getRealm()));
            }
            return session;
        }
        catch (Exception x) {
            this.log("Failed to deserialize the session!", x, 1);
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void start() throws LifecycleException {
        this.mManagerRunning = true;
        super.start();
        try {
            if (this.mChannelStarted) {
                return;
            }
            this.log("Starting clustering manager...:" + this.getName(), 1);
            if (this.cluster == null) {
                this.log("Starting... no cluster associated with this context:" + this.getName(), 1);
                return;
            }
            if (this.cluster.getMembers().length > 0) {
                Member mbr = this.cluster.getMembers()[0];
                SessionMessage msg = new SessionMessage(this.getName(), 4, null, "GET-ALL");
                this.cluster.send(msg, mbr);
                log.warn((Object)("Manager[" + this.getName() + "], requesting session state from " + mbr + ". This operation will timeout if no session state has been received within " + "60 seconds"));
                long reqStart = System.currentTimeMillis();
                long reqNow = 0L;
                boolean isTimeout = false;
                do {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception sleep) {
                        // empty catch block
                    }
                    reqNow = System.currentTimeMillis();
                    boolean bl = isTimeout = reqNow - reqStart > 60000L;
                } while (!this.isStateTransferred() && !isTimeout);
                if (isTimeout || !this.isStateTransferred()) {
                    log.error((Object)("Manager[" + this.getName() + "], No session state received, timing out."));
                } else {
                    log.info((Object)("Manager[" + this.getName() + "], session state received in " + (reqNow - reqStart) + " ms."));
                }
            } else {
                log.info((Object)("Manager[" + this.getName() + "], skipping state transfer. No members active in cluster group."));
            }
            this.mChannelStarted = true;
        }
        catch (Exception x) {
            this.log("Unable to start SimpleTcpReplicationManager", x, 1);
        }
    }

    public void stop() throws LifecycleException {
        this.mManagerRunning = false;
        this.mChannelStarted = false;
        super.stop();
    }

    public void setDistributable(boolean dist) {
        this.distributable = dist;
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    protected void messageReceived(SessionMessage msg, Member sender) {
        try {
            this.log("Received SessionMessage of type=" + msg.getEventTypeString(), 3);
            this.log("Received SessionMessage sender=" + sender, 3);
            switch (msg.getEventType()) {
                case 4: {
                    Session[] sessions = this.findSessions();
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    ObjectOutputStream oout = new ObjectOutputStream(bout);
                    oout.writeInt(sessions.length);
                    for (int i = 0; i < sessions.length; ++i) {
                        ReplicatedSession ses = (ReplicatedSession)sessions[i];
                        oout.writeUTF(ses.getId());
                        byte[] data = this.writeSession(ses);
                        oout.writeObject(data);
                    }
                    oout.flush();
                    oout.close();
                    byte[] data = bout.toByteArray();
                    SessionMessage newmsg = new SessionMessage(this.name, 12, data, "");
                    this.cluster.send(newmsg, sender);
                    break;
                }
                case 12: {
                    ByteArrayInputStream bin = new ByteArrayInputStream(msg.getSession());
                    ObjectInputStream oin = new ObjectInputStream(bin);
                    int size = oin.readInt();
                    for (int i = 0; i < size; ++i) {
                        String id = oin.readUTF();
                        byte[] data = (byte[])oin.readObject();
                        Session session = this.readSession(data, id);
                        session.setManager((Manager)this);
                        this.add(session);
                    }
                    this.stateTransferred = true;
                    break;
                }
                case 1: {
                    Session session = this.readSession(msg.getSession(), msg.getSessionID());
                    session.setManager((Manager)this);
                    this.add(session);
                    session.setValid(true);
                    session.access();
                    if (this.getDebug() <= 5) break;
                    this.log("Received replicated session=" + session);
                    break;
                }
                case 2: {
                    Session session = this.findSession(msg.getSessionID());
                    if (session == null) break;
                    session.expire();
                    this.remove(session);
                    break;
                }
                case 3: {
                    Session session = this.findSession(msg.getSessionID());
                    if (session == null) break;
                    session.access();
                    break;
                }
            }
        }
        catch (Exception x) {
            this.log("Unable to receive message through TCP channel", x, 1);
        }
    }

    public void messageDataReceived(SessionMessage msg) {
        try {
            this.messageReceived(msg, msg.getAddress() != null ? msg.getAddress() : null);
        }
        catch (Throwable ex) {
            this.log("InMemoryReplicationManager.messageDataReceived()", ex);
        }
    }

    public boolean isStateTransferred() {
        return this.stateTransferred;
    }

    public void log(String msg) {
        this.log(msg, 3);
    }

    public void log(String msg, Throwable x) {
        this.log(msg, x, 3);
    }

    public void log(String msg, int level) {
        if (this.getDebug() >= level) {
            String lmsg = msg;
            if (this.mPrintToScreen) {
                System.out.println(lmsg);
            }
            log.info((Object)lmsg);
        }
    }

    public void log(String msg, Throwable x, int level) {
        if (this.getDebug() >= level) {
            String lmsg = msg;
            if (this.mPrintToScreen) {
                System.out.println(lmsg);
                x.printStackTrace();
            }
            log.error((Object)lmsg, x);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

