/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.border.IconBorder;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.table.TableColumnExt;
import org.netbeans.modules.db.dataview.table.JXTableDecorator;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;

public final class JXTableRowHeader
extends JComponent {
    private static Icon rightArrow = new Icon(){

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawLine(x + 4, y + 4, x + 4, y + 4);
            g.translate(x + 4, y + 4);
            g.fillPolygon(new Polygon(new int[]{0, 5, 0}, new int[]{-5, 0, 5}, 3));
        }
    };
    private IconBorder iconBorder = new IconBorder();
    private final JXTableDecorator headerTable;
    private JTable table;

    public JTableHeader getTableHeader() {
        JTableHeader header = this.headerTable.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        return header;
    }

    public JXTableRowHeader(JTable table) {
        this.table = table;
        this.headerTable = new JXTableDecorator(table.getModel(), new InternalTableColumnModel(), table.getSelectionModel()){

            public Object getValueAt(int rowIndex, int columnIndex) {
                return JXTableRowHeader.this.getRowName(rowIndex);
            }
        };
        this.setLayout(new GridLayout(1, 1));
        this.headerTable.getModel().addTableModelListener(new HeaderResizeListener());
        this.headerTable.setAutoResizeMode(0);
        this.headerTable.getTableHeader().setReorderingAllowed(false);
        this.headerTable.getTableHeader().setResizingAllowed(false);
        this.headerTable.setSortable(false);
        this.add((Component)((Object)this.headerTable));
        TableColumn column = this.headerTable.getColumnModel().getColumn(0);
        this.headerTable.packAll();
        column.setPreferredWidth(column.getPreferredWidth() + 20);
        column.setCellRenderer(this.createDefaultRenderer());
        this.headerTable.setPreferredScrollableViewportSize(new Dimension(column.getPreferredWidth(), 0));
        this.headerTable.setInheritsPopupMenu(true);
        this.headerTable.setRowHeight(table.getRowHeight());
        this.headerTable.setShowGrid(true, true);
        this.headerTable.setGridColor(ResultSetJXTable.GRID_COLOR);
        this.headerTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)Color.WHITE, (Color)ResultSetJXTable.ALTERNATE_ROW_COLOR)});
        JXTable jxTable = (JXTable)table;
        jxTable.getFilters().addPipelineListener(new PipelineListener(){

            public void contentsChanged(PipelineEvent e) {
                FilterPipeline pipeline = (FilterPipeline)e.getSource();
                JXTableRowHeader.this.headerTable.getFilters().getSortController().setSortKeys(pipeline.getSortController().getSortKeys());
                JXTableRowHeader.this.headerTable.getTableHeader().repaint();
            }
        });
    }

    protected TableCellRenderer createDefaultRenderer() {
        return new RowHeaderColumnRenderer();
    }

    public void setDefaultRenderer(TableCellRenderer defaultRenderer) {
        this.headerTable.getColumn(0).setCellRenderer(defaultRenderer);
    }

    public TableCellRenderer getDefaultRenderer() {
        return this.headerTable.getColumn(0).getCellRenderer();
    }

    public Rectangle getHeaderRect(int row) {
        return this.headerTable.getCellRect(row, 0, true);
    }

    public void setTable(JTable table) {
        this.table = table;
        this.headerTable.setModel(table.getModel());
        this.headerTable.setSelectionModel(table.getSelectionModel());
    }

    public JTable getTable() {
        return this.table;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.headerTable.getToolTipText(event);
    }

    public int rowAtPoint(Point point) {
        return this.headerTable.rowAtPoint(point);
    }

    public String getRowName(int row) {
        return Integer.toString(row + 1);
    }

    private class HeaderResizeListener
    implements TableModelListener {
        private HeaderResizeListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            JXTableRowHeader.this.headerTable.packAll();
            TableColumn column = JXTableRowHeader.this.headerTable.getColumnModel().getColumn(0);
            column.setPreferredWidth(column.getPreferredWidth() + 20);
            if (column.getPreferredWidth() != JXTableRowHeader.this.getWidth()) {
                JXTableRowHeader.this.headerTable.setPreferredScrollableViewportSize(new Dimension(column.getPreferredWidth(), 0));
            }
        }
    }

    private static class InternalTableColumnModel
    extends DefaultTableColumnModel {
        public InternalTableColumnModel() {
            TableColumnExt col = new TableColumnExt(0, 75);
            col.setEditable(false);
            col.setHeaderValue((Object)"#");
            col.setToolTipText("Row Number");
            col.setModelIndex(-1);
            col.setSortable(false);
            this.addColumn((TableColumn)col);
        }
    }

    private class RowHeaderColumnRenderer
    extends DefaultTableRenderer {
        private RowHeaderColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, columnIndex);
            if (isSelected) {
                JXTableRowHeader.this.iconBorder.setIcon(rightArrow);
                Border origBorder = ((JComponent)comp).getBorder();
                CompoundBorder border = new CompoundBorder(origBorder, (Border)JXTableRowHeader.this.iconBorder);
                ((JComponent)comp).setBorder(border);
                comp.setBackground(UIManager.getColor("Table.selectionBackground"));
                comp.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
            return comp;
        }
    }
}

