/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Component;
import java.sql.Clob;
import java.sql.SQLException;
import javax.swing.JTable;
import org.netbeans.modules.db.dataview.table.SQLConstantsCellRenderer;

class ClobCellRenderer
extends SQLConstantsCellRenderer {
    ClobCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof Clob)) {
            throw new IllegalArgumentException("ClobCellRenderer can only be used for Blobs");
        }
        try {
            Long size = ((Clob)value).length();
            StringBuilder stringValue = new StringBuilder();
            stringValue.append("<CLOB ");
            if (size < 1000L) {
                stringValue.append(String.format("%1$d Chars", size));
            } else if (size < 1000000L) {
                stringValue.append(String.format("%1$d kChars", size / 1000L));
            } else {
                stringValue.append(String.format("%1$d MChars", size / 1000000L));
            }
            stringValue.append(">");
            return super.getTableCellRendererComponent(table, stringValue.toString(), isSelected, hasFocus, row, column);
        }
        catch (SQLException ex) {
            return super.getTableCellRendererComponent(table, "<CLOB of unkown size>", isSelected, hasFocus, row, column);
        }
    }
}

