/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Component;
import java.sql.Blob;
import java.sql.SQLException;
import javax.swing.JTable;
import org.netbeans.modules.db.dataview.table.SQLConstantsCellRenderer;

class BlobCellRenderer
extends SQLConstantsCellRenderer {
    BlobCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof Blob)) {
            throw new IllegalArgumentException("BlobCellRenderer can only be used for Blobs");
        }
        try {
            Long size = ((Blob)value).length();
            StringBuilder stringValue = new StringBuilder();
            stringValue.append("<BLOB ");
            if (size < 1000L) {
                stringValue.append(String.format("%1$d bytes", size));
            } else if (size < 1000000L) {
                stringValue.append(String.format("%1$d kB", size / 1000L));
            } else {
                stringValue.append(String.format("%1$d MB", size / 1000000L));
            }
            stringValue.append(">");
            return super.getTableCellRendererComponent(table, stringValue.toString(), isSelected, hasFocus, row, column);
        }
        catch (SQLException ex) {
            return super.getTableCellRendererComponent(table, "<BLOB of unkown size>", isSelected, hasFocus, row, column);
        }
    }
}

