/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewActionHandler;
import org.netbeans.modules.db.dataview.output.DataViewTablePanel;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.output.ShowSQLDialog;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.netbeans.modules.db.dataview.table.ResultSetCellRenderer;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;
import org.netbeans.modules.db.dataview.table.ResultSetTableModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.windows.WindowManager;

final class DataViewTableUI
extends ResultSetJXTable {
    private JPopupMenu tablePopupMenu;
    private final DataViewTablePanel tablePanel;
    private DataViewActionHandler handler;
    private int selectedRow = -1;
    private int selectedColumn = -1;

    public DataViewTableUI(DataViewTablePanel tablePanel, DataViewActionHandler handler, DataView dataView) {
        super(dataView);
        this.tablePanel = tablePanel;
        this.handler = handler;
        TableSelectionListener listener = new TableSelectionListener((JTable)((Object)this));
        this.getSelectionModel().addListSelectionListener(listener);
        this.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        this.addKeyListener(this.createControKeyListener());
        this.createPopupMenu(handler, dataView);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (this.dView.getUpdatedRowContext().hasUpdates(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column))) {
            return new UpdatedResultSetCellRenderer(this.dView);
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    protected KeyListener createControKeyListener() {
        return new Control0KeyListener();
    }

    @Override
    protected DefaultTableModel getDefaultTableModel() {
        return new DataViewTableUIModel(this);
    }

    private void createPopupMenu(final DataViewActionHandler handler, final DataView dataView) {
        this.tablePopupMenu = new JPopupMenu();
        final JMenuItem miInsertAction = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_insert"));
        miInsertAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.insertActionPerformed();
            }
        });
        this.tablePopupMenu.add(miInsertAction);
        final JMenuItem miDeleteAction = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_deleterow"));
        miDeleteAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.deleteRecordActionPerformed();
            }
        });
        this.tablePopupMenu.add(miDeleteAction);
        final JMenuItem miCommitAction = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_commit"));
        miCommitAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.commitActionPerformed(true);
            }
        });
        this.tablePopupMenu.add(miCommitAction);
        final JMenuItem miCancelEdits = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_cancel_edits"));
        miCancelEdits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.cancelEditPerformed(true);
            }
        });
        this.tablePopupMenu.add(miCancelEdits);
        final JMenuItem miTruncateRecord = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_truncate_table"));
        miTruncateRecord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.truncateActionPerformed();
            }
        });
        this.tablePopupMenu.add(miTruncateRecord);
        this.tablePopupMenu.addSeparator();
        JMenuItem miCopyValue = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_copy_cell_value"));
        miCopyValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object o = DataViewTableUI.this.getValueAt(DataViewTableUI.this.selectedRow, DataViewTableUI.this.selectedColumn);
                    String output = o != null ? o.toString() : "";
                    ExClipboard clipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
                    StringSelection strSel = new StringSelection(output);
                    clipboard.setContents((Transferable)strSel, (ClipboardOwner)strSel);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        this.tablePopupMenu.add(miCopyValue);
        JMenuItem miCopyRowValues = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_copy_row_value"));
        miCopyRowValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataViewTableUI.this.copyRowValues(false);
            }
        });
        this.tablePopupMenu.add(miCopyRowValues);
        JMenuItem miCopyRowValuesH = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_copy_row_header"));
        miCopyRowValuesH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataViewTableUI.this.copyRowValues(true);
            }
        });
        this.tablePopupMenu.add(miCopyRowValuesH);
        this.tablePopupMenu.addSeparator();
        final JMenuItem miCreateSQLScript = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_create_sql"));
        miCreateSQLScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DBTable table = dataView.getDataViewDBTable().geTable(0);
                    String createSQL = dataView.getSQLStatementGenerator().generateCreateStatement(table);
                    ShowSQLDialog dialog = new ShowSQLDialog();
                    dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                    dialog.setText(createSQL + ";\n");
                    dialog.setVisible(true);
                }
                catch (Exception ex) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ex.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            }
        });
        this.tablePopupMenu.add(miCreateSQLScript);
        final JMenuItem miInsertSQLScript = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_insert_sql"));
        miInsertSQLScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int[] rows = DataViewTableUI.this.getSelectedRows();
                    String insertSQL = "";
                    for (int j = 0; j < rows.length; ++j) {
                        int modelIndex = DataViewTableUI.this.convertRowIndexToModel(rows[j]);
                        Object[] insertRow = dataView.getDataViewPageContext().getCurrentRows().get(modelIndex);
                        String sql = dataView.getSQLStatementGenerator().generateRawInsertStatement(insertRow);
                        insertSQL = insertSQL + sql.replaceAll("\n", "").replaceAll("\t", "") + ";\n";
                    }
                    ShowSQLDialog dialog = new ShowSQLDialog();
                    dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                    dialog.setText(insertSQL);
                    dialog.setVisible(true);
                }
                catch (DBException ex) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ex.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            }
        });
        this.tablePopupMenu.add(miInsertSQLScript);
        final JMenuItem miDeleteSQLScript = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_delete_sql"));
        miDeleteSQLScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = DataViewTableUI.this.getSelectedRows();
                String rawDeleteStmt = "";
                for (int j = 0; j < rows.length; ++j) {
                    SQLStatementGenerator generator = dataView.getSQLStatementGenerator();
                    int modelIndex = DataViewTableUI.this.convertRowIndexToModel(rows[j]);
                    String deleteStmt = generator.generateDeleteStatement(modelIndex, DataViewTableUI.this.getModel());
                    rawDeleteStmt = rawDeleteStmt + deleteStmt + ";\n";
                }
                ShowSQLDialog dialog = new ShowSQLDialog();
                dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                dialog.setText(rawDeleteStmt);
                dialog.setVisible(true);
            }
        });
        this.tablePopupMenu.add(miDeleteSQLScript);
        final JMenuItem miCommitSQLScript = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_update_sql"));
        miCommitSQLScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String rawUpdateStmt = "";
                UpdatedRowContext updatedRowCtx = dataView.getUpdatedRowContext();
                SQLStatementGenerator generator = dataView.getSQLStatementGenerator();
                try {
                    for (Integer row : updatedRowCtx.getUpdateKeys()) {
                        Map<Integer, Object> changedData = updatedRowCtx.getChangedData(row);
                        rawUpdateStmt = rawUpdateStmt + generator.generateUpdateStatement(row, changedData, DataViewTableUI.this.dataModel) + ";\n";
                    }
                    ShowSQLDialog dialog = new ShowSQLDialog();
                    dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                    dialog.setText(rawUpdateStmt);
                    dialog.setVisible(true);
                }
                catch (DBException ex) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ex.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            }
        });
        this.tablePopupMenu.add(miCommitSQLScript);
        this.tablePopupMenu.addSeparator();
        JMenuItem printTable = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_print_data"));
        printTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Logger mLogger = Logger.getLogger(DataViewTableUI.class.getName());
                try {
                    if (!DataViewTableUI.this.print()) {
                        mLogger.log(Level.INFO, NbBundle.getMessage(DataViewTableUI.class, (String)"MSG_cancel_printing"));
                    }
                }
                catch (PrinterException ex) {
                    mLogger.log(Level.INFO, NbBundle.getMessage(DataViewTableUI.class, (String)("MSG_failure_to_print" + ex.getMessage())));
                }
            }
        });
        this.tablePopupMenu.add(printTable);
        JMenuItem miRefreshAction = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_refresh"));
        miRefreshAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.refreshActionPerformed();
            }
        });
        this.tablePopupMenu.add(miRefreshAction);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    DataViewTableUI.this.selectedRow = DataViewTableUI.this.rowAtPoint(e.getPoint());
                    DataViewTableUI.this.selectedColumn = DataViewTableUI.this.columnAtPoint(e.getPoint());
                    boolean inSelection = false;
                    int[] rows = DataViewTableUI.this.getSelectedRows();
                    for (int a = 0; a < rows.length; ++a) {
                        if (rows[a] != DataViewTableUI.this.selectedRow) continue;
                        inSelection = true;
                        break;
                    }
                    if (!DataViewTableUI.this.getRowSelectionAllowed()) {
                        inSelection = false;
                        int[] columns = DataViewTableUI.this.getSelectedColumns();
                        for (int a = 0; a < columns.length; ++a) {
                            if (columns[a] != DataViewTableUI.this.selectedColumn) continue;
                            inSelection = true;
                            break;
                        }
                    }
                    if (!inSelection) {
                        DataViewTableUI.this.changeSelection(DataViewTableUI.this.selectedRow, DataViewTableUI.this.selectedColumn, false, false);
                    }
                    if (!DataViewTableUI.this.tablePanel.isEditable()) {
                        miInsertAction.setEnabled(false);
                        miDeleteAction.setEnabled(false);
                        miTruncateRecord.setEnabled(false);
                        miInsertSQLScript.setEnabled(false);
                        miCreateSQLScript.setEnabled(false);
                        miDeleteSQLScript.setEnabled(false);
                    }
                    if (!DataViewTableUI.this.tablePanel.isCommitEnabled()) {
                        miCommitAction.setEnabled(false);
                        miCancelEdits.setEnabled(false);
                        miCommitSQLScript.setEnabled(false);
                    } else {
                        miCommitAction.setEnabled(true);
                        miCancelEdits.setEnabled(true);
                        miCommitSQLScript.setEnabled(true);
                    }
                    DataViewTableUI.this.tablePopupMenu.show((Component)((Object)DataViewTableUI.this), e.getX(), e.getY());
                }
            }
        });
    }

    private void copyRowValues(boolean withHeader) {
        try {
            int[] columns;
            int[] rows = this.getSelectedRows();
            if (this.getRowSelectionAllowed()) {
                columns = new int[this.getColumnCount()];
                for (int a = 0; a < columns.length; ++a) {
                    columns[a] = a;
                }
            } else {
                columns = this.getSelectedColumns();
            }
            if (rows != null && columns != null) {
                StringBuilder output = new StringBuilder();
                if (withHeader) {
                    for (int column = 0; column < columns.length; ++column) {
                        Object o;
                        if (column > 0) {
                            output.append('\t');
                        }
                        output.append((o = this.getColumnModel().getColumn(column).getIdentifier()) != null ? o.toString() : "");
                    }
                    output.append('\n');
                }
                for (int row = 0; row < rows.length; ++row) {
                    for (int column = 0; column < columns.length; ++column) {
                        Object o;
                        if (column > 0) {
                            output.append('\t');
                        }
                        output.append((o = this.getValueAt(rows[row], columns[column])) != null ? o.toString() : "");
                    }
                    output.append('\n');
                }
                ExClipboard clipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
                StringSelection strSel = new StringSelection(output.toString());
                clipboard.setContents((Transferable)strSel, (ClipboardOwner)strSel);
            }
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            Exceptions.printStackTrace((Throwable)exc);
        }
    }

    private class Control0KeyListener
    implements KeyListener {
        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isControlDown() && e.getKeyCode() == 127) {
                TableCellEditor editor = DataViewTableUI.this.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                }
                DataViewTableUI.this.handler.deleteRecordActionPerformed();
            } else if (e.isControlDown() && e.getKeyChar() == '0') {
                int row = DataViewTableUI.this.getSelectedRow();
                int col = DataViewTableUI.this.getSelectedColumn();
                if (row == -1) {
                    return;
                }
                DBColumn dbcol = DataViewTableUI.this.getDBColumn(col);
                if (dbcol.isGenerated() || !dbcol.isNullable()) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    DataViewTableUI.this.setValueAt("<NULL>", row, col);
                }
                DataViewTableUI.this.setRowSelectionInterval(row, row);
            } else if (e.isControlDown() && e.getKeyChar() == '1') {
                int row = DataViewTableUI.this.getSelectedRow();
                int col = DataViewTableUI.this.getSelectedColumn();
                if (row == -1) {
                    return;
                }
                DBColumn dbcol = DataViewTableUI.this.getDBColumn(col);
                Object val = DataViewTableUI.this.getValueAt(row, col);
                if (dbcol.isGenerated() || !dbcol.hasDefault()) {
                    Toolkit.getDefaultToolkit().beep();
                } else if (val != null && val instanceof String && ((String)val).equals("<DEFAULT>")) {
                    DataViewTableUI.this.setValueAt(null, row, col);
                } else {
                    DataViewTableUI.this.setValueAt("<DEFAULT>", row, col);
                }
                DataViewTableUI.this.setRowSelectionInterval(row, row);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class DataViewTableUIModel
    extends ResultSetTableModel {
        protected DataViewTableUIModel(ResultSetJXTable table) {
            super(table);
        }

        @Override
        protected void handleColumnUpdated(int row, int col, Object value) {
            DataViewTableUI.this.dView.getUpdatedRowContext().addUpdates(row, col, value, DataViewTableUI.this.getModel());
            DataViewTableUI.this.tablePanel.handleColumnUpdated();
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        JTable table;

        TableSelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (DataViewTableUI.this.tablePanel == null) {
                return;
            }
            if (e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                int first = e.getFirstIndex();
                if (first >= 0 && DataViewTableUI.this.tablePanel.isEditable()) {
                    DataViewTableUI.this.tablePanel.enableDeleteBtn(true);
                } else {
                    DataViewTableUI.this.tablePanel.enableDeleteBtn(false);
                }
            }
        }
    }

    private static class UpdatedResultSetCellRenderer
    extends ResultSetCellRenderer {
        static Color green = new Color(0, 128, 0);
        static Color gray = new Color(245, 245, 245);
        DataView dataView;

        public UpdatedResultSetCellRenderer(DataView dView) {
            this.dataView = dView;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Object obj = this.dataView.getDataViewPageContext().getColumnData(table.convertRowIndexToModel(row), table.convertColumnIndexToModel(column));
            if (isSelected) {
                if (obj == null && value == null || obj != null && value != null && value.equals(obj)) {
                    c.setForeground(gray);
                } else {
                    c.setForeground(Color.ORANGE);
                }
            } else if (obj == null && value == null || obj != null && value != null && value.equals(obj)) {
                c.setForeground(table.getForeground());
            } else {
                c.setForeground(green);
            }
            return c;
        }
    }
}

