/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewUI;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class DataView {
    private DatabaseConnection dbConn;
    private List<Throwable> errMessages = new ArrayList<Throwable>();
    private String sqlString;
    private DataViewDBTable tblMeta;
    private SQLStatementGenerator stmtGenerator;
    private SQLExecutionHelper execHelper;
    private DataViewPageContext dataPage;
    private DataViewUI dataViewUI;
    private boolean nbOutputComponent = false;
    private boolean hasResultSet = false;
    private int updateCount;
    private long executionTime;
    private boolean supportsLimit = false;

    public static DataView create(DatabaseConnection dbConn, String sqlString, int pageSize) {
        assert (dbConn != null);
        DataView dv = new DataView();
        dv.dbConn = dbConn;
        dv.sqlString = sqlString.trim();
        dv.nbOutputComponent = false;
        try {
            dv.dataPage = new DataViewPageContext(pageSize);
            dv.execHelper = new SQLExecutionHelper(dv);
            dv.execHelper.initialDataLoad();
            dv.stmtGenerator = new SQLStatementGenerator(dv);
        }
        catch (Exception ex) {
            dv.setErrorStatusText(ex);
        }
        return dv;
    }

    public static DataView create(DatabaseConnection dbConn, String sqlString, int pageSize, boolean nbOutputComponent) {
        DataView dataView = DataView.create(dbConn, sqlString, pageSize);
        dataView.nbOutputComponent = nbOutputComponent;
        return dataView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Component> createComponents() {
        if (!this.hasResultSet) {
            return Collections.emptyList();
        }
        DataView dataView = this;
        synchronized (dataView) {
            this.dataViewUI = new DataViewUI(this, this.nbOutputComponent);
            this.setRowsInTableModel();
            this.dataViewUI.setEditable(this.tblMeta == null ? false : this.tblMeta.hasOneTable());
            this.resetToolbar(this.hasExceptions());
        }
        ArrayList<Component> results = new ArrayList<Component>();
        results.add((Component)((Object)this.dataViewUI));
        return results;
    }

    public boolean hasExceptions() {
        return !this.errMessages.isEmpty();
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    public Collection<Throwable> getExceptions() {
        return Collections.unmodifiableCollection(this.errMessages);
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public JButton[] getEditButtons() {
        assert (this.nbOutputComponent);
        return this.dataViewUI.getEditButtons();
    }

    public synchronized void setEditable(boolean editable) {
        this.dataViewUI.setEditable(editable);
    }

    public DataViewDBTable getDataViewDBTable() {
        return this.tblMeta;
    }

    DataViewPageContext getDataViewPageContext() {
        return this.dataPage;
    }

    DatabaseConnection getDatabaseConnection() {
        return this.dbConn;
    }

    String getSQLString() {
        return this.sqlString;
    }

    UpdatedRowContext getUpdatedRowContext() {
        return this.dataViewUI.getUpdatedRowContext();
    }

    SQLExecutionHelper getSQLExecutionHelper() {
        if (this.execHelper == null) {
            this.execHelper = new SQLExecutionHelper(this);
        }
        return this.execHelper;
    }

    SQLStatementGenerator getSQLStatementGenerator() {
        if (this.stmtGenerator == null) {
            this.stmtGenerator = new SQLStatementGenerator(this);
        }
        return this.stmtGenerator;
    }

    public boolean isEditable() {
        return this.dataViewUI.isEditable();
    }

    boolean isLimitSupported() {
        return this.supportsLimit;
    }

    synchronized void disableButtons() {
        assert (this.dataViewUI != null);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                DataView.this.dataViewUI.disableButtons();
            }
        });
        this.errMessages.clear();
    }

    synchronized void removeComponents() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                if (DataView.this.dataViewUI != null) {
                    if (DataView.this.dataViewUI.getParent() != null) {
                        DataView.this.dataViewUI.getParent().setVisible(false);
                    }
                    DataView.this.dataViewUI.removeAll();
                    DataView.this.dataViewUI.repaint();
                    DataView.this.dataViewUI.revalidate();
                }
            }
        });
    }

    void setInfoStatusText(String statusText) {
        if (statusText != null) {
            StatusDisplayer.getDefault().setStatusText(statusText);
        }
    }

    synchronized void setErrorStatusText(Throwable ex) {
        if (ex != null) {
            if (ex instanceof DBException && ex.getCause() instanceof SQLException) {
                this.errMessages.add(ex.getCause());
            }
            this.errMessages.add(ex);
            String title = NbBundle.getMessage(DataView.class, (String)"MSG_error");
            StatusDisplayer.getDefault().setStatusText(title + ": " + ex.getMessage());
        }
    }

    synchronized void setErrorStatusText(String message, Throwable ex) {
        if (ex != null) {
            this.errMessages.add(ex);
        }
        String title = NbBundle.getMessage(DataView.class, (String)"MSG_error");
        StatusDisplayer.getDefault().setStatusText(title + ": " + message);
    }

    void resetToolbar(final boolean wasError) {
        assert (this.dataViewUI != null);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                DataView.this.dataViewUI.resetToolbar(wasError);
            }
        });
    }

    void setLimitSupported(boolean supportsLimit) {
        this.supportsLimit = supportsLimit;
    }

    void setRowsInTableModel() {
        assert (this.dataViewUI != null);
        assert (this.dataPage != null);
        if (this.dataPage.getCurrentRows() != null) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    DataView.this.dataViewUI.setDataRows(DataView.this.dataPage.getCurrentRows());
                    DataView.this.dataViewUI.setTotalCount(DataView.this.dataPage.getTotalRows());
                }
            });
        }
    }

    synchronized void incrementRowSize(int count) {
        assert (this.dataViewUI != null);
        this.dataPage.setTotalRows(this.dataPage.getTotalRows() + count);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                DataView.this.dataViewUI.setTotalCount(DataView.this.dataPage.getTotalRows());
            }
        });
    }

    synchronized void decrementRowSize(int count) {
        assert (this.dataViewUI != null);
        this.dataPage.decrementRowSize(count);
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                DataView.this.dataViewUI.setTotalCount(DataView.this.dataPage.getTotalRows());
            }
        });
    }

    synchronized void syncPageWithTableModel() {
        this.dataViewUI.syncPageWithTableModel();
    }

    void setHasResultSet(boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
    }

    void setUpdateCount(int updateCount) {
        this.updateCount = updateCount;
    }

    void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    void setDataViewDBTable(DataViewDBTable tblMeta) {
        this.tblMeta = tblMeta;
    }

    private DataView() {
    }

    public int getPageSize() {
        if (this.dataViewUI == null) {
            return -1;
        }
        return this.dataViewUI.getPageSize();
    }
}

