/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.ControlAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class DebugAction
extends ControlAction {
    public String getName() {
        return NbBundle.getMessage(DebugAction.class, (String)"LBL_Debug");
    }

    protected void performAction(Node[] nodes) {
        DebugAction.performActionImpl(nodes);
    }

    protected boolean enable(Node[] nodes) {
        return DebugAction.enableImpl(nodes);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static void performActionImpl(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            ServerInstance si = (ServerInstance)nodes[i].getCookie(ServerInstance.class);
            DebugAction.performActionImpl(si);
        }
    }

    private static void performActionImpl(final ServerInstance si) {
        if (si != null) {
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String title = NbBundle.getMessage(DebugAction.class, (String)"LBL_Debugging", (Object)si.getDisplayName());
                    ProgressUI progressUI = new ProgressUI(title, false);
                    try {
                        progressUI.start();
                        si.startDebug(progressUI);
                    }
                    catch (ServerException ex) {
                        String msg = ex.getLocalizedMessage();
                        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    }
                    finally {
                        progressUI.finish();
                    }
                }
            });
        }
    }

    private static boolean enableImpl(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            ServerInstance si = (ServerInstance)nodes[i].getCookie(ServerInstance.class);
            if (DebugAction.enableImpl(si)) continue;
            return false;
        }
        return true;
    }

    private static boolean enableImpl(ServerInstance si) {
        return si != null && si.getServerState() == 2 && si.isDebugSupported();
    }

    public static class OutputAction
    extends AbstractAction
    implements ServerInstance.StateListener {
        private static final String ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/debug.png";
        private static final String PROP_ENABLED = "enabled";
        private final ServerInstance instance;

        public OutputAction(ServerInstance instance) {
            super(NbBundle.getMessage(DebugAction.class, (String)"LBL_DebugOutput"), ImageUtilities.loadImageIcon((String)ICON, (boolean)false));
            this.putValue("ShortDescription", NbBundle.getMessage(DebugAction.class, (String)"LBL_DebugOutputDesc"));
            this.instance = instance;
            instance.addStateListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DebugAction.performActionImpl(this.instance);
        }

        @Override
        public boolean isEnabled() {
            return DebugAction.enableImpl(this.instance);
        }

        @Override
        public void stateChanged(int oldState, int newState) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    OutputAction.this.firePropertyChange(OutputAction.PROP_ENABLED, null, OutputAction.this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                }
            });
        }
    }
}

