/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.BinaryElementOpen;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.ui.JavaTypeDescription;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClassIndexManagerEvent;
import org.netbeans.modules.java.source.usages.ClassIndexManagerListener;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.jumpto.support.NameMatcherFactory;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JavaTypeProvider
implements TypeProvider {
    private static final Logger LOGGER = Logger.getLogger(JavaTypeProvider.class.getName());
    private Set<CacheItem> cache;
    private volatile boolean isCanceled = false;
    private final TypeElementFinder.Customizer customizer;
    private ClasspathInfo cpInfo;
    private static final Level LEVEL = Level.FINE;

    public String name() {
        return "java";
    }

    public String getDisplayName() {
        return "Java Classes";
    }

    public void cleanup() {
        this.isCanceled = false;
        this.setCache(null);
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public JavaTypeProvider() {
        this(null, null);
    }

    public JavaTypeProvider(ClasspathInfo cpInfo, TypeElementFinder.Customizer customizer) {
        this.cpInfo = cpInfo;
        this.customizer = customizer;
    }

    public void computeTypeNames(TypeProvider.Context context, TypeProvider.Result res) {
        String textForQuery;
        Set<CacheItem> c;
        ClassIndex.NameKind nameKind;
        this.isCanceled = false;
        String text = context.getText();
        SearchType searchType = context.getSearchType();
        boolean hasBinaryOpen = Lookup.getDefault().lookup(BinaryElementOpen.class) != null;
        switch (searchType) {
            case EXACT_NAME: {
                nameKind = ClassIndex.NameKind.SIMPLE_NAME;
                break;
            }
            case CASE_INSENSITIVE_EXACT_NAME: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case PREFIX: {
                nameKind = ClassIndex.NameKind.PREFIX;
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
                break;
            }
            case REGEXP: {
                nameKind = ClassIndex.NameKind.REGEXP;
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case CAMEL_CASE: {
                nameKind = ClassIndex.NameKind.CAMEL_CASE;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected search type: " + searchType);
            }
        }
        Future openProjectsTask = OpenProjects.getDefault().openProjects();
        try {
            openProjectsTask.get();
        }
        catch (InterruptedException ex) {
            LOGGER.fine(ex.getMessage());
        }
        catch (ExecutionException ex) {
            LOGGER.fine(ex.getMessage());
        }
        if (this.getCache() == null) {
            HashSet<CacheItem> sources = null;
            if (this.cpInfo == null) {
                sources = new HashSet<CacheItem>();
                Collection srcRoots = QuerySupport.findRoots((Project)null, Collections.singleton("classpath/source"), Collections.emptySet(), Collections.emptySet());
                for (FileObject root : srcRoots) {
                    URL rootUrl;
                    if (this.isCanceled) {
                        return;
                    }
                    try {
                        rootUrl = root.getURL();
                    }
                    catch (FileStateInvalidException fsie) {
                        continue;
                    }
                    if (this.isCanceled) {
                        return;
                    }
                    sources.add(new CacheItem(rootUrl, "classpath/source"));
                }
                Collection binRoots = QuerySupport.findRoots((Project)null, Collections.emptySet(), Collections.emptySet(), Arrays.asList("classpath/compile", "classpath/boot"));
                for (FileObject root : binRoots) {
                    SourceForBinaryQuery.Result result;
                    URL rootUrl;
                    if (this.isCanceled) {
                        return;
                    }
                    try {
                        rootUrl = root.getURL();
                    }
                    catch (FileStateInvalidException fsie) {
                        continue;
                    }
                    if (!hasBinaryOpen && (result = SourceForBinaryQuery.findSourceRoots((URL)rootUrl)).getRoots().length == 0) continue;
                    if (this.isCanceled) {
                        return;
                    }
                    sources.add(new CacheItem(rootUrl, "classpath/boot"));
                }
            } else {
                List bootRoots = this.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT).entries();
                List compileRoots = this.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE).entries();
                List sourceRoots = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).entries();
                sources = new HashSet(bootRoots.size() + compileRoots.size() + sourceRoots.size());
                for (ClassPath.Entry entry : bootRoots) {
                    if (this.isCanceled) {
                        return;
                    }
                    sources.add(new CacheItem(entry.getURL(), "classpath/boot"));
                }
                for (ClassPath.Entry entry : compileRoots) {
                    if (this.isCanceled) {
                        return;
                    }
                    sources.add(new CacheItem(entry.getURL(), "classpath/compile"));
                }
                for (ClassPath.Entry entry : sourceRoots) {
                    if (this.isCanceled) {
                        return;
                    }
                    sources.add(new CacheItem(entry.getURL(), "classpath/source"));
                }
            }
            if (!this.isCanceled) {
                if (LOGGER.isLoggable(LEVEL)) {
                    LOGGER.log(LEVEL, "Querying following roots:");
                    for (CacheItem ci : sources) {
                        try {
                            LOGGER.log(LEVEL, "  {0}; binary={1}", new Object[]{ci.getRoot().getURL(), ci.isBinary()});
                        }
                        catch (FileStateInvalidException ex) {}
                    }
                    LOGGER.log(LEVEL, "-------------------------");
                }
                this.setCache(sources);
            } else {
                return;
            }
        }
        if ((c = this.getCache()) == null) {
            return;
        }
        final ArrayList<JavaTypeDescription> types = new ArrayList<JavaTypeDescription>(c.size() * 20);
        boolean scanInProgress = SourceUtils.isScanInProgress();
        if (scanInProgress) {
            String message = NbBundle.getMessage(JavaTypeProvider.class, (String)"LBL_ScanInProgress_warning");
            res.setMessage(message);
        } else {
            res.setMessage(null);
        }
        switch (nameKind) {
            case REGEXP: 
            case CASE_INSENSITIVE_REGEXP: {
                text = JavaTypeProvider.removeNonJavaChars(text);
                textForQuery = NameMatcherFactory.wildcardsToRegexp((String)text, (searchType != SearchType.CASE_INSENSITIVE_EXACT_NAME ? 1 : 0) != 0);
                break;
            }
            default: {
                textForQuery = text;
            }
        }
        LOGGER.log(Level.FINE, "Text For Query ''{0}''.", text);
        if (this.customizer != null) {
            c = this.getCache();
            if (c != null) {
                for (CacheItem ci : c) {
                    HashSet<ElementHandle<TypeElement>> names = new HashSet<ElementHandle<TypeElement>>(this.customizer.query(ci.getClasspathInfo(), textForQuery, nameKind, EnumSet.of(ci.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE)));
                    if (nameKind == ClassIndex.NameKind.CAMEL_CASE) {
                        names.addAll(this.customizer.query(ci.getClasspathInfo(), textForQuery, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, EnumSet.of(ci.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE)));
                    }
                    for (ElementHandle elementHandle : names) {
                        JavaTypeDescription td = new JavaTypeDescription(ci, (ElementHandle<TypeElement>)elementHandle);
                        types.add(td);
                        if (!this.isCanceled) continue;
                        return;
                    }
                }
            }
        } else {
            ClassIndexManager.getDefault().addClassIndexManagerListener(new ClassIndexManagerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void classIndexAdded(ClassIndexManagerEvent event) {
                    JavaTypeProvider javaTypeProvider = JavaTypeProvider.this;
                    synchronized (javaTypeProvider) {
                        JavaTypeProvider.this.notify();
                    }
                }

                public void classIndexRemoved(ClassIndexManagerEvent event) {
                }
            });
            do {
                if ((c = this.getCache()) == null) {
                    return;
                }
                try {
                    IndexManager.priorityAccess((IndexManager.Action)new IndexManager.Action<Void>(){

                        public Void run() throws IOException, InterruptedException {
                            for (CacheItem ci : JavaTypeProvider.this.getCache()) {
                                if (JavaTypeProvider.this.isCanceled) {
                                    return null;
                                }
                                HashSet<ElementHandle<TypeElement>> names = new HashSet<ElementHandle<TypeElement>>(ci.getDeclaredTypes(textForQuery, nameKind));
                                if (nameKind == ClassIndex.NameKind.CAMEL_CASE) {
                                    names.addAll(ci.getDeclaredTypes(textForQuery, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX));
                                }
                                for (ElementHandle elementHandle : names) {
                                    JavaTypeDescription td = new JavaTypeDescription(ci, (ElementHandle<TypeElement>)elementHandle);
                                    types.add(td);
                                    if (!JavaTypeProvider.this.isCanceled) continue;
                                    return null;
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (this.isCanceled) {
                    return;
                }
                if (!types.isEmpty() || !scanInProgress) continue;
                res.pendingResult();
                return;
            } while ((scanInProgress = SourceUtils.isScanInProgress()) && types.isEmpty());
        }
        if (!this.isCanceled) {
            res.addResult(types);
        }
    }

    static String removeNonJavaChars(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '*' && c != '?') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private Set<CacheItem> getCache() {
        if (this.cache == null && LOGGER.isLoggable(LEVEL)) {
            LOGGER.log(LEVEL, "Returning null cache entries.", new Exception());
        }
        return this.cache;
    }

    private void setCache(Set<CacheItem> cache) {
        if (LOGGER.isLoggable(LEVEL)) {
            LOGGER.log(LEVEL, "Setting cache entries from " + this.cache + " to " + cache + ".", new Exception());
        }
        this.cache = cache;
    }

    static final class CacheItem {
        public final URL root;
        public String projectName;
        public Icon projectIcon;
        private final boolean isBinary;
        private ClasspathInfo cpInfo;
        private ClassIndex index;
        private final String cpType;
        private FileObject cachedRoot;

        public CacheItem(URL root, String cpType) {
            this.cpType = cpType;
            this.isBinary = "classpath/boot".equals(cpType) || "classpath/compile".equals(cpType);
            this.root = root;
        }

        public int hashCode() {
            return this.root == null ? 0 : this.root.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof CacheItem) {
                CacheItem otherItem = (CacheItem)other;
                return this.root == null ? otherItem.root == null : this.root.equals(otherItem.root);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject getRoot() {
            CacheItem cacheItem = this;
            synchronized (cacheItem) {
                if (this.cachedRoot != null) {
                    return this.cachedRoot;
                }
            }
            FileObject _tmp = URLMapper.findFileObject((URL)this.root);
            CacheItem cacheItem2 = this;
            synchronized (cacheItem2) {
                if (this.cachedRoot == null) {
                    this.cachedRoot = _tmp;
                }
            }
            return _tmp;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        public synchronized String getProjectName() {
            if (!this.isBinary && this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        public synchronized Icon getProjectIcon() {
            if (!this.isBinary && this.projectIcon == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        public ClasspathInfo getClasspathInfo() {
            if (this.cpInfo == null) {
                ClassPath cp = ClassPathSupport.createClassPath((URL[])new URL[]{this.root});
                this.cpInfo = this.isBinary ? ("classpath/boot".equals(this.cpType) ? ClasspathInfo.create((ClassPath)cp, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY) : ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)cp, (ClassPath)ClassPath.EMPTY)) : ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)cp);
            }
            return this.cpInfo;
        }

        public Set<ElementHandle<TypeElement>> getDeclaredTypes(String name, ClassIndex.NameKind kind) {
            if (this.index == null) {
                ClassPath cp = ClassPathSupport.createClassPath((URL[])new URL[]{this.root});
                this.index = this.isBinary ? ("classpath/boot".equals(this.cpType) ? JavaSourceAccessor.getINSTANCE().createClassIndex(cp, ClassPath.EMPTY, ClassPath.EMPTY, false) : JavaSourceAccessor.getINSTANCE().createClassIndex(ClassPath.EMPTY, cp, ClassPath.EMPTY, false)) : JavaSourceAccessor.getINSTANCE().createClassIndex(ClassPath.EMPTY, ClassPath.EMPTY, cp, false);
            }
            return this.index.getDeclaredTypes(name, kind, EnumSet.of(this.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE));
        }

        private void initProjectInfo() {
            try {
                Project p = FileOwnerQuery.getOwner((URI)this.root.toURI());
                if (p != null) {
                    ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                    this.projectName = pi.getDisplayName();
                    this.projectIcon = pi.getIcon();
                }
            }
            catch (URISyntaxException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }
}

