/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.awt.Toolkit;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.java.source.ui.JavaTypeProvider;
import org.netbeans.modules.java.ui.Icons;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JavaTypeDescription
extends TypeDescriptor {
    private static final String EMPTY_STRING = "";
    private Icon icon;
    private final JavaTypeProvider.CacheItem cacheItem;
    private final ElementHandle<TypeElement> handle;
    private String simpleName;
    private String outerName;
    private String packageName;

    public JavaTypeDescription(JavaTypeProvider.CacheItem cacheItem, ElementHandle<TypeElement> handle) {
        this.cacheItem = cacheItem;
        this.handle = handle;
        this.init();
    }

    public void open() {
        FileObject root = this.cacheItem.getRoot();
        if (root == null) {
            String message = NbBundle.getMessage(JavaTypeDescription.class, (String)"LBL_JavaTypeDescription_nosource", (Object)this.handle.getQualifiedName());
            StatusDisplayer.getDefault().setStatusText(message);
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        ClasspathInfo ci = ClasspathInfo.create((FileObject)root);
        if (this.cacheItem.isBinary()) {
            ElementHandle<TypeElement> eh = this.handle;
            if (!ElementOpen.open(ci, eh)) {
                String message = NbBundle.getMessage(JavaTypeDescription.class, (String)"LBL_JavaTypeDescription_nosource", (Object)eh.getQualifiedName());
                StatusDisplayer.getDefault().setStatusText(message);
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            FileObject file = SourceUtils.getFile(this.handle, (ClasspathInfo)ci);
            boolean opened = false;
            if (file != null) {
                opened = ElementOpen.open(file, this.handle);
            }
            if (!opened) {
                StringBuilder name = new StringBuilder();
                if (this.packageName != null) {
                    name.append(this.packageName);
                    name.append('.');
                }
                if (this.outerName != null) {
                    name.append(this.outerName);
                } else {
                    name.append(this.simpleName);
                }
                String message = NbBundle.getMessage(JavaTypeDescription.class, (String)"LBL_JavaTypeDescription_nosource", (Object)name.toString());
                StatusDisplayer.getDefault().setStatusText(message);
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getOuterName() {
        return this.outerName;
    }

    public FileObject getFileObject() {
        return this.cacheItem.getRoot();
    }

    public String getTypeName() {
        StringBuilder sb = new StringBuilder(this.simpleName);
        if (this.outerName != null) {
            sb.append(" in ").append(this.outerName);
        }
        return sb.toString();
    }

    public String getContextName() {
        StringBuilder sb = new StringBuilder();
        sb.append(" (").append(this.packageName == null ? "Default Package" : this.packageName).append(")");
        return sb.toString();
    }

    public String getProjectName() {
        String projectName = this.cacheItem.getProjectName();
        return projectName == null ? EMPTY_STRING : projectName;
    }

    public Icon getProjectIcon() {
        return this.cacheItem.getProjectIcon();
    }

    public ElementHandle<TypeElement> getHandle() {
        return this.handle;
    }

    private void init() {
        String typeName = this.handle.getBinaryName();
        int lastDot = typeName.lastIndexOf(46);
        int lastDollar = typeName.lastIndexOf(36);
        if (lastDot == -1) {
            if (lastDollar == -1) {
                this.simpleName = typeName;
            } else {
                this.simpleName = typeName.substring(lastDollar + 1);
                this.outerName = typeName.substring(0, lastDollar).replace('$', '.');
            }
        } else {
            this.packageName = typeName.substring(0, lastDot);
            if (lastDollar < lastDot) {
                this.simpleName = typeName.substring(lastDot + 1).replace('$', '.');
            } else {
                this.simpleName = typeName.substring(lastDollar + 1);
                this.outerName = typeName.substring(lastDot + 1, lastDollar).replace('$', '.');
            }
        }
        this.icon = Icons.getElementIcon((ElementKind)this.handle.getKind(), null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.simpleName);
        if (this.outerName != null) {
            sb.append(" in ").append(this.outerName);
        }
        sb.append(" (").append(this.packageName == null ? "Default Package" : this.packageName).append(")");
        if (this.cacheItem.getProjectName() != null) {
            sb.append(" [").append(this.cacheItem.getProjectName()).append("]");
        }
        return sb.toString();
    }

    public synchronized Icon getIcon() {
        return this.icon;
    }

    public int getOffset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

