/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform.registration;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.javafx2.platform.Utils;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public class PlatformAutoInstaller
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger("javafx");

    @Override
    public void run() {
        JavaPlatform[] platforms;
        for (JavaPlatform javaPlatform : platforms = JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!JavaFXPlatformUtils.isJavaFXEnabled(javaPlatform)) continue;
            return;
        }
        PlatformAutoInstaller.createRegisteredJavaFXPlatform();
    }

    @CheckForNull
    public static JavaPlatform createRegisteredJavaFXPlatform() {
        FileObject installedSDK = PlatformAutoInstaller.findInstalledSDK();
        if (installedSDK == null) {
            LOGGER.log(Level.INFO, "Can't find auto registered JavaFX SDK instance");
            return null;
        }
        return PlatformAutoInstaller.createJavaFXPlatform(installedSDK);
    }

    private static FileObject findInstalledSDK() {
        FileObject[] instanceFOs;
        FileObject installedSDK = null;
        FileObject dir = PlatformAutoInstaller.getRepositoryDir("JavaFX/Instances", false);
        if (dir != null && (instanceFOs = dir.getChildren()) != null && instanceFOs.length > 0) {
            for (int i = 0; i < instanceFOs.length; ++i) {
                if (!"javafx_sdk_autoregistered_instance".equals(instanceFOs[i].getName())) continue;
                installedSDK = instanceFOs[i];
            }
        }
        return installedSDK;
    }

    private static FileObject getRepositoryDir(String path, boolean create) {
        FileObject dir = FileUtil.getConfigFile((String)path);
        if (dir == null && create) {
            try {
                dir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)path);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        return dir;
    }

    @CheckForNull
    private static JavaPlatform createJavaFXPlatform(FileObject installedSDK) {
        Parameters.notNull((CharSequence)"installedSDK", (Object)installedSDK);
        String sdkPath = PlatformAutoInstaller.getStringAttribute(installedSDK, "javafxSDK");
        String runtimePath = PlatformAutoInstaller.getStringAttribute(installedSDK, "javafxRuntime");
        if (sdkPath == null || runtimePath == null) {
            LOGGER.log(Level.FINE, "Can't read attributes from auto registered JavaFX SDK instance: {0}", installedSDK.getPath());
            return null;
        }
        if (sdkPath == null || runtimePath == null) {
            LOGGER.log(Level.FINE, "Can't read attributes from auto registered JavaFX SDK instance: {0}", installedSDK.getPath());
            return null;
        }
        if (!JavaFXPlatformUtils.areJFXLocationsCorrect(sdkPath, runtimePath)) {
            LOGGER.log(Level.FINE, "JavaFX SDK and/or JavaFX Runtime locations are not correct");
            return null;
        }
        JavaPlatform platform = null;
        try {
            platform = Utils.createJavaFXPlatform(Utils.DEFAULT_FX_PLATFORM_NAME, sdkPath, runtimePath, JavaFXPlatformUtils.predictJavadocLocation(sdkPath), JavaFXPlatformUtils.predictSourcesLocation(sdkPath));
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Can't create Java Platform instance: {0}", ex);
        }
        if (platform != null) {
            LOGGER.log(Level.INFO, "JavaFX Platform instance has been successfully registered: {0}", platform);
        }
        return platform;
    }

    private static String getStringAttribute(FileObject fo, String attrName) {
        return PlatformAutoInstaller.getStringAttribute(fo, attrName, null);
    }

    private static String getStringAttribute(FileObject fo, String attrName, String defValue) {
        String result = defValue;
        Object attr = fo.getAttribute(attrName);
        if (attr instanceof String) {
            result = (String)attr;
        }
        return result;
    }
}

