/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform.registration;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class AutomaticRegistration {
    public static final String JAVAFX_SDK_AUTOREGISTERED_INSTANCE = "javafx_sdk_autoregistered_instance";
    static final String CONFIG = "JavaFX/Instances";
    static final String SDK_ATTR = "javafxSDK";
    static final String RUNTIME_ATTR = "javafxRuntime";
    private static final Logger LOGGER = Logger.getLogger("javafx");

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Parameters: <ide clusterDir> <JavaFX SDK path> <JavaFX Runtime path>");
            System.exit(-1);
        }
        System.out.println(Arrays.toString(args));
        int status = AutomaticRegistration.autoregisterFXSDKInstance(args[0], args[1], args[2]);
        System.exit(status);
    }

    private static int autoregisterFXSDKInstance(String clusterDirValue, String sdkPath, String rtPath) throws IOException {
        System.setProperty("netbeans.user", clusterDirValue);
        FileObject sdkInstanceDir = FileUtil.getConfigFile((String)CONFIG);
        if (sdkInstanceDir == null && (sdkInstanceDir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)CONFIG)) == null) {
            LOGGER.log(Level.INFO, "Cannot register the default JavaFX SDK. The config/JavaFX/Instances folder cannot be created.");
            return 2;
        }
        for (FileObject fo : sdkInstanceDir.getChildren()) {
            if (!fo.getAttribute(SDK_ATTR).equals(sdkPath)) continue;
            return 0;
        }
        boolean ok = AutomaticRegistration.registerFXSDKInstanceFO(sdkInstanceDir, sdkPath, rtPath);
        if (ok) {
            return 0;
        }
        return 3;
    }

    private static boolean registerFXSDKInstanceFO(FileObject sdkInstanceDir, String sdkPath, String rtPath) {
        String name = FileUtil.findFreeFileName((FileObject)sdkInstanceDir, (String)JAVAFX_SDK_AUTOREGISTERED_INSTANCE, null);
        try {
            FileObject instanceFO = sdkInstanceDir.createData(name);
            instanceFO.setAttribute(SDK_ATTR, (Object)sdkPath);
            instanceFO.setAttribute(RUNTIME_ATTR, (Object)rtPath);
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Cannot register the default JavaFX SDK.");
            LOGGER.log(Level.INFO, null, e);
            return false;
        }
    }
}

