/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.javafx2.platform.PlatformPropertiesHandler;
import org.netbeans.modules.javafx2.platform.Utils;
import org.netbeans.modules.javafx2.platform.registration.PlatformAutoInstaller;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Parameters;

public final class JavaFXPlatformUtils {
    public static final String PLATFORM_ANT_NAME = "platform.ant.name";
    public static final String PROPERTY_JAVAFX_RUNTIME = "javafx.runtime";
    public static final String PROPERTY_JAVAFX_SDK = "javafx.sdk";
    public static final String PROPERTY_JAVA_FX = "javafx";
    public static final String[] KNOWN_JFX_LOCATIONS = new String[]{(System.getenv("ProgramFiles") != null ? System.getenv("ProgramFiles") : "C:\\Program Files") + "\\Oracle", (System.getenv("ProgramFiles(x86)") != null ? System.getenv("ProgramFiles(x86)") : "C:\\Program Files (x86)") + "\\Oracle", File.separatorChar + "Library" + File.separatorChar + "Java" + File.separatorChar + "JavaVirtualMachines"};
    private static final String MAC_JDK_SUBDIR = File.separatorChar + "Contents" + File.separatorChar + "Home";
    private static final String JAVADOC_ONLINE_URL = "http://docs.oracle.com/javafx/2/api/";

    private JavaFXPlatformUtils() {
    }

    public static boolean isJavaFXEnabled(@NullAllowed JavaPlatform platform) {
        if (platform == null) {
            return false;
        }
        EditableProperties properties = PlatformPropertiesHandler.getGlobalProperties();
        String sdkPath = properties.get((Object)Utils.getSDKPropertyKey(platform));
        String runtimePath = properties.get((Object)Utils.getRuntimePropertyKey(platform));
        return sdkPath != null && runtimePath != null;
    }

    @CheckForNull
    public static String getJavaFXRuntimePath(@NonNull String platformName) {
        return PlatformPropertiesHandler.getGlobalProperties().get((Object)Utils.getRuntimePropertyKey(platformName));
    }

    @NonNull
    public static String getJavaFXRuntimePathReference(@NonNull String platformName) {
        Parameters.notNull((CharSequence)"platformName", (Object)platformName);
        return String.format("${platforms.%s.javafx.runtime.home}", platformName);
    }

    @CheckForNull
    public static String getJavaFXSDKPath(@NonNull String platformName) {
        return PlatformPropertiesHandler.getGlobalProperties().get((Object)Utils.getSDKPropertyKey(platformName));
    }

    @NonNull
    public static String getJavaFXSDKPathReference(@NonNull String platformName) {
        Parameters.notNull((CharSequence)"platformName", (Object)platformName);
        return String.format("${platforms.%s.javafx.sdk.home}", platformName);
    }

    @NonNull
    public static String[] getJavaFXClassPath() {
        return new String[]{"${javafx.runtime}/lib/jfxrt.jar:", "${javafx.runtime}/lib/deploy.jar:", "${javafx.runtime}/lib/javaws.jar:", "${javafx.runtime}/lib/plugin.jar"};
    }

    public static boolean isThereAnyJavaFXPlatform() {
        JavaPlatform[] platforms;
        for (JavaPlatform javaPlatform : platforms = JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!JavaFXPlatformUtils.isJavaFXEnabled(javaPlatform)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public static JavaPlatform createDefaultJavaFXPlatform() throws IOException, IllegalArgumentException {
        String sdkPath = null;
        String runtimePath = null;
        String javadocPath = null;
        String srcPath = null;
        JavaPlatform registered = PlatformAutoInstaller.createRegisteredJavaFXPlatform();
        if (registered != null) {
            return registered;
        }
        Set<String> locations = JavaFXPlatformUtils.getLocations(JavaPlatformManager.getDefault().getDefaultPlatform());
        for (String path : locations.toArray(new String[0])) {
            if (sdkPath == null) {
                sdkPath = JavaFXPlatformUtils.predictSDKLocation(path);
            }
            if (runtimePath == null) {
                runtimePath = JavaFXPlatformUtils.predictRuntimeLocation(path);
            }
            if (sdkPath == null || runtimePath == null) continue;
            if (javadocPath == null) {
                javadocPath = JavaFXPlatformUtils.predictJavadocLocation(sdkPath);
            }
            if (srcPath != null) break;
            srcPath = JavaFXPlatformUtils.predictSourcesLocation(sdkPath);
            break;
        }
        if (sdkPath != null && runtimePath != null) {
            return Utils.createJavaFXPlatform(Utils.DEFAULT_FX_PLATFORM_NAME, sdkPath, runtimePath, javadocPath, srcPath);
        }
        return null;
    }

    @CheckForNull
    public static Set<String> getLocations(JavaPlatform platform) {
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        Collection roots = platform.getInstallFolders();
        for (FileObject root : roots) {
            assert (root != null && root.isFolder());
            locations.add(root.getPath());
        }
        LinkedHashSet<String> parentLocations = new LinkedHashSet<String>();
        for (FileObject root : roots) {
            FileObject parent = root.getParent();
            if (parent == null) continue;
            parentLocations.add(parent.getPath());
            if ((parent = parent.getParent()) == null || (parent = parent.getParent()) == null) continue;
            parentLocations.add(parent.getPath());
        }
        SpecificationVersion ver = platform.getSpecification().getVersion();
        if (ver.equals((Object)new SpecificationVersion("1.6"))) {
            locations.addAll(Arrays.asList(KNOWN_JFX_LOCATIONS));
            locations.addAll(parentLocations);
        } else {
            locations.addAll(parentLocations);
            locations.addAll(Arrays.asList(KNOWN_JFX_LOCATIONS));
        }
        return locations;
    }

    @CheckForNull
    public static String predictSDKLocation(@NonNull String path) {
        File location = new File(path);
        if (location.exists()) {
            ArrayList<File> locations = new ArrayList<File>();
            locations.add(location);
            File[] children = location.listFiles();
            if (children != null) {
                locations.addAll(Arrays.asList(children));
            }
            for (File file : locations) {
                if (JavaFXPlatformUtils.isSdkPathCorrect(file)) {
                    return file.getAbsolutePath();
                }
                File macSubDir = new File(file.getAbsolutePath() + MAC_JDK_SUBDIR);
                if (!JavaFXPlatformUtils.isSdkPathCorrect(macSubDir)) continue;
                return macSubDir.getAbsolutePath();
            }
        }
        return null;
    }

    @CheckForNull
    public static String predictRuntimeLocation(@NonNull String path) {
        File location = new File(path);
        if (location.exists()) {
            ArrayList<File> locations = new ArrayList<File>();
            locations.add(location);
            File[] children = location.listFiles();
            if (children == null) {
                return null;
            }
            for (File child : Arrays.asList(children)) {
                File macSubDir;
                locations.add(child);
                File[] f = child.listFiles();
                if (f != null) {
                    locations.addAll(Arrays.asList(f));
                }
                if (!(macSubDir = new File(child.getAbsolutePath() + MAC_JDK_SUBDIR)).exists()) continue;
                locations.add(macSubDir);
                f = macSubDir.listFiles();
                if (f == null) continue;
                locations.addAll(Arrays.asList(f));
            }
            for (File file : locations) {
                if (!JavaFXPlatformUtils.isRuntimePathCorrect(file)) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    @CheckForNull
    public static String predictJavadocLocation(@NonNull String path) {
        File location = new File(path);
        if (location.exists()) {
            ArrayList<File> locations = new ArrayList<File>();
            locations.add(location);
            File[] children = location.listFiles();
            if (children == null) {
                return null;
            }
            locations.addAll(Arrays.asList(children));
            for (File file : locations) {
                File docs = new File(file.getAbsolutePath() + File.separatorChar + "docs" + File.separatorChar + "api");
                if (docs.exists()) {
                    return docs.getAbsolutePath();
                }
                docs = new File(file.getAbsolutePath() + MAC_JDK_SUBDIR + File.separatorChar + "docs" + File.separatorChar + "api");
                if (!docs.exists()) continue;
                return docs.getAbsolutePath();
            }
        }
        return JAVADOC_ONLINE_URL;
    }

    @CheckForNull
    public static String predictSourcesLocation(@NonNull String path) {
        return null;
    }

    public static boolean areJFXLocationsCorrect(@NonNull String sdkPath, @NonNull String runtimePath) {
        return JavaFXPlatformUtils.isSdkPathCorrect(sdkPath) && JavaFXPlatformUtils.isRuntimePathCorrect(runtimePath);
    }

    public static boolean isSdkPathCorrect(@NonNull String sdkPath) {
        if (sdkPath.isEmpty()) {
            return false;
        }
        File file = new File(sdkPath);
        if (!file.exists()) {
            return false;
        }
        return JavaFXPlatformUtils.isSdkPathCorrect(file);
    }

    public static boolean isSdkPathCorrect(@NonNull File file) {
        File toolsJar = new File(file.getAbsolutePath() + File.separatorChar + "lib" + File.separatorChar + "ant-javafx.jar");
        if (!toolsJar.exists()) {
            toolsJar = new File(file.getAbsolutePath() + File.separatorChar + "tools" + File.separatorChar + "ant-javafx.jar");
        }
        return toolsJar.exists();
    }

    public static boolean isRuntimePathCorrect(@NonNull String runtimePath) {
        if (runtimePath.isEmpty()) {
            return false;
        }
        File file = new File(runtimePath);
        if (!file.exists()) {
            return false;
        }
        return JavaFXPlatformUtils.isRuntimePathCorrect(file);
    }

    public static boolean isRuntimePathCorrect(@NonNull File file) {
        File rtJar = new File(file.getAbsolutePath() + File.separatorChar + "lib" + File.separatorChar + "jfxrt.jar");
        return rtJar.exists();
    }
}

