/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform;

import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public final class PlatformPropertiesHandler {
    private PlatformPropertiesHandler() {
    }

    @NonNull
    public static EditableProperties getGlobalProperties() {
        return PropertyUtils.getGlobalProperties();
    }

    public static void saveGlobalProperties(final @NonNull Map<String, String> propMap) {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() throws Exception {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    for (Map.Entry entry : propMap.entrySet()) {
                        props.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException me) {
            ErrorManager.getDefault().notify((Throwable)me.getException());
        }
    }

    public static void clearGlobalPropertiesForPlatform(final @NonNull JavaPlatform platform) {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() throws Exception {
                    String platformName = (String)platform.getProperties().get("platform.ant.name");
                    String propPrefix = "platforms." + platformName + ".javafx.";
                    boolean changed = false;
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    Iterator it = props.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        if (!key.startsWith(propPrefix)) continue;
                        it.remove();
                        changed = true;
                    }
                    if (changed) {
                        PropertyUtils.putGlobalProperties((EditableProperties)props);
                    }
                    return null;
                }
            });
        }
        catch (MutexException me) {
            ErrorManager.getDefault().notify((Throwable)me.getException());
        }
    }
}

