/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.platform;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.javafx2.platform.PlatformPropertiesHandler;
import org.netbeans.modules.javafx2.platform.Utils;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaFXPlatformCustomizer
extends JPanel
implements Customizer,
DocumentListener {
    private JavaPlatform platform;
    private File lastUsedRTFolder = null;
    private File lastUsedSDKFolder = null;
    private JButton browseJavadocButton;
    private JButton browseRuntimeButton;
    private JButton browseSDKButton;
    private JButton browseSourcesButton;
    private JCheckBox enableCheckBox;
    private JLabel javadocLabel;
    private JTextField javadocTextField;
    private JLabel messageLabel;
    private JLabel runtimeLabel;
    private JTextField runtimeTextField;
    private JLabel sdkLabel;
    private JTextField sdkTextField;
    private JLabel srcLabel;
    private JTextField srcTextField;

    public JavaFXPlatformCustomizer() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        this.sdkTextField.getDocument().addDocumentListener(this);
        this.runtimeTextField.getDocument().addDocumentListener(this);
        this.javadocTextField.getDocument().addDocumentListener(this);
        this.srcTextField.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.enableCheckBox = new JCheckBox();
        this.sdkLabel = new JLabel();
        this.javadocLabel = new JLabel();
        this.srcLabel = new JLabel();
        this.sdkTextField = new JTextField();
        this.javadocTextField = new JTextField();
        this.srcTextField = new JTextField();
        this.browseSDKButton = new JButton();
        this.browseJavadocButton = new JButton();
        this.browseSourcesButton = new JButton();
        this.messageLabel = new JLabel();
        this.runtimeLabel = new JLabel();
        this.runtimeTextField = new JTextField();
        this.browseRuntimeButton = new JButton();
        this.enableCheckBox.setText(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"JavaFXPlatformCustomizer.enableCheckBox.text"));
        this.enableCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JavaFXPlatformCustomizer.this.enableCheckBoxItemStateChanged(evt);
            }
        });
        this.sdkLabel.setText(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"JavaFXPlatformCustomizer.sdkLabel.text"));
        this.javadocLabel.setText(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"JavaFXPlatformCustomizer.javadocLabel.text"));
        this.srcLabel.setText(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"JavaFXPlatformCustomizer.srcLabel.text"));
        this.sdkTextField.setEnabled(false);
        this.javadocTextField.setEnabled(false);
        this.srcTextField.setEnabled(false);
        this.browseSDKButton.setText(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"JavaFXPlatformCustomizer.browseSDKButton.text"));
        this.browseSDKButton.setEnabled(false);
        this.browseSDKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaFXPlatformCustomizer.this.browseSDKButtonActionPerformed(evt);
            }
        });
        this.browseJavadocButton.setText(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"JavaFXPlatformCustomizer.browseJavadocButton.text"));
        this.browseJavadocButton.setEnabled(false);
        this.browseJavadocButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaFXPlatformCustomizer.this.browseJavadocButtonActionPerformed(evt);
            }
        });
        this.browseSourcesButton.setText(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"JavaFXPlatformCustomizer.browseSourcesButton.text"));
        this.browseSourcesButton.setEnabled(false);
        this.browseSourcesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaFXPlatformCustomizer.this.browseSourcesButtonActionPerformed(evt);
            }
        });
        this.messageLabel.setForeground(Color.red);
        this.messageLabel.setText(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"JavaFXPlatformCustomizer.messageLabel.text"));
        this.runtimeLabel.setText(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"JavaFXPlatformCustomizer.runtimeLabel.text"));
        this.runtimeTextField.setEnabled(false);
        this.browseRuntimeButton.setText(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"JavaFXPlatformCustomizer.browseRuntimeButton.text"));
        this.browseRuntimeButton.setEnabled(false);
        this.browseRuntimeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaFXPlatformCustomizer.this.browseRuntimeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enableCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.srcLabel, -1, -1, Short.MAX_VALUE).addComponent(this.sdkLabel, -1, -1, Short.MAX_VALUE).addComponent(this.runtimeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.javadocLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.srcTextField, -1, 296, Short.MAX_VALUE).addComponent(this.javadocTextField, -1, 296, Short.MAX_VALUE).addComponent(this.runtimeTextField, -1, 296, Short.MAX_VALUE).addComponent(this.sdkTextField, -1, 296, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browseSourcesButton, GroupLayout.Alignment.TRAILING).addComponent(this.browseJavadocButton, GroupLayout.Alignment.TRAILING).addComponent(this.browseRuntimeButton, GroupLayout.Alignment.TRAILING).addComponent(this.browseSDKButton, GroupLayout.Alignment.TRAILING)))))).addContainerGap()));
        layout.linkSize(0, this.browseJavadocButton, this.browseSDKButton, this.browseSourcesButton);
        layout.linkSize(0, this.javadocLabel, this.runtimeLabel, this.sdkLabel, this.srcLabel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.enableCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sdkLabel).addComponent(this.browseSDKButton).addComponent(this.sdkTextField, -2, -1, -2)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseRuntimeButton).addComponent(this.runtimeLabel).addComponent(this.runtimeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseJavadocButton).addComponent(this.javadocLabel).addComponent(this.javadocTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.srcLabel).addComponent(this.browseSourcesButton).addComponent(this.srcTextField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.messageLabel).addContainerGap(25, Short.MAX_VALUE)));
    }

    private void enableCheckBoxItemStateChanged(ItemEvent evt) {
        this.sdkTextField.setEnabled(this.enableCheckBox.isSelected());
        this.runtimeTextField.setEnabled(this.enableCheckBox.isSelected());
        this.javadocTextField.setEnabled(this.enableCheckBox.isSelected());
        this.srcTextField.setEnabled(this.enableCheckBox.isSelected());
        this.browseSDKButton.setEnabled(this.enableCheckBox.isSelected());
        this.browseRuntimeButton.setEnabled(this.enableCheckBox.isSelected());
        this.browseJavadocButton.setEnabled(this.enableCheckBox.isSelected());
        this.browseSourcesButton.setEnabled(this.enableCheckBox.isSelected());
        if (this.enableCheckBox.isSelected()) {
            if (this.isPlatformValid()) {
                this.clearErrorMessage();
                this.saveProperties();
            } else {
                this.predictProperties();
                if (this.isPlatformValid()) {
                    this.clearErrorMessage();
                    this.saveProperties();
                } else {
                    this.setErrorMessage();
                }
            }
        } else {
            this.clearErrorMessage();
            this.clearProperties();
        }
    }

    private void predictProperties() {
        File runtimeDir;
        File sdkDir;
        String sdkPath = null;
        String runtimePath = null;
        String javadocPath = null;
        String srcPath = null;
        Set<String> locations = JavaFXPlatformUtils.getLocations(this.platform);
        for (String path : locations.toArray(new String[0])) {
            if (sdkPath == null) {
                sdkPath = JavaFXPlatformUtils.predictSDKLocation(path);
            }
            if (runtimePath == null) {
                runtimePath = JavaFXPlatformUtils.predictRuntimeLocation(path);
            }
            if (sdkPath == null || runtimePath == null) continue;
            if (javadocPath == null) {
                javadocPath = JavaFXPlatformUtils.predictJavadocLocation(sdkPath);
            }
            if (srcPath != null) break;
            srcPath = JavaFXPlatformUtils.predictSourcesLocation(sdkPath);
            break;
        }
        this.sdkTextField.setText(sdkPath == null ? "" : sdkPath);
        this.runtimeTextField.setText(runtimePath == null ? "" : runtimePath);
        this.javadocTextField.setText(javadocPath == null ? "" : javadocPath);
        this.srcTextField.setText(srcPath == null ? "" : srcPath);
        if (sdkPath != null && (sdkDir = new File(sdkPath)).exists()) {
            this.lastUsedSDKFolder = sdkDir.getParentFile();
        }
        if (runtimePath != null && (runtimeDir = new File(runtimePath)).exists()) {
            this.lastUsedRTFolder = runtimeDir.getParentFile();
        }
    }

    private void browseSDKButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        if (this.lastUsedSDKFolder != null) {
            chooser.setCurrentDirectory(this.lastUsedSDKFolder);
        } else {
            String workDir = this.sdkTextField.getText();
            if (workDir.length() == 0) {
                File defaultFolder = new File(JavaFXPlatformUtils.KNOWN_JFX_LOCATIONS[0]);
                if (defaultFolder.exists()) {
                    chooser.setCurrentDirectory(defaultFolder);
                } else {
                    FileObject platformFolder = (FileObject)this.platform.getInstallFolders().iterator().next();
                    chooser.setCurrentDirectory(FileUtil.toFile((FileObject)platformFolder));
                }
            } else {
                chooser.setCurrentDirectory(new File(workDir));
            }
        }
        chooser.setDialogTitle(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"Customizer_SDK_Folder_Browse_Title"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            if (!file.exists() || !JavaFXPlatformUtils.isSdkPathCorrect(file)) {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"WARN_InvalidSDKPath", (Object)file.getAbsolutePath()), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                return;
            }
            this.lastUsedSDKFolder = file.getParentFile();
            this.sdkTextField.setText(file.getAbsolutePath());
            String javadocLocation = JavaFXPlatformUtils.predictJavadocLocation(file.getPath());
            this.javadocTextField.setText(javadocLocation == null ? "" : javadocLocation);
            String srcLocation = JavaFXPlatformUtils.predictSourcesLocation(file.getPath());
            this.srcTextField.setText(srcLocation == null ? "" : srcLocation);
            String runtimeLocation = JavaFXPlatformUtils.predictRuntimeLocation(file.getPath());
            if (runtimeLocation == null) {
                runtimeLocation = JavaFXPlatformUtils.predictRuntimeLocation(file.getParent());
            }
            if (!JavaFXPlatformUtils.isRuntimePathCorrect(this.runtimeTextField.getText())) {
                this.runtimeTextField.setText(runtimeLocation);
                File rtDir = new File(runtimeLocation);
                if (rtDir.exists()) {
                    this.lastUsedRTFolder = rtDir.getParentFile();
                }
            } else {
                File rtDir = new File(runtimeLocation);
                if (rtDir.exists() && FileUtil.isParentOf((FileObject)FileUtil.toFileObject((File)file), (FileObject)FileUtil.toFileObject((File)rtDir))) {
                    NotifyDescriptor d = new NotifyDescriptor((Object)NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"MSG_RTfoundInSubDir"), NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"MSG_RTfoundInSubDirDialogTitle"), 0, 3, null, NotifyDescriptor.YES_OPTION);
                    if (DialogDisplayer.getDefault().notify(d) == NotifyDescriptor.YES_OPTION) {
                        this.runtimeTextField.setText(runtimeLocation);
                        this.lastUsedRTFolder = rtDir.getParentFile();
                    }
                }
            }
        }
    }

    private void browseRuntimeButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        if (this.lastUsedRTFolder != null) {
            chooser.setCurrentDirectory(this.lastUsedRTFolder);
        } else {
            String workDir = this.runtimeTextField.getText();
            if (workDir.length() == 0) {
                File defaultFolder = new File(JavaFXPlatformUtils.KNOWN_JFX_LOCATIONS[0]);
                if (defaultFolder.exists()) {
                    chooser.setCurrentDirectory(defaultFolder);
                } else {
                    FileObject platformFolder = (FileObject)this.platform.getInstallFolders().iterator().next();
                    chooser.setCurrentDirectory(FileUtil.toFile((FileObject)platformFolder));
                }
            } else {
                chooser.setCurrentDirectory(new File(workDir));
            }
        }
        chooser.setDialogTitle(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"Customizer_Runtime_Folder_Browse_Title"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.lastUsedRTFolder = file.getParentFile();
            this.runtimeTextField.setText(file.getAbsolutePath());
        }
    }

    private void browseJavadocButtonActionPerformed(ActionEvent evt) {
        String workDir;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        if (this.lastUsedSDKFolder != null) {
            chooser.setCurrentDirectory(this.lastUsedSDKFolder);
        } else {
            workDir = this.javadocTextField.getText();
            if (workDir.length() == 0) {
                File defaultFolder = new File(JavaFXPlatformUtils.KNOWN_JFX_LOCATIONS[0]);
                if (defaultFolder.exists()) {
                    chooser.setCurrentDirectory(defaultFolder);
                } else {
                    FileObject javadocFolder;
                    List javadocFolders = this.platform.getJavadocFolders();
                    if (javadocFolders.size() > 0 && (javadocFolder = URLMapper.findFileObject((URL)((URL)javadocFolders.get(0)))) != null) {
                        workDir = FileUtil.toFile((FileObject)javadocFolder).getAbsolutePath();
                        chooser.setCurrentDirectory(FileUtil.toFile((FileObject)javadocFolder));
                    }
                }
            } else {
                chooser.setCurrentDirectory(new File(workDir));
            }
        }
        workDir = this.javadocTextField.getText();
        if (workDir.length() == 0) {
            // empty if block
        }
        chooser.setCurrentDirectory(new File(workDir));
        chooser.setDialogTitle(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"Customizer_Javadoc_Folder_Browse_Title"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.javadocTextField.setText(file.getAbsolutePath());
        }
    }

    private void browseSourcesButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        if (this.lastUsedSDKFolder != null) {
            chooser.setCurrentDirectory(this.lastUsedSDKFolder);
        } else {
            String workDir = this.srcTextField.getText();
            if (workDir.length() == 0) {
                File defaultFolder = new File(JavaFXPlatformUtils.KNOWN_JFX_LOCATIONS[0]);
                if (defaultFolder.exists()) {
                    chooser.setCurrentDirectory(defaultFolder);
                } else {
                    File srcFolderFile;
                    FileObject srcFolder;
                    ClassPath sourceFolders = this.platform.getSourceFolders();
                    FileObject[] roots = sourceFolders.getRoots();
                    if (roots != null && roots.length > 0 && (srcFolder = roots[0]) != null && (srcFolderFile = FileUtil.toFile((FileObject)srcFolder)) != null) {
                        chooser.setCurrentDirectory(srcFolderFile);
                    }
                }
            } else {
                chooser.setCurrentDirectory(new File(workDir));
            }
        }
        chooser.setDialogTitle(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"Customizer_Sources_Folder_Browse_Title"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.srcTextField.setText(file.getAbsolutePath());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void setObject(Object bean) {
        this.platform = (JavaPlatform)bean;
        if (JavaFXPlatformUtils.isJavaFXEnabled(this.platform)) {
            this.readProperties();
        } else {
            this.enableCheckBox.setSelected(false);
            this.clearPropertyFields();
        }
    }

    private void saveProperties() {
        String srcPath;
        String javadocPath;
        String runtimePath;
        HashMap<String, String> map = new HashMap<String, String>(3);
        boolean propertiesChanged = false;
        String sdkPath = this.sdkTextField.getText();
        if (sdkPath.length() > 0) {
            map.put(Utils.getSDKPropertyKey(this.platform), sdkPath);
            propertiesChanged = true;
        }
        if ((runtimePath = this.runtimeTextField.getText()).length() > 0) {
            map.put(Utils.getRuntimePropertyKey(this.platform), runtimePath);
            propertiesChanged = true;
        }
        if ((javadocPath = this.javadocTextField.getText()).length() > 0) {
            map.put(Utils.getJavadocPropertyKey(this.platform), javadocPath);
            propertiesChanged = true;
        }
        if ((srcPath = this.srcTextField.getText()).length() > 0) {
            map.put(Utils.getSourcesPropertyKey(this.platform), srcPath);
            propertiesChanged = true;
        }
        if (propertiesChanged) {
            PlatformPropertiesHandler.saveGlobalProperties(map);
        }
    }

    private void clearProperties() {
        PlatformPropertiesHandler.clearGlobalPropertiesForPlatform(this.platform);
    }

    private void clearPropertyFields() {
        this.sdkTextField.setText("");
        this.runtimeTextField.setText("");
        this.javadocTextField.setText("");
        this.srcTextField.setText("");
    }

    private void readProperties() {
        File runtimeDir;
        File sdkDir;
        EditableProperties properties = PlatformPropertiesHandler.getGlobalProperties();
        String sdkPath = properties.get((Object)Utils.getSDKPropertyKey(this.platform));
        String runtimePath = properties.get((Object)Utils.getRuntimePropertyKey(this.platform));
        String javadocPath = properties.get((Object)Utils.getJavadocPropertyKey(this.platform));
        String srcPath = properties.get((Object)Utils.getSourcesPropertyKey(this.platform));
        this.sdkTextField.setText(sdkPath);
        this.runtimeTextField.setText(runtimePath);
        this.javadocTextField.setText(javadocPath);
        this.srcTextField.setText(srcPath);
        this.enableCheckBox.setSelected(true);
        if (sdkPath != null && (sdkDir = new File(sdkPath)).exists()) {
            this.lastUsedSDKFolder = sdkDir.getParentFile();
        }
        if (runtimePath != null && (runtimeDir = new File(runtimePath)).exists()) {
            this.lastUsedRTFolder = runtimeDir.getParentFile();
        }
    }

    private boolean isPlatformValid() {
        String runtimePath;
        String sdkPath = this.sdkTextField.getText();
        boolean correctLocations = JavaFXPlatformUtils.areJFXLocationsCorrect(sdkPath, runtimePath = this.runtimeTextField.getText());
        if (!correctLocations) {
            return false;
        }
        return Utils.isArchitechtureCorrect(runtimePath);
    }

    private void setErrorMessage() {
        this.messageLabel.setText(NbBundle.getMessage(JavaFXPlatformCustomizer.class, (String)"Customizer_Invalid_Platform_Msg"));
    }

    private void clearErrorMessage() {
        this.messageLabel.setText(null);
    }

    private void firePlatformChange() {
        try {
            Method method = JavaPlatform.class.getDeclaredMethod("firePropertyChange", String.class, Object.class, Object.class);
            method.setAccessible(true);
            method.invoke((Object)this.platform, "javafx", null, null);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void documentChanged() {
        if (this.isPlatformValid()) {
            this.saveProperties();
            this.firePlatformChange();
            this.clearErrorMessage();
        } else {
            this.setErrorMessage();
        }
    }
}

