/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocalVariableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.openide.util.NbBundle;

class ObjectLocalVariable
extends AbstractObjectVariable
implements org.netbeans.api.debugger.jpda.LocalVariable {
    LocalVariable local;
    JPDAThread thread;
    int depth;
    String className;
    String genericSignature;
    private int cloneNumber = 1;

    ObjectLocalVariable(JPDADebuggerImpl debugger, ObjectReference value, String className, LocalVariable local, String genericSignature, CallStackFrameImpl frame) {
        this(debugger, value, className, local, genericSignature, ObjectLocalVariable.getID(local), frame);
    }

    private static String getID(LocalVariable local) {
        try {
            return LocalVariableWrapper.name(local) + LocalVariableWrapper.hashCode(local) + "^";
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
    }

    private ObjectLocalVariable(JPDADebuggerImpl debugger, ObjectReference value, String className, LocalVariable local, String genericSignature, String id, CallStackFrameImpl frame) {
        super(debugger, (Value)value, genericSignature, id);
        this.local = local;
        if (frame != null) {
            this.thread = frame.getThread();
            this.depth = frame.getFrameDepth();
        }
        this.className = className;
    }

    public String getName() {
        try {
            return LocalVariableWrapper.name(this.local);
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
    }

    public String getClassName() {
        return this.className;
    }

    protected final void setClassName(String className) {
        this.className = className;
    }

    public String getDeclaredType() {
        try {
            return LocalVariableWrapper.typeName(this.local);
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
    }

    @Override
    protected final void setValue(Value value) throws InvalidExpressionException {
        try {
            CallStackFrame[] frames = this.thread.getCallStack(this.depth, this.depth + 1);
            if (frames.length == 0) {
                VirtualMachineWrapper.mirrorOf(value.virtualMachine(), true);
                throw new InvalidExpressionException(NbBundle.getMessage(ObjectLocalVariable.class, (String)"MSG_NoTopFrame"));
            }
            StackFrame sf = ((CallStackFrameImpl)frames[0]).getStackFrame();
            StackFrameWrapper.setValue(sf, this.local, value);
            this.setInnerValue(value);
        }
        catch (AbsentInformationException aiex) {
            throw new InvalidExpressionException((Throwable)aiex);
        }
        catch (InvalidTypeException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (ClassNotLoadedException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (InternalExceptionWrapper ex) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    @Override
    public ObjectLocalVariable clone() {
        ObjectLocalVariable clon = new ObjectLocalVariable(this.getDebugger(), (ObjectReference)this.getJDIValue(), this.className, this.local, this.genericSignature, this.getID() + "_clone" + this.cloneNumber++, null);
        clon.depth = this.depth;
        clon.thread = this.thread;
        return clon;
    }

    final void setFrame(CallStackFrameImpl frame) {
        this.thread = frame.getThread();
        this.depth = frame.getFrameDepth();
    }

    @Override
    public String toString() {
        try {
            return "ObjectLocalVariable " + LocalVariableWrapper.name(this.local);
        }
        catch (InternalExceptionWrapper ex) {
            return "ObjectLocalVariable " + ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
    }
}

