/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import org.netbeans.api.debugger.jpda.ClassVariable;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.ArrayFieldVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.FieldVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class LocalsTreeModel
implements TreeModel,
PropertyChangeListener {
    private static final String NO_DEBUG_INFO = "noDebugInfoWarning";
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(108) >= 0;
    private static final int ARRAY_CHILDREN_NESTED_LENGTH = Integer.getInteger("netbeans.debug.arrayChildrenNest", 100);
    private JPDADebuggerImpl debugger;
    private Listener listener;
    private PropertyChangeListener varChangeListener;
    private final List<ModelListener> listeners = new ArrayList<ModelListener>();
    private PropertyChangeListener[] varListeners;
    private Map<Value, ArrayChildrenNode> cachedArrayChildren = new WeakHashMap<Value, ArrayChildrenNode>();
    private static final String PROP_OPERATIONS_UPDATE = "operationsUpdate";
    private static final String PROP_OPERATIONS_SET = "operationsSet";

    public LocalsTreeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
        this.varChangeListener = new VarChangeListener();
        this.debugger.varChangeSupport.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.varChangeListener, (Object)this.debugger.varChangeSupport));
    }

    public Object getRoot() {
        return "Root";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireTableValueChangedChanged(evt.getSource(), null);
    }

    public Object[] getChildren(Object o, int from, int to) throws UnknownTypeException {
        Object[] ch = this.getChildrenImpl(o, from, to);
        for (int i = 0; i < ch.length; ++i) {
            if (!(ch[i] instanceof Customizer)) continue;
            ((Customizer)ch[i]).addPropertyChangeListener(this);
        }
        return ch;
    }

    public Object[] getChildrenImpl(Object o, int from, int to) throws UnknownTypeException {
        try {
            if (o.equals("Root")) {
                Object[] os = this.getLocalVariables(from, to);
                return os;
            }
            if (o instanceof AbstractObjectVariable) {
                AbstractObjectVariable abstractVariable = (AbstractObjectVariable)o;
                boolean isArray = abstractVariable.getInnerValue() instanceof ArrayReference;
                if (isArray) {
                    to = abstractVariable.getFieldsCount();
                }
                if (isArray && to - from > ARRAY_CHILDREN_NESTED_LENGTH) {
                    ArrayChildrenNode achn = this.cachedArrayChildren.get(abstractVariable.getInnerValue());
                    if (achn == null) {
                        achn = new ArrayChildrenNode(abstractVariable);
                        this.cachedArrayChildren.put(abstractVariable.getInnerValue(), achn);
                    } else {
                        achn.update(abstractVariable);
                    }
                    return achn.getChildren();
                }
                return abstractVariable.getFields(from, Math.min(to, abstractVariable.getFieldsCount()));
            }
            if (o instanceof AbstractVariable) {
                return new Object[0];
            }
            if (o instanceof ArrayChildrenNode) {
                return ((ArrayChildrenNode)o).getChildren();
            }
            if (o instanceof JPDAClassType) {
                Object[] fields;
                JPDAClassType clazz = (JPDAClassType)o;
                List staticFields = clazz.staticFields();
                try {
                    ClassVariable clazzVar = clazz.classObject();
                    fields = new Object[1 + staticFields.size()];
                    fields[0] = clazzVar;
                    System.arraycopy(staticFields.toArray(), 0, fields, 1, staticFields.size());
                }
                catch (UnsupportedOperationException uex) {
                    fields = staticFields.toArray();
                }
                return fields;
            }
            if (o instanceof EditorContext.Operation) {
                List operations;
                boolean isNotDone;
                List lastOperations;
                JPDAThread t;
                Object[] ret = new Object[]{null, null};
                CallStackFrameImpl frame = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
                if (frame == null) {
                    return new Object[0];
                }
                EditorContext.Operation currentOperation = frame.getThread().getCurrentOperation();
                EditorContext.Operation lastOperation = null;
                if (currentOperation != null && (t = this.debugger.getCurrentThread()) != null && (lastOperations = t.getLastOperations()) != null && lastOperations.size() > 0) {
                    lastOperation = (EditorContext.Operation)lastOperations.get(lastOperations.size() - 1);
                }
                boolean bl = isNotDone = currentOperation != lastOperation;
                if (isNotDone && CallStackFrameImpl.canFindOperationArguments()) {
                    ret[0] = "operationArguments " + currentOperation.getMethodName();
                }
                if ((operations = frame.getThread().getLastOperations()) != null && operations.size() > 0 && ((EditorContext.Operation)operations.get(0)).getReturnValue() != null) {
                    ret[1] = "lastOperations";
                }
                if (ret[0] == null && ret[1] == null) {
                    return new Object[0];
                }
                if (ret[0] == null) {
                    return new Object[]{ret[1]};
                }
                if (ret[1] == null) {
                    return new Object[]{ret[0]};
                }
                return ret;
            }
            if ("lastOperations" == o) {
                CallStackFrameImpl frame = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
                if (frame == null) {
                    return new Object[0];
                }
                List operations = frame.getThread().getLastOperations();
                if (operations == null) {
                    return new Object[0];
                }
                ArrayList<Variable> lastOperationValues = new ArrayList<Variable>(operations.size());
                for (int i = 0; i < operations.size(); ++i) {
                    Variable ret = ((EditorContext.Operation)operations.get(i)).getReturnValue();
                    if (ret == null) continue;
                    lastOperationValues.add(ret);
                }
                return lastOperationValues.toArray();
            }
            if (o instanceof String && ((String)o).startsWith("operationArguments")) {
                List<LocalVariable> arguments;
                CallStackFrameImpl frame = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
                if (frame == null) {
                    return new Object[0];
                }
                EditorContext.Operation currentOperation = frame.getThread().getCurrentOperation();
                if (currentOperation == null) {
                    return new Object[0];
                }
                try {
                    arguments = frame.findOperationArguments(currentOperation);
                }
                catch (NativeMethodException nmex) {
                    return new Object[]{"NativeMethodException"};
                }
                if (arguments == null) {
                    return new Object[0];
                }
                return arguments.toArray();
            }
            if (NO_DEBUG_INFO == o) {
                return new Object[0];
            }
            throw new UnknownTypeException(o);
        }
        catch (VMDisconnectedException ex) {
            return new Object[0];
        }
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        try {
            if (node.equals("Root")) {
                return Integer.MAX_VALUE;
            }
            if (node instanceof AbstractVariable) {
                AbstractVariable abstractVariable = (AbstractVariable)node;
                if (abstractVariable.getInnerValue() instanceof ArrayReference) {
                    return Integer.MAX_VALUE;
                }
                return Integer.MAX_VALUE;
            }
            if (node instanceof ArrayChildrenNode) {
                return Integer.MAX_VALUE;
            }
            if (node instanceof JPDAClassType) {
                return Integer.MAX_VALUE;
            }
            if (node instanceof JPDAClassType) {
                JPDAClassType clazz = (JPDAClassType)node;
                return 1 + clazz.staticFields().size();
            }
            if (node instanceof EditorContext.Operation) {
                return Integer.MAX_VALUE;
            }
            if ("lastOperations" == node) {
                CallStackFrameImpl frame = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
                if (frame == null) {
                    return 0;
                }
                List operations = frame.getThread().getLastOperations();
                if (operations != null) {
                    return operations.size();
                }
                return 0;
            }
            if (node instanceof String && ((String)node).startsWith("operationArguments")) {
                return Integer.MAX_VALUE;
            }
            if (NO_DEBUG_INFO == node) {
                return 0;
            }
            throw new UnknownTypeException(node);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return 0;
        }
    }

    public boolean isLeaf(final Object o) throws UnknownTypeException {
        if (o.equals("Root")) {
            return false;
        }
        if (o instanceof AbstractVariable) {
            if (o instanceof FieldVariable) {
                return true;
            }
            if (o instanceof Refreshable && !((Refreshable)o).isCurrent()) {
                this.debugger.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((Refreshable)o).refresh();
                        }
                        catch (RefreshFailedException ex) {
                            return;
                        }
                        if (!(((AbstractVariable)o).getInnerValue() instanceof ObjectReference)) {
                            LocalsTreeModel.this.fireNodeChildrenChanged(o);
                        }
                    }
                });
                return false;
            }
            return !(((AbstractVariable)o).getInnerValue() instanceof ObjectReference);
        }
        if (o.toString().startsWith("SubArray")) {
            return false;
        }
        if (o.equals("NoInfo")) {
            return true;
        }
        if (o instanceof JPDAClassType) {
            return false;
        }
        if (o instanceof EditorContext.Operation) {
            return false;
        }
        if (o == "lastOperations") {
            return false;
        }
        if (o == NO_DEBUG_INFO) {
            return true;
        }
        if (o instanceof String && ((String)o).startsWith("operationArguments")) {
            return false;
        }
        throw new UnknownTypeException(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
            if (this.listeners.size() == 0) {
                this.listener.destroy();
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeChanged() {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        int k = ls.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)ls.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableValueChangedChanged(Object node, String propertyName) {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        int k = ls.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)ls.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, node, propertyName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChanged(Object node) {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        int k = ls.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)ls.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, node));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChildrenChanged(Object node) {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        int k = ls.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)ls.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, node, 8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getLocalVariables(int from, int to) {
        Object[] objectArray;
        CallStackFrameImpl callStackFrame = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
        if (callStackFrame == null) {
            return new String[]{"No current thread"};
        }
        final JPDAThreadImpl thread = (JPDAThreadImpl)callStackFrame.getThread();
        thread.accessLock.readLock().lock();
        PropertyChangeListener operationsUpdateListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (LocalsTreeModel.PROP_OPERATIONS_UPDATE.equals(name)) {
                    LocalsTreeModel.this.fireTreeChanged();
                }
                if (LocalsTreeModel.PROP_OPERATIONS_SET.equals(name)) {
                    thread.removePropertyChangeListener(LocalsTreeModel.PROP_OPERATIONS_UPDATE, this);
                    thread.removePropertyChangeListener(LocalsTreeModel.PROP_OPERATIONS_SET, this);
                }
            }
        };
        thread.addPropertyChangeListener(PROP_OPERATIONS_UPDATE, operationsUpdateListener);
        thread.addPropertyChangeListener(PROP_OPERATIONS_SET, operationsUpdateListener);
        try {
            ReturnVariableImpl returnVariable;
            StackFrame stackFrame = null;
            try {
                stackFrame = callStackFrame.getStackFrame();
            }
            catch (InvalidStackFrameException e) {
                // empty catch block
            }
            if (stackFrame == null) {
                Object[] e = new String[]{"No current thread"};
                return e;
            }
            ObjectReference thisR = StackFrameWrapper.thisObject(stackFrame);
            List<EditorContext.Operation> operations = thread.getLastOperations();
            if (operations != null && operations.size() > 0 && operations.get(0).getReturnValue() != null) {
                boolean haveLastOperations = true;
                returnVariable = null;
            } else {
                returnVariable = thread.getReturnVariable();
                boolean haveLastOperations = false;
            }
            int retValShift = returnVariable != null ? 1 : 0;
            EditorContext.Operation currentOperation = thread.getCurrentOperation();
            int currArgShift = currentOperation != null ? 1 : 0;
            int shift = retValShift + currArgShift;
            if (thisR == null) {
                ReferenceType classType = LocationWrapper.declaringType(StackFrameWrapper.location(stackFrame));
                Object[] avs = null;
                avs = this.getLocalVariables(callStackFrame, stackFrame, Math.max(from - shift - 1, 0), Math.max(to - shift - 1, 0));
                Object[] result = new Object[avs.length + shift + 1];
                if (from < 1 && retValShift > 0) {
                    result[0] = returnVariable;
                }
                if (from < 1 && currArgShift > 0) {
                    result[retValShift] = currentOperation;
                }
                if (from < 1 + shift) {
                    result[shift] = this.debugger.getClassType(classType);
                }
                System.arraycopy(avs, 0, result, 1 + shift, avs.length);
                Object[] objectArray2 = result;
                return objectArray2;
            }
            Object[] avs = null;
            avs = this.getLocalVariables(callStackFrame, stackFrame, Math.max(from - shift - 1, 0), Math.max(to - shift - 1, 0));
            Object[] result = new Object[avs.length + shift + 1];
            if (from < 1 && retValShift > 0) {
                result[0] = returnVariable;
            }
            if (from < 1 && currArgShift > 0) {
                result[retValShift] = currentOperation;
            }
            if (from < 1 + shift) {
                result[shift] = new ThisVariable(this.debugger, thisR, "");
            }
            System.arraycopy(avs, 0, result, 1 + shift, avs.length);
            Object[] objectArray3 = result;
            return objectArray3;
        }
        catch (NativeMethodException nmex) {
            objectArray = new String[]{"NativeMethodException"};
            return objectArray;
        }
        catch (InternalExceptionWrapper ex) {
            objectArray = new String[]{ex.getMessage()};
            return objectArray;
        }
        catch (VMDisconnectedExceptionWrapper dex) {
            objectArray = new String[]{};
            return objectArray;
        }
        catch (InvalidStackFrameException isfex) {
            objectArray = new String[]{"No current thread"};
            return objectArray;
        }
        catch (InvalidStackFrameExceptionWrapper isfex) {
            objectArray = new String[]{"No current thread"};
            return objectArray;
        }
        finally {
            thread.accessLock.readLock().unlock();
        }
    }

    private Object[] getLocalVariables(CallStackFrameImpl callStackFrame, StackFrame stackFrame, int from, int to) {
        Object[] locals;
        try {
            locals = callStackFrame.getLocalVariables();
        }
        catch (AbsentInformationException aiex) {
            Object[] nodes = callStackFrame.getMethodArguments();
            if (nodes == null) {
                nodes = new Object[]{};
            }
            locals = new Object[nodes.length + 1];
            System.arraycopy(nodes, 0, locals, 0, nodes.length);
            locals[nodes.length] = NO_DEBUG_INFO;
        }
        if (locals == null) {
            locals = new Object[]{};
        }
        int n = locals.length;
        to = Math.min(n, to);
        if ((from = Math.min(n, from)) != 0 || to != n) {
            Object[] subLocals = new Object[to - from];
            for (int i = from; i < to; ++i) {
                subLocals[i - from] = locals[i];
            }
            locals = subLocals;
        }
        this.updateVarListeners(locals);
        return locals;
    }

    private void updateVarListeners(Object[] vars) {
        this.varListeners = new PropertyChangeListener[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            PropertyChangeListener l;
            Object var = vars[i];
            this.varListeners[i] = l = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    LocalsTreeModel.this.fireNodeChanged(evt.getSource());
                }
            };
            if (!(var instanceof AbstractVariable)) continue;
            ((AbstractVariable)var).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)l, (Object)var));
        }
    }

    public Variable getVariable(Value v) {
        if (v instanceof ObjectReference || v == null) {
            return new AbstractObjectVariable(this.debugger, (ObjectReference)v, null);
        }
        return new AbstractVariable(this.debugger, v, null);
    }

    JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    private static final class ArrayChildrenNode {
        private AbstractObjectVariable var;
        private int from = 0;
        private int length;
        private int maxIndexLog;

        public ArrayChildrenNode(AbstractObjectVariable var) {
            this(var, 0, var.getFieldsCount(), -1);
        }

        private ArrayChildrenNode(AbstractObjectVariable var, int from, int length, int maxIndex) {
            this.var = var;
            this.from = from;
            this.length = length;
            if (maxIndex < 0) {
                maxIndex = from + length - 1;
            }
            this.maxIndexLog = ArrayFieldVariable.log10(maxIndex);
        }

        private static int pow(int a, int b) {
            if (b == 0) {
                return 1;
            }
            int p = a;
            for (int i = 1; i < b; ++i) {
                p *= a;
            }
            return p;
        }

        public Object[] getChildren() {
            if (this.length > ARRAY_CHILDREN_NESTED_LENGTH) {
                int depth = (int)Math.ceil(Math.log(this.length) / Math.log(ARRAY_CHILDREN_NESTED_LENGTH) - 1.0);
                int n = ArrayChildrenNode.pow(ARRAY_CHILDREN_NESTED_LENGTH, depth);
                int numCh = (int)Math.ceil((double)this.length / (double)n);
                Object[] ch = new Object[numCh];
                for (int i = 0; i < numCh; ++i) {
                    int chLength = n;
                    if (i == numCh - 1 && (chLength = this.length % n) == 0) {
                        chLength = n;
                    }
                    ch[i] = new ArrayChildrenNode(this.var, this.from + i * n, chLength, this.from + this.length - 1);
                }
                return ch;
            }
            return this.var.getFields(this.from, this.from + this.length);
        }

        public void update(AbstractObjectVariable var) {
            this.var = var;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ArrayChildrenNode)) {
                return false;
            }
            ArrayChildrenNode achn = (ArrayChildrenNode)obj;
            return achn.var.equals(this.var) && achn.from == this.from && achn.length == this.length;
        }

        public int hashCode() {
            return this.var.hashCode() + this.from + this.length;
        }

        public String toString() {
            int num0 = this.maxIndexLog - ArrayFieldVariable.log10(this.from);
            String froms = num0 > 0 ? ArrayFieldVariable.zeros(2 * num0) + this.from : Integer.toString(this.from);
            int last = this.from + this.length - 1;
            num0 = this.maxIndexLog - ArrayFieldVariable.log10(last);
            String lasts = num0 > 0 ? ArrayFieldVariable.zeros(2 * num0) + last : Integer.toString(last);
            return "SubArray" + froms + "-" + lasts;
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebuggerImpl debugger;
        private WeakReference<LocalsTreeModel> model;
        private RequestProcessor.Task task;

        public Listener(LocalsTreeModel tm, JPDADebuggerImpl debugger) {
            this.debugger = debugger;
            this.model = new WeakReference<LocalsTreeModel>(tm);
            debugger.addPropertyChangeListener(this);
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("LTM cancel old task " + this.task);
                }
                this.task = null;
            }
        }

        private LocalsTreeModel getModel() {
            LocalsTreeModel tm = (LocalsTreeModel)this.model.get();
            if (tm == null) {
                this.destroy();
            }
            return tm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ((e.getPropertyName() == "currentCallStackFrame" || e.getPropertyName() == "state") && this.debugger.getState() == 3) {
                final LocalsTreeModel ltm = this.getModel();
                if (ltm == null) {
                    return;
                }
                if (this.task != null) {
                    this.task.cancel();
                    if (verbose) {
                        System.out.println("LTM cancel old task " + this.task);
                    }
                    this.task = null;
                }
                this.task = this.debugger.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        if (Listener.this.debugger.getState() != 3) {
                            if (verbose) {
                                System.out.println("LTM cancel started task " + Listener.this.task);
                            }
                            return;
                        }
                        if (verbose) {
                            System.out.println("LTM do task " + Listener.this.task);
                        }
                        ltm.fireTreeChanged();
                    }
                }, 100);
                if (verbose) {
                    System.out.println("LTM  create task " + this.task);
                }
            } else if (e.getPropertyName() == "state" && this.debugger.getState() != 3 && this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("LTM cancel task " + this.task);
                }
                this.task = null;
            }
        }
    }

    private class VarChangeListener
    implements PropertyChangeListener {
        private VarChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object var = evt.getSource();
            if (var instanceof Variable) {
                LocalsTreeModel.this.fireNodeChanged(var);
            }
        }
    }
}

