/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ObjectLocalVariable;
import org.omg.CORBA.portable.ApplicationException;
import org.openide.util.NbBundle;

class JPDAWatchImpl
extends AbstractVariable
implements JPDAWatch {
    private JPDADebuggerImpl debugger;
    private Watch watch;
    private String exceptionDescription;
    private Reference<Object> nodeRef;

    JPDAWatchImpl(JPDADebuggerImpl debugger, Watch watch, PrimitiveValue v, Object node) {
        super(debugger, v, "" + watch + (v instanceof ObjectReference ? "^" : ""));
        this.debugger = debugger;
        this.watch = watch;
        this.nodeRef = new WeakReference<Object>(node);
    }

    JPDAWatchImpl(JPDADebuggerImpl debugger, Watch watch, Exception exception, Object node) {
        super(debugger, null, "" + watch);
        Throwable t;
        this.debugger = debugger;
        this.watch = watch;
        this.exceptionDescription = exception.getLocalizedMessage();
        if (this.exceptionDescription == null) {
            this.exceptionDescription = exception.getMessage();
        }
        if ((t = exception.getCause()) != null && t instanceof ApplicationException) {
            StringWriter s = new StringWriter();
            PrintWriter p = new PrintWriter(s);
            t.printStackTrace(p);
            p.close();
            this.exceptionDescription = this.exceptionDescription + " \n" + s.toString();
        }
        this.nodeRef = new WeakReference<Object>(node);
    }

    public Watch getWatch() {
        return this.watch;
    }

    public String getExpression() {
        return this.watch.getExpression();
    }

    public void setExpression(String expression) {
        this.watch.setExpression(expression);
    }

    public void remove() {
        this.watch.remove();
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    @Override
    protected void setInnerValue(Value v) {
        super.setInnerValue(v);
        this.exceptionDescription = null;
    }

    @Override
    protected void setValue(Value value) throws InvalidExpressionException {
        block23: {
            LocalVariable local;
            CallStackFrameImpl frame = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
            if (frame == null) {
                throw new InvalidExpressionException("No curent frame.");
            }
            try {
                local = frame.getLocalVariable(this.getExpression());
            }
            catch (AbsentInformationException ex) {
                local = null;
            }
            if (local != null) {
                if (local instanceof Local) {
                    ((Local)local).setValue(value);
                } else {
                    ((ObjectLocalVariable)local).setValue(value);
                }
                return;
            }
            ReferenceType clazz = null;
            try {
                clazz = LocationWrapper.declaringType(StackFrameWrapper.location(frame.getStackFrame()));
                Field field = ReferenceTypeWrapper.fieldByName(clazz, this.getExpression());
                if (field == null) {
                    throw new InvalidExpressionException(NbBundle.getMessage(JPDAWatchImpl.class, (String)"MSG_CanNotSetValue", (Object)this.getExpression()));
                }
                if (TypeComponentWrapper.isStatic(field)) {
                    if (clazz instanceof ClassType) {
                        try {
                            ClassTypeWrapper.setValue((ClassType)clazz, field, value);
                            break block23;
                        }
                        catch (IllegalArgumentException iaex) {
                            throw new InvalidExpressionException((Throwable)iaex);
                        }
                    }
                    throw new InvalidExpressionException(NbBundle.getMessage(JPDAWatchImpl.class, (String)"MSG_CanNotSetValue", (Object)this.getExpression()));
                }
                try {
                    ObjectReference thisObject = StackFrameWrapper.thisObject(frame.getStackFrame());
                    if (thisObject == null) {
                        throw new InvalidExpressionException("no instance context.");
                    }
                    ObjectReferenceWrapper.setValue(thisObject, field, value);
                }
                catch (IllegalArgumentExceptionWrapper ex) {
                    throw new InvalidExpressionException((Throwable)ex.getCause());
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    throw new InvalidExpressionException((Throwable)ocex);
                }
            }
            catch (InternalExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (VMDisconnectedExceptionWrapper ex) {
            }
            catch (InvalidStackFrameExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (ClassNotPreparedExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (InvalidTypeException ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (ClassNotLoadedException ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
        }
    }

    public String getToStringValue() throws InvalidExpressionException {
        return AbstractObjectVariable.getToStringValue(this.getInnerValue(), this.getDebugger(), 0);
    }

    void setException(String exceptionDescription) {
        this.setInnerValue(null);
        this.exceptionDescription = exceptionDescription;
    }

    boolean isPrimitive() {
        return !(this.getInnerValue() instanceof ObjectReference);
    }

    @Override
    public JPDAWatchImpl clone() {
        JPDAWatchImpl clon = this.exceptionDescription == null ? new JPDAWatchImpl(this.getDebugger(), this.watch, (PrimitiveValue)this.getJDIValue(), this.nodeRef.get()) : new JPDAWatchImpl(this.getDebugger(), this.watch, new Exception(this.exceptionDescription), this.nodeRef.get());
        return clon;
    }
}

