/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.Exceptions;

public class EvaluationContext {
    private static final Logger logger = Logger.getLogger(EvaluationContext.class.getName());
    private StackFrame frame;
    private int frameDepth;
    private JPDAThreadImpl thread;
    private ObjectReference contextVariable;
    private List<String> sourceImports;
    private List<String> staticImports;
    private boolean canInvokeMethods;
    private Runnable methodInvokePreproc;
    private JPDADebuggerImpl debugger;
    private Trees trees;
    private CompilationUnitTree compilationUnitTree;
    private TreePath treePath;
    private Map<Tree, VariableInfo> variables = new HashMap<Tree, VariableInfo>();
    private Stack<Map<String, ScriptVariable>> stack = new Stack();
    private Map<String, ScriptVariable> scriptLocalVariables = new HashMap<String, ScriptVariable>();
    private final List<ObjectReference> disabledCollectionObjects = new ArrayList<ObjectReference>();
    private PropertyChangeListener threadPropertyChangeListener = null;

    public EvaluationContext(JPDAThreadImpl thread, StackFrame frame, int frameDepth, ObjectReference contextVariable, List<String> imports, List<String> staticImports, boolean canInvokeMethods, Runnable methodInvokePreproc, JPDADebuggerImpl debugger) {
        if (thread == null) {
            throw new IllegalArgumentException("Thread argument must not be null");
        }
        if (frame == null) {
            throw new IllegalArgumentException("Frame argument must not be null");
        }
        if (imports == null) {
            throw new IllegalArgumentException("Imports argument must not be null");
        }
        if (staticImports == null) {
            throw new IllegalArgumentException("Static imports argument must not be null");
        }
        this.thread = thread;
        this.frame = frame;
        this.frameDepth = frameDepth;
        this.contextVariable = contextVariable;
        this.sourceImports = imports;
        this.staticImports = staticImports;
        this.canInvokeMethods = canInvokeMethods;
        this.methodInvokePreproc = methodInvokePreproc;
        this.debugger = debugger;
        this.stack.push(new HashMap());
    }

    public List<String> getStaticImports() {
        return this.staticImports;
    }

    public List<String> getImports() {
        return this.sourceImports;
    }

    public StackFrame getFrame() {
        try {
            this.frame.thread();
        }
        catch (InvalidStackFrameException isex) {
            try {
                logger.config("Updating an invalid stack frame on " + this.thread.getName() + " and depth " + this.frameDepth);
                this.frame = ThreadReferenceWrapper.frame(this.thread.getThreadReference(), this.frameDepth);
                logger.config("... stack frame updated.");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.frame;
    }

    JPDAThreadImpl getThread() {
        return this.thread;
    }

    ObjectReference getContextVariable() {
        return this.contextVariable;
    }

    public ObjectReference getContextObject() {
        if (this.contextVariable != null) {
            return this.contextVariable;
        }
        try {
            return this.getFrame().thisObject();
        }
        catch (InternalException iex) {
            if (iex.errorCode() == 35) {
                return null;
            }
            throw iex;
        }
    }

    public boolean canInvokeMethods() {
        return this.canInvokeMethods;
    }

    void setCanInvokeMethods(boolean canInvokeMethods) {
        this.canInvokeMethods = canInvokeMethods;
    }

    void methodToBeInvoked() {
        if (this.methodInvokePreproc != null) {
            this.methodInvokePreproc.run();
        }
    }

    void methodInvokeDone() throws IncompatibleThreadStateException {
        try {
            this.frame = ThreadReferenceWrapper.frame(this.thread.getThreadReference(), this.frameDepth);
        }
        catch (InternalExceptionWrapper ex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)ex);
            ieex.initCause((Throwable)ex);
            throw new IllegalStateException(ieex);
        }
        catch (VMDisconnectedExceptionWrapper ex) {
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)ex);
            ieex.initCause((Throwable)ex);
            throw new IllegalStateException(ieex);
        }
        catch (IllegalThreadStateExceptionWrapper ex) {
            InvalidExpressionException ieex = new InvalidExpressionException((Throwable)ex);
            ieex.initCause((Throwable)ex);
            throw new IllegalStateException(ieex);
        }
    }

    JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    public void setTrees(Trees trees) {
        this.trees = trees;
    }

    Trees getTrees() {
        return this.trees;
    }

    public void setCompilationUnit(CompilationUnitTree compilationUnitTree) {
        this.compilationUnitTree = compilationUnitTree;
    }

    CompilationUnitTree getCompilationUnit() {
        return this.compilationUnitTree;
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }

    TreePath getTreePath() {
        return this.treePath;
    }

    public VariableInfo getVariableInfo(Tree tree) {
        return this.variables.get(tree);
    }

    public void putField(Tree tree, Field field, ObjectReference objectRef) {
        VariableInfo.FieldInf info = new VariableInfo.FieldInf(field, objectRef);
        this.variables.put(tree, info);
    }

    public void putLocalVariable(Tree tree, LocalVariable var) {
        VariableInfo.LocalVarInf info = new VariableInfo.LocalVarInf(var, this);
        this.variables.put(tree, info);
    }

    public void putArrayAccess(Tree tree, ArrayReference array, int index) {
        VariableInfo.ArrayElementInf info = new VariableInfo.ArrayElementInf(array, index);
        this.variables.put(tree, info);
    }

    public void putScriptVariable(Tree tree, ScriptVariable var) {
        VariableInfo.ScriptLocalVarInf info = new VariableInfo.ScriptLocalVarInf(var);
        this.variables.put(tree, info);
    }

    public ScriptVariable getScriptVariableByName(String name) {
        return this.scriptLocalVariables.get(name);
    }

    public ScriptVariable createScriptLocalVariable(String name, Type type) {
        Map<String, ScriptVariable> map = this.stack.peek();
        ScriptVariable var = new ScriptVariable(name, type);
        map.put(name, var);
        this.scriptLocalVariables.put(name, var);
        return var;
    }

    public void pushBlock() {
        this.stack.push(new HashMap());
    }

    public void popBlock() {
        Map<String, ScriptVariable> map = this.stack.pop();
        for (String name : map.keySet()) {
            this.scriptLocalVariables.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableCollectionOf(ObjectReference or) {
        List<ObjectReference> list = this.disabledCollectionObjects;
        synchronized (list) {
            if (this.threadPropertyChangeListener == null) {
                this.threadPropertyChangeListener = new PropertyChangeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (EvaluationContext.this.thread.equals(evt.getSource()) && "suspended".equals(evt.getPropertyName()) || ((Object)((Object)EvaluationContext.this.thread.getDebugger())).equals(evt.getSource()) && "state".equals(evt.getPropertyName())) {
                            if (EvaluationContext.this.thread.getDebugger().getState() != 4) {
                                if (EvaluationContext.this.thread.isMethodInvoking()) {
                                    return;
                                }
                                if (EvaluationContext.this.thread.isSuspended()) {
                                    return;
                                }
                            }
                            List list = EvaluationContext.this.disabledCollectionObjects;
                            synchronized (list) {
                                EvaluationContext.this.enableCollectionOfObjects(null);
                                EvaluationContext.this.threadPropertyChangeListener = null;
                            }
                            EvaluationContext.this.thread.removePropertyChangeListener(this);
                            EvaluationContext.this.thread.getDebugger().removePropertyChangeListener(this);
                        }
                    }
                };
                this.thread.addPropertyChangeListener(this.threadPropertyChangeListener);
                this.thread.getDebugger().addPropertyChangeListener(this.threadPropertyChangeListener);
            }
            if (this.disabledCollectionObjects.add(or)) {
                try {
                    or.disableCollection();
                }
                catch (UnsupportedOperationException uoex) {
                    this.disabledCollectionObjects.remove(or);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCollectionOfObjects(Value skip) {
        List<ObjectReference> list = this.disabledCollectionObjects;
        synchronized (list) {
            HashSet<ObjectReference> collectedObjects = new HashSet<ObjectReference>(this.disabledCollectionObjects);
            for (ObjectReference or : collectedObjects) {
                if (skip != null && skip.equals(or)) continue;
                try {
                    ObjectReferenceWrapper.enableCollection(or);
                }
                catch (InternalExceptionWrapper ex) {
                }
                catch (VMDisconnectedExceptionWrapper ex) {
                    return;
                }
                catch (ObjectCollectedExceptionWrapper ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (UnsupportedOperationExceptionWrapper uoex) {
                    // empty catch block
                }
                this.disabledCollectionObjects.remove(or);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        List<ObjectReference> list = this.disabledCollectionObjects;
        synchronized (list) {
            if (this.threadPropertyChangeListener != null) {
                this.thread.removePropertyChangeListener(this.threadPropertyChangeListener);
                this.thread.getDebugger().removePropertyChangeListener(this.threadPropertyChangeListener);
                this.threadPropertyChangeListener = null;
            }
        }
    }

    public static class ScriptVariable {
        private String name;
        private Type type;
        private Mirror value;
        private boolean valueInited = false;

        public ScriptVariable(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public Mirror getValue() {
            return this.value;
        }

        public Type getType() {
            return this.type;
        }

        public void setValue(Mirror value) {
            this.value = value;
            this.valueInited = true;
        }
    }

    public static abstract class VariableInfo {
        public abstract void setValue(Value var1);

        public abstract Type getType() throws ClassNotLoadedException;

        private static class ArrayElementInf
        extends VariableInfo {
            private ArrayReference array;
            private int index;

            ArrayElementInf(ArrayReference array, int index) {
                this.array = array;
                this.index = index;
            }

            @Override
            public Type getType() throws ClassNotLoadedException {
                return this.array.type();
            }

            @Override
            public void setValue(Value value) {
                try {
                    this.array.setValue(this.index, value);
                }
                catch (ClassNotLoadedException ex) {
                    throw new IllegalStateException(ex);
                }
                catch (InvalidTypeException ex) {
                    throw new IllegalStateException(new InvalidExpressionException((Throwable)ex));
                }
            }
        }

        private static class FieldInf
        extends VariableInfo {
            private Field field;
            private ObjectReference fieldObject;

            FieldInf(Field field) {
                this.field = field;
            }

            FieldInf(Field field, ObjectReference fieldObject) {
                this.field = field;
                this.fieldObject = fieldObject;
            }

            @Override
            public Type getType() throws ClassNotLoadedException {
                return this.field.type();
            }

            @Override
            public void setValue(Value value) {
                try {
                    if (this.fieldObject != null) {
                        this.fieldObject.setValue(this.field, value);
                    } else {
                        ((ClassType)this.field.declaringType()).setValue(this.field, value);
                    }
                }
                catch (IllegalArgumentException iaex) {
                    throw new IllegalStateException(new InvalidExpressionException((Throwable)iaex));
                }
                catch (InvalidTypeException itex) {
                    throw new IllegalStateException(new InvalidExpressionException((Throwable)itex));
                }
                catch (ClassNotLoadedException cnlex) {
                    throw new IllegalStateException(cnlex);
                }
            }
        }

        private static class LocalVarInf
        extends VariableInfo {
            private LocalVariable var;
            private EvaluationContext context;

            LocalVarInf(LocalVariable var, EvaluationContext context) {
                this.var = var;
                this.context = context;
            }

            @Override
            public Type getType() throws ClassNotLoadedException {
                return this.var.type();
            }

            @Override
            public void setValue(Value value) {
                try {
                    this.context.getFrame().setValue(this.var, value);
                }
                catch (InvalidTypeException itex) {
                    throw new IllegalStateException(new InvalidExpressionException((Throwable)itex));
                }
                catch (ClassNotLoadedException cnlex) {
                    throw new IllegalStateException(cnlex);
                }
            }
        }

        private static class ScriptLocalVarInf
        extends VariableInfo {
            private ScriptVariable variable;

            ScriptLocalVarInf(ScriptVariable variable) {
                this.variable = variable;
            }

            @Override
            public Type getType() throws ClassNotLoadedException {
                return this.variable.getType();
            }

            @Override
            public void setValue(Value value) {
                this.variable.setValue(value);
            }
        }
    }
}

