/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassPrepareEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassUnloadEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.ClassPrepareRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.ClassUnloadRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.util.JPDAUtils;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public abstract class ClassBasedBreakpoint
extends BreakpointImpl {
    private String sourceRoot;
    private final Object SOURCE_ROOT_LOCK = new Object();
    private SourceRootsChangedListener srChListener;
    private PropertyChangeListener weakSrChListener;
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");

    public ClassBasedBreakpoint(JPDABreakpoint breakpoint, JPDADebuggerImpl debugger, Session session) {
        super(breakpoint, null, debugger, session);
    }

    public ClassBasedBreakpoint(JPDABreakpoint breakpoint, BreakpointsReader reader, JPDADebuggerImpl debugger, Session session) {
        super(breakpoint, reader, debugger, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSourceRoot(String sourceRoot) {
        Object object = this.SOURCE_ROOT_LOCK;
        synchronized (object) {
            this.sourceRoot = sourceRoot;
            if (sourceRoot != null && this.srChListener == null) {
                this.srChListener = new SourceRootsChangedListener();
                this.weakSrChListener = WeakListeners.propertyChange((PropertyChangeListener)this.srChListener, (Object)this.getDebugger().getEngineContext());
                this.getDebugger().getEngineContext().addPropertyChangeListener(this.weakSrChListener);
            } else if (sourceRoot == null) {
                this.srChListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String getSourceRoot() {
        Object object = this.SOURCE_ROOT_LOCK;
        synchronized (object) {
            return this.sourceRoot;
        }
    }

    protected final boolean compareSourceRoots(String sr1, String sr2) {
        if (sr1.equals(sr2)) {
            return true;
        }
        File f1 = new File(sr1);
        File f2 = new File(sr2);
        if (f1.isDirectory() && f2.isDirectory() || f1.isFile() && f2.isFile()) {
            if (f1.equals(f2)) {
                return true;
            }
            try {
                f1 = f1.getCanonicalFile();
                f2 = f2.getCanonicalFile();
                return f1.equals(f2);
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void remove() {
        super.remove();
        Object object = this.SOURCE_ROOT_LOCK;
        synchronized (object) {
            if (this.srChListener != null) {
                this.getDebugger().getEngineContext().removePropertyChangeListener(this.weakSrChListener);
                this.srChListener = null;
            }
        }
    }

    @Override
    protected boolean isEnabled() {
        String sourceRoot = this.getSourceRoot();
        if (sourceRoot == null) {
            return true;
        }
        String[] sourceRoots = this.getDebugger().getEngineContext().getSourceRoots();
        for (int i = 0; i < sourceRoots.length; ++i) {
            if (!this.compareSourceRoots(sourceRoot, sourceRoots[i])) continue;
            return true;
        }
        String[] projectSourceRoots = this.getDebugger().getEngineContext().getProjectSourceRoots();
        for (int i = 0; i < projectSourceRoots.length; ++i) {
            if (!this.compareSourceRoots(sourceRoot, projectSourceRoots[i])) continue;
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(ClassBasedBreakpoint.class, (String)"MSG_DisabledSourceRoot", (Object)sourceRoot));
            return false;
        }
        return true;
    }

    protected boolean isEnabled(String sourcePath, String[] preferredSourceRoot) {
        String sourceRoot = this.getSourceRoot();
        if (sourceRoot == null) {
            return true;
        }
        String url = this.getDebugger().getEngineContext().getURL(sourcePath, true);
        if (url == null) {
            ErrorManager.getDefault().log(16, "No URL found for source path " + sourcePath);
            return false;
        }
        String urlRoot = this.getDebugger().getEngineContext().getSourceRoot(url);
        if (urlRoot == null) {
            return true;
        }
        preferredSourceRoot[0] = urlRoot;
        return this.compareSourceRoots(sourceRoot, urlRoot);
    }

    protected void setClassRequests(String[] classFilters, String[] classExclusionFilters, int breakpointType) {
        this.setClassRequests(classFilters, classExclusionFilters, breakpointType, true);
    }

    protected void setClassRequests(String[] classFilters, String[] classExclusionFilters, int breakpointType, boolean ignoreHitCountOnClassLoad) {
        try {
            int i;
            int k;
            if ((breakpointType & 1) != 0) {
                ClassPrepareRequest cpr = EventRequestManagerWrapper.createClassPrepareRequest(this.getEventRequestManager());
                k = classFilters.length;
                for (i = 0; i < k; ++i) {
                    ClassPrepareRequestWrapper.addClassFilter(cpr, classFilters[i]);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Set class load request: " + classFilters[i]);
                }
                k = classExclusionFilters.length;
                for (i = 0; i < k; ++i) {
                    ClassPrepareRequestWrapper.addClassExclusionFilter(cpr, classExclusionFilters[i]);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Set class load exclusion request: " + classExclusionFilters[i]);
                }
                this.addEventRequest(cpr, ignoreHitCountOnClassLoad);
            }
            if ((breakpointType & 2) != 0) {
                ClassUnloadRequest cur = EventRequestManagerWrapper.createClassUnloadRequest(this.getEventRequestManager());
                k = classFilters.length;
                for (i = 0; i < k; ++i) {
                    ClassUnloadRequestWrapper.addClassFilter(cur, classFilters[i]);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Set class unload request: " + classFilters[i]);
                }
                k = classExclusionFilters.length;
                for (i = 0; i < k; ++i) {
                    ClassUnloadRequestWrapper.addClassExclusionFilter(cur, classExclusionFilters[i]);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Set class unload exclusion request: " + classExclusionFilters[i]);
                }
                this.addEventRequest(cur, false);
            }
        }
        catch (VMDisconnectedExceptionWrapper e) {
        }
        catch (InternalExceptionWrapper e) {
        }
        catch (ObjectCollectedExceptionWrapper e) {
        }
        catch (InvalidRequestStateExceptionWrapper irse) {
            Exceptions.printStackTrace((Throwable)irse);
        }
    }

    protected boolean checkLoadedClasses(String className, String[] classExclusionFilters) {
        VirtualMachine vm = this.getVirtualMachine();
        if (vm == null) {
            return false;
        }
        boolean all = className.startsWith("*") || className.endsWith("*");
        logger.fine("Check loaded classes: " + className + ", will load all classes: " + all);
        boolean matched = false;
        Iterator<ReferenceType> i = null;
        i = all ? VirtualMachineWrapper.allClasses0(vm).iterator() : VirtualMachineWrapper.classesByName0(vm, className).iterator();
        List<ReferenceType> loadedClasses = null;
        while (i.hasNext()) {
            ReferenceType referenceType = i.next();
            if (!ReferenceTypeWrapper.isPrepared0(referenceType)) continue;
            try {
                String name;
                ClassLoaderReference clref = ReferenceTypeWrapper.classLoader(referenceType);
                if (clref != null && ObjectReferenceWrapper.isCollected(clref) || !ClassBasedBreakpoint.match(name = ReferenceTypeWrapper.name(referenceType), className)) continue;
                boolean excluded = false;
                if (classExclusionFilters != null) {
                    for (String exFilter : classExclusionFilters) {
                        if (!ClassBasedBreakpoint.match(name, exFilter)) continue;
                        excluded = true;
                        break;
                    }
                }
                if (excluded) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" Class loaded: " + referenceType);
                }
                if (loadedClasses == null) {
                    loadedClasses = Collections.singletonList(referenceType);
                } else {
                    if (loadedClasses.size() == 1) {
                        loadedClasses = new ArrayList<ReferenceType>(loadedClasses);
                    }
                    loadedClasses.add(referenceType);
                }
                matched = true;
            }
            catch (InternalExceptionWrapper e) {
            }
            catch (VMDisconnectedExceptionWrapper e) {
            }
            catch (ObjectCollectedExceptionWrapper e) {}
        }
        if (loadedClasses != null && loadedClasses.size() > 0) {
            ReferenceType preferredType;
            try {
                preferredType = JPDAUtils.getPreferredReferenceType(loadedClasses, logger);
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return false;
            }
            if (preferredType != null) {
                loadedClasses = Collections.singletonList(preferredType);
            }
            this.classLoaded(loadedClasses);
        }
        return matched;
    }

    @Override
    public boolean exec(Event event) {
        try {
            if (event instanceof ClassPrepareEvent) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" Class loaded: " + ClassPrepareEventWrapper.referenceType((ClassPrepareEvent)event));
                }
                this.classLoaded(Collections.singletonList(ClassPrepareEventWrapper.referenceType((ClassPrepareEvent)event)));
            } else if (event instanceof ClassUnloadEvent) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" Class unloaded: " + ClassUnloadEventWrapper.className((ClassUnloadEvent)event));
                }
                this.classUnloaded(ClassUnloadEventWrapper.className((ClassUnloadEvent)event));
            }
        }
        catch (InternalExceptionWrapper ex) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return false;
        }
        return true;
    }

    @Override
    public void removed(EventRequest eventRequest) {
    }

    protected void classLoaded(List<ReferenceType> referenceTypes) {
    }

    protected void classUnloaded(String className) {
    }

    private class SourceRootsChangedListener
    implements PropertyChangeListener {
        private SourceRootsChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("sourceRoots".equals(evt.getPropertyName())) {
                ClassBasedBreakpoint.this.getDebugger().getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        ClassBasedBreakpoint.this.update();
                    }
                });
            }
        }
    }
}

