/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorExpression;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.PrimitiveValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.netbeans.modules.debugger.jpda.util.ConditionedExecutor;
import org.openide.util.Exceptions;

abstract class BreakpointImpl
implements ConditionedExecutor,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");
    private JPDADebuggerImpl debugger;
    private JPDABreakpoint breakpoint;
    private BreakpointsReader reader;
    private EvaluatorExpression compiledCondition;
    private List<EventRequest> requests = new ArrayList<EventRequest>();
    private int hitCountFilter = 0;
    private final Map<Event, Variable> processedReturnVariable = new HashMap<Event, Variable>();
    private final Map<Event, Throwable> conditionException = new HashMap<Event, Throwable>();

    protected BreakpointImpl(JPDABreakpoint p, BreakpointsReader reader, JPDADebuggerImpl debugger, Session session) {
        this.debugger = debugger;
        this.reader = reader;
        this.breakpoint = p;
    }

    final void set() {
        this.breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
        if (this.breakpoint instanceof PropertyChangeListener && this.isApplicable()) {
            Session s = this.debugger.getSession();
            DebuggerEngine de = s.getEngineForLanguage("Java");
            ((PropertyChangeListener)this.breakpoint).propertyChange(new PropertyChangeEvent(this, DebuggerEngine.class.getName(), null, de));
        }
        this.update();
    }

    void fixed() {
        if (this.reader != null) {
            this.reader.storeCachedClassName(this.breakpoint, null);
        }
        this.update();
    }

    final void update() {
        if (this.getVirtualMachine() == null || this.getDebugger().getState() == 4) {
            return;
        }
        this.removeAllEventRequests();
        if (this.breakpoint.isEnabled() && this.isEnabled()) {
            this.setRequests();
        }
    }

    protected boolean isApplicable() {
        return true;
    }

    protected boolean isEnabled() {
        return true;
    }

    protected final void setValidity(Breakpoint.VALIDITY validity, String reason) {
        if (this.breakpoint instanceof ChangeListener) {
            ((ChangeListener)this.breakpoint).stateChanged(new ValidityChangeEvent(validity, reason));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("disposed".equals(propertyName)) {
            this.remove();
        } else if (!("validity".equals(propertyName) || "groupName".equals(propertyName) || "groupProperties".equals(propertyName))) {
            if (this.reader != null) {
                this.reader.storeCachedClassName(this.breakpoint, null);
            }
            this.debugger.getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    BreakpointImpl.this.update();
                }
            });
        }
    }

    protected abstract void setRequests();

    protected void remove() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.debugger.getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    BreakpointImpl.this.removeAllEventRequests();
                }
            });
        } else {
            this.removeAllEventRequests();
        }
        this.breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
        this.setValidity(Breakpoint.VALIDITY.UNKNOWN, null);
        if (this.breakpoint instanceof PropertyChangeListener) {
            Session s = this.debugger.getSession();
            DebuggerEngine de = s.getEngineForLanguage("Java");
            ((PropertyChangeListener)this.breakpoint).propertyChange(new PropertyChangeEvent(this, DebuggerEngine.class.getName(), de, null));
        }
        this.compiledCondition = null;
    }

    protected JPDABreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    protected JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    protected VirtualMachine getVirtualMachine() {
        return this.getDebugger().getVirtualMachine();
    }

    protected EventRequestManager getEventRequestManager() throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        VirtualMachine vm = this.getVirtualMachine();
        if (vm == null) {
            throw new VMDisconnectedExceptionWrapper(new VMDisconnectedException());
        }
        return VirtualMachineWrapper.eventRequestManager(vm);
    }

    protected void addEventRequest(EventRequest r) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, InvalidRequestStateExceptionWrapper {
        this.addEventRequest(r, false);
    }

    protected synchronized void addEventRequest(EventRequest r, boolean ignoreHitCount) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, InvalidRequestStateExceptionWrapper {
        block13: {
            block12: {
                logger.fine("BreakpointImpl addEventRequest: " + r);
                this.requests.add(r);
                this.getDebugger().getOperator().register(r, this);
                if (this.getBreakpoint().getSuspend() == 2) {
                    EventRequestWrapper.setSuspendPolicy(r, 2);
                } else {
                    EventRequestWrapper.setSuspendPolicy(r, 1);
                }
                r.putProperty("brkpSuspend", this.getBreakpoint().getSuspend());
                int hitCountFilter = this.getBreakpoint().getHitCountFilter();
                if (ignoreHitCount || hitCountFilter <= 0) break block12;
                EventRequestWrapper.addCountFilter(r, hitCountFilter);
                switch (this.getBreakpoint().getHitCountFilteringStyle()) {
                    case MULTIPLE: {
                        this.hitCountFilter = hitCountFilter;
                        break block13;
                    }
                    case EQUAL: {
                        this.hitCountFilter = 0;
                        break block13;
                    }
                    case GREATER: {
                        this.hitCountFilter = -1;
                        break block13;
                    }
                    default: {
                        throw new IllegalStateException(this.getBreakpoint().getHitCountFilteringStyle().name());
                    }
                }
            }
            this.hitCountFilter = 0;
        }
        try {
            EventRequestWrapper.enable(r);
        }
        catch (InternalExceptionWrapper e) {
            this.getDebugger().getOperator().unregister(r);
            throw e;
        }
        catch (ObjectCollectedExceptionWrapper e) {
            this.getDebugger().getOperator().unregister(r);
            throw e;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            this.getDebugger().getOperator().unregister(r);
            throw e;
        }
        catch (InvalidRequestStateExceptionWrapper e) {
            this.getDebugger().getOperator().unregister(r);
            throw e;
        }
    }

    protected synchronized void removeAllEventRequests() {
        if (this.requests.isEmpty()) {
            return;
        }
        VirtualMachine vm = this.getDebugger().getVirtualMachine();
        if (vm == null) {
            return;
        }
        int k = this.requests.size();
        try {
            for (int i = 0; i < k; ++i) {
                EventRequest r = this.requests.get(i);
                logger.fine("BreakpointImpl removeEventRequest: " + r);
                try {
                    EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(vm), r);
                }
                catch (InvalidRequestStateExceptionWrapper irex) {
                    // empty catch block
                }
                this.getDebugger().getOperator().unregister(r);
            }
        }
        catch (VMDisconnectedExceptionWrapper e) {
        }
        catch (InternalExceptionWrapper e) {
            // empty catch block
        }
        this.requests = new LinkedList<EventRequest>();
    }

    private synchronized void removeEventRequest(EventRequest r) {
        VirtualMachine vm = this.getDebugger().getVirtualMachine();
        if (vm == null) {
            return;
        }
        try {
            logger.fine("BreakpointImpl removeEventRequest: " + r);
            try {
                EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(vm), r);
            }
            catch (InvalidRequestStateExceptionWrapper irex) {
                // empty catch block
            }
            this.getDebugger().getOperator().unregister(r);
        }
        catch (VMDisconnectedExceptionWrapper e) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
        this.requests.remove(r);
    }

    protected abstract EventRequest createEventRequest(EventRequest var1) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper;

    public boolean processCondition(Event event, String condition, ThreadReference threadReference, Value returnValue) {
        return this.processCondition(event, condition, threadReference, returnValue, null);
    }

    public boolean processCondition(Event event, String condition, ThreadReference threadReference, Value returnValue, ObjectReference contextValue) {
        try {
            boolean success;
            EventRequest request = EventWrapper.request(event);
            if (this.hitCountFilter > 0) {
                EventRequestWrapper.disable(request);
                EventRequestWrapper.enable(request);
            }
            if (this.hitCountFilter == -1) {
                EventRequestWrapper.disable(request);
                this.removeEventRequest(request);
                this.addEventRequest(this.createEventRequest(request), true);
            }
            ReturnVariableImpl variable = null;
            if (this.getBreakpoint() instanceof MethodBreakpoint && (((MethodBreakpoint)this.getBreakpoint()).getBreakpointType() & 2) != 0 && returnValue != null) {
                JPDAThreadImpl jt = this.getDebugger().getThread(threadReference);
                ReturnVariableImpl retVariable = new ReturnVariableImpl(this.getDebugger(), returnValue, "", jt.getMethodName());
                jt.setReturnVariable(retVariable);
                variable = retVariable;
            }
            if (condition != null && condition.length() > 0) {
                try {
                    this.getDebugger().setAltCSF(ThreadReferenceWrapper.frame(threadReference, 0));
                }
                catch (IncompatibleThreadStateException e) {
                    String msg = JPDAThreadImpl.getThreadStateLog(threadReference);
                    Logger.getLogger(BreakpointImpl.class.getName()).log(Level.INFO, msg, e);
                }
                catch (ObjectCollectedExceptionWrapper e) {
                }
                catch (IllegalThreadStateExceptionWrapper e) {
                    return false;
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
                AbstractObjectVariable contextVar = contextValue != null ? new AbstractObjectVariable(this.getDebugger(), contextValue, null) : null;
                success = this.evaluateCondition(event, condition, threadReference, contextVar);
                this.getDebugger().setAltCSF(null);
            } else {
                this.compiledCondition = null;
                success = true;
            }
            if (success) {
                this.processedReturnVariable.put(event, variable);
            }
            return success;
        }
        catch (InternalExceptionWrapper iex) {
            return true;
        }
        catch (ObjectCollectedExceptionWrapper iex) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper iex) {
            return false;
        }
        catch (InvalidRequestStateExceptionWrapper irsex) {
            return false;
        }
    }

    protected boolean perform(Event event, ThreadReference threadReference, ReferenceType referenceType, Value value) {
        Throwable cEx;
        Variable variable = this.processedReturnVariable.remove(event);
        if (variable == null) {
            variable = this.debugger.getVariable(value);
        }
        JPDABreakpointEvent e = (cEx = this.conditionException.remove(event)) == null ? new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, 1, (JPDAThread)this.debugger.getThread(threadReference), referenceType, variable) : new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, cEx, (JPDAThread)this.debugger.getThread(threadReference), referenceType, variable);
        try {
            Field f = e.getClass().getDeclaredField("event");
            f.setAccessible(true);
            f.set(e, event);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), e);
        this.enableDisableDependentBreakpoints();
        Integer brkpSuspend = (Integer)event.request().getProperty("brkpSuspend");
        if (brkpSuspend == null) {
            brkpSuspend = this.getBreakpoint().getSuspend();
        }
        boolean resume = brkpSuspend == 0 || e.getResume();
        logger.fine("BreakpointImpl: perform breakpoint: " + this + " resume: " + resume);
        if (!resume) {
            try {
                resume = this.checkWhetherResumeToFinishStep(threadReference);
            }
            catch (InternalExceptionWrapper ex) {
                return false;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return false;
            }
        }
        if (!resume) {
            this.getDebugger().getThread(threadReference).setCurrentBreakpoint(this.breakpoint);
        }
        return resume;
    }

    private void enableDisableDependentBreakpoints() {
        Set breakpoints = this.breakpoint.getBreakpointsToEnable();
        for (Breakpoint b : breakpoints) {
            b.enable();
        }
        breakpoints = this.breakpoint.getBreakpointsToDisable();
        for (Breakpoint b : breakpoints) {
            b.disable();
        }
    }

    private boolean checkWhetherResumeToFinishStep(ThreadReference thread) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        int suspendState;
        List<StepRequest> stepRequests = EventRequestManagerWrapper.stepRequests(VirtualMachineWrapper.eventRequestManager(MirrorWrapper.virtualMachine(thread)));
        if (stepRequests.size() > 0 && ((suspendState = this.breakpoint.getSuspend()) == 2 || suspendState == 1)) {
            boolean thisThreadHasStep = false;
            ArrayList<StepRequest> activeStepRequests = new ArrayList<StepRequest>(stepRequests);
            for (int i = 0; i < activeStepRequests.size(); ++i) {
                int stepThreadStatus;
                StepRequest step = (StepRequest)activeStepRequests.get(i);
                ThreadReference stepThread = StepRequestWrapper.thread(step);
                if (!EventRequestWrapper.isEnabled(step)) {
                    activeStepRequests.remove(i);
                    continue;
                }
                try {
                    stepThreadStatus = ThreadReferenceWrapper.status(StepRequestWrapper.thread(step));
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    stepThreadStatus = 0;
                }
                catch (IllegalThreadStateExceptionWrapper ex) {
                    stepThreadStatus = 0;
                }
                if (stepThreadStatus == 0) {
                    try {
                        EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(MirrorWrapper.virtualMachine(thread)), step);
                    }
                    catch (InvalidRequestStateExceptionWrapper irex) {
                        // empty catch block
                    }
                    this.debugger.getOperator().unregister(step);
                    activeStepRequests.remove(i);
                    continue;
                }
                if (!thread.equals(stepThread)) continue;
                thisThreadHasStep = true;
            }
            if (thisThreadHasStep) {
                return false;
            }
            if (activeStepRequests.size() > 0 && (thisThreadHasStep || suspendState == 2)) {
                Boolean resumeDecision = this.debugger.getStepInterruptByBptResumeDecision();
                if (resumeDecision != null) {
                    return resumeDecision;
                }
                JPDAThreadImpl tr = this.debugger.getThread(thread);
                tr.setStepSuspendedBy(this.breakpoint);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluateCondition(Event event, String condition, ThreadReference thread, ObjectVariable contextVar) {
        try {
            try {
                boolean success;
                JPDAThreadImpl jtr = this.debugger.getThread(thread);
                jtr.accessLock.writeLock().lock();
                try {
                    CallStackFrame[] csfs = jtr.getCallStack(0, 1);
                    success = csfs.length > 0 ? this.evaluateConditionIn(condition, csfs[0], contextVar) : true;
                }
                finally {
                    jtr.accessLock.writeLock().unlock();
                }
                logger.fine("BreakpointImpl: perform breakpoint (condition = " + success + "): " + this + " resume: " + !success);
                return success;
            }
            catch (InvalidExpressionException ex) {
                this.conditionException.put(event, ex);
                logger.fine("BreakpointImpl: perform breakpoint (bad condition): '" + condition + "', got " + ex.getMessage());
                return true;
            }
        }
        catch (AbsentInformationException abex) {
            logger.log(Level.INFO, condition, abex);
            return true;
        }
    }

    private boolean evaluateConditionIn(String condExpr, CallStackFrame csf, ObjectVariable contextVariable) throws InvalidExpressionException {
        if (this.compiledCondition == null || !this.compiledCondition.getExpression().equals(condExpr)) {
            this.compiledCondition = new EvaluatorExpression(condExpr);
        }
        Value value = this.getDebugger().evaluateIn(this.compiledCondition, csf, contextVariable);
        try {
            return PrimitiveValueWrapper.booleanValue((BooleanValue)value);
        }
        catch (ClassCastException e) {
            try {
                throw new InvalidExpressionException("Expecting boolean value instead of " + ValueWrapper.type(value));
            }
            catch (InternalExceptionWrapper ex) {
                throw new InvalidExpressionException("Expecting boolean value");
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                throw new InvalidExpressionException("Expecting boolean value");
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                throw new InvalidExpressionException("Expecting boolean value");
            }
        }
        catch (NullPointerException npe) {
            throw new InvalidExpressionException((Throwable)npe);
        }
        catch (InternalExceptionWrapper ex) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return true;
        }
    }

    static boolean match(String name, String pattern) {
        if (pattern.startsWith("*")) {
            return name.endsWith(pattern.substring(1));
        }
        if (pattern.endsWith("*")) {
            return name.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        return name.equals(pattern);
    }

    private static final class EngineChangeEvent
    extends ChangeEvent {
        private final DebuggerEngine newEngine;

        public EngineChangeEvent(DebuggerEngine e, DebuggerEngine newEngine) {
            super(e);
            this.newEngine = newEngine;
        }

        @Override
        public Object getSource() {
            return this.newEngine;
        }
    }

    private static final class ValidityChangeEvent
    extends ChangeEvent {
        private String reason;

        public ValidityChangeEvent(Breakpoint.VALIDITY validity, String reason) {
            super(validity);
            this.reason = reason;
        }

        @Override
        public String toString() {
            return this.reason;
        }
    }
}

