/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.statistics;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.monitor.cli.MonitorContract;
import org.glassfish.api.ActionReport;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class HTTPListenerStatsImpl
implements MonitorContract {
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    private Logger logger;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(HTTPListenerStatsImpl.class);
    private final String name = "httplistener";
    private final String displayFormat = "%1$-4s %2$-4s %3$-6.2f %4$-4s";

    public String getName() {
        return "httplistener";
    }

    public ActionReport process(ActionReport report, String filter) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("HTTPListenerStatsImpl: process ...");
        }
        if (this.mrdr == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(localStrings.getLocalString("mrdr.null", "MonitoringRuntimeDataRegistry is null"));
            return report;
        }
        TreeNode serverNode = this.mrdr.get("server");
        if (serverNode == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(localStrings.getLocalString("mrdr.null", "MonitoringRuntimeDataRegistry server node is null"));
            return report;
        }
        long errorCount = 0L;
        long maxTime = 0L;
        double processingTime = 0.0;
        long requestCount = 0L;
        List tnL = serverNode.getNodes("server.web.request.*");
        for (TreeNode tn : tnL) {
            if (tn.hasChildNodes()) continue;
            if ("errorcount".equals(tn.getName())) {
                errorCount = this.getCountStatisticValue(tn.getValue());
                continue;
            }
            if ("maxtime".equals(tn.getName())) {
                maxTime = this.getCountStatisticValue(tn.getValue());
                continue;
            }
            if ("processingtime".equals(tn.getName())) {
                processingTime = this.getCountStatisticValue(tn.getValue());
                continue;
            }
            if (!"requestcount".equals(tn.getName())) continue;
            requestCount = this.getCountStatisticValue(tn.getValue());
        }
        report.setMessage(String.format("%1$-4s %2$-4s %3$-6.2f %4$-4s", errorCount, maxTime, processingTime, requestCount));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    private long getCountStatisticValue(Object obj) {
        long l = 0L;
        if (obj == null) {
            return l;
        }
        if (obj instanceof CountStatistic) {
            return ((CountStatistic)obj).getCount();
        }
        return l;
    }

    public CountStatistic getBytesReceived() {
        return null;
    }

    public CountStatistic getBytesSent() {
        return null;
    }

    public CountStatistic getErrorCount() {
        return null;
    }

    public CountStatistic getCount200() {
        return null;
    }

    public CountStatistic getCount2xx() {
        return null;
    }

    public CountStatistic getCount302() {
        return null;
    }

    public CountStatistic getCount304() {
        return null;
    }

    public CountStatistic getCount3xx() {
        return null;
    }

    public CountStatistic getCount400() {
        return null;
    }

    public CountStatistic getCount401() {
        return null;
    }

    public CountStatistic getCount403() {
        return null;
    }

    public CountStatistic getCount404() {
        return null;
    }

    public CountStatistic getCount4xx() {
        return null;
    }

    public CountStatistic getCount503() {
        return null;
    }

    public CountStatistic getCount5xx() {
        return null;
    }

    public CountStatistic getCountOther() {
        return null;
    }

    public CountStatistic getCountOpenConnections() {
        return null;
    }

    public CountStatistic getMaxOpenConnections() {
        return null;
    }

    public CountStatistic getMaxTime() {
        return null;
    }

    public CountStatistic getProcessingTime() {
        return null;
    }

    public CountStatistic getRequestCount() {
        return null;
    }

    public CountStatistic getCurrentThreadCount() {
        return null;
    }

    public CountStatistic getCurrentThreadsBusy() {
        return null;
    }

    public CountStatistic getMaxThreads() {
        return null;
    }

    public CountStatistic getMaxSpareThreads() {
        return null;
    }

    public CountStatistic getMinSpareThreads() {
        return null;
    }

    public Statistic[] getStatistics() {
        return null;
    }

    public String[] getStatisticNames() {
        return null;
    }

    public Statistic getStatistic(String statisticName) {
        return null;
    }
}

