/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.tasklist;

import edu.umd.cs.findbugs.BugInstance;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.nbheaven.sqe.codedefects.core.api.QualitySession;
import org.nbheaven.sqe.core.java.search.SearchUtilities;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsResult;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsSession;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsTaskProvider
extends PushTaskScanner {
    private final Map<QualitySession, PropertyChangeListener> listeners = new WeakHashMap<QualitySession, PropertyChangeListener>();

    public FindBugsTaskProvider() {
        super("FindBugs", "FindBugs found Bugs", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setScope(TaskScanningScope taskScanningScope, final PushTaskScanner.Callback callback) {
        if (taskScanningScope == null) {
            Map<QualitySession, PropertyChangeListener> map = this.listeners;
            synchronized (map) {
                for (Map.Entry<QualitySession, PropertyChangeListener> entry : this.listeners.entrySet()) {
                    entry.getKey().removePropertyChangeListener("Result", entry.getValue());
                }
            }
            return;
        }
        for (FileObject file : taskScanningScope.getLookup().lookupAll(FileObject.class)) {
            FindBugsSession qualitySession;
            Project project;
            if (JavaSource.forFileObject((FileObject)file) == null || (project = FileOwnerQuery.getOwner((FileObject)file)) == null || (qualitySession = (FindBugsSession)project.getLookup().lookup(FindBugsSession.class)) == null) continue;
            FindBugsResult result = this.getResult(qualitySession);
            Map instanceByClass = result.getInstanceByClass(true);
            Collection classes = SearchUtilities.getFQNClassNames((FileObject)file);
            LinkedList<Task> tasks = new LinkedList<Task>();
            for (String className : classes) {
                for (FindBugsResult.ClassKey classKey : instanceByClass.keySet()) {
                    if (!classKey.getDisplayName().equals(className)) continue;
                    Collection bugs = (Collection)instanceByClass.get(classKey);
                    tasks.addAll(this.getTasks(bugs, file));
                }
            }
            callback.setTasks(file, tasks);
        }
        for (final Project project : taskScanningScope.getLookup().lookupAll(Project.class)) {
            FindBugsSession qualitySession = (FindBugsSession)project.getLookup().lookup(FindBugsSession.class);
            if (qualitySession == null) continue;
            FindBugsResult result = this.getResult(qualitySession);
            this.pushTasks(result, callback, project);
            Map<QualitySession, PropertyChangeListener> map = this.listeners;
            synchronized (map) {
                PropertyChangeListener listener = this.listeners.get(qualitySession);
                if (listener != null) {
                    qualitySession.removePropertyChangeListener("Result", listener);
                }
                listener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        FindBugsTaskProvider.this.pushTasks((FindBugsResult)evt.getNewValue(), callback, project);
                    }
                };
                this.listeners.put((QualitySession)qualitySession, listener);
                qualitySession.addPropertyChangeListener("Result", listener);
            }
        }
    }

    private void pushTasks(FindBugsResult result, PushTaskScanner.Callback callback, Project project) {
        LinkedList<Task> tasks = new LinkedList<Task>();
        for (Map.Entry classEntry : result.getInstanceByClass(true).entrySet()) {
            tasks.addAll(this.getTasks((Collection)classEntry.getValue(), ((FindBugsResult.ClassKey)classEntry.getKey()).getFileObject()));
        }
        callback.setTasks(project.getProjectDirectory(), tasks);
    }

    private List<Task> getTasks(Collection<BugInstance> bugs, FileObject file) {
        if (file == null) {
            return Collections.emptyList();
        }
        LinkedList<Task> tasks = new LinkedList<Task>();
        for (BugInstance bugInstance : bugs) {
            tasks.add(Task.create((FileObject)file, (String)"sqe-tasklist-findbugs", (String)bugInstance.getMessage(), (int)bugInstance.getPrimarySourceLineAnnotation().getStartLine()));
        }
        return tasks;
    }

    private FindBugsResult getResult(FindBugsSession qualitySession) {
        FindBugsResult result = qualitySession.getResult();
        if (null == result) {
            result = qualitySession.computeResultAndWait();
        }
        return result;
    }
}

