/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.client;

import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import org.netbeans.modules.websvc.api.client.ClientStubDescriptor;
import org.openide.WizardValidationException;

public interface WsCompileClientEditorSupport {
    public static final String PROP_FEATURES_CHANGED = "featuresChanged";
    public static final String PROP_OPTIONS_CHANGED = "optionsChanged";

    public Panel getWsCompileSupport();

    public static final class FeatureDescriptor {
        private String serviceName;
        private String features;

        public FeatureDescriptor(String serviceName, String features) {
            this.serviceName = serviceName;
            this.features = features;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getFeatures() {
            return this.features;
        }
    }

    public static final class OptionDescriptor {
        private String serviceName;
        private boolean[] options;

        public OptionDescriptor(String serviceName, boolean[] options) {
            this.serviceName = serviceName;
            this.options = options;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public boolean[] getOptions() {
            return this.options;
        }
    }

    public static interface Panel {
        public JPanel getComponent();

        public void initValues(List var1);

        public void validatePanel() throws WizardValidationException;
    }

    public static final class ServiceSettings {
        private String name;
        private ClientStubDescriptor stubType;
        private List availableFeatures;
        private List importantFeatures;
        private String currentFeatures;
        private String newFeatures;
        private boolean[] options;

        public ServiceSettings(String sn, ClientStubDescriptor st, boolean[] options, String c, List a, List i) {
            this.name = sn;
            this.stubType = st;
            this.options = options;
            this.currentFeatures = this.newFeatures = c;
            this.availableFeatures = Collections.unmodifiableList(a);
            this.importantFeatures = Collections.unmodifiableList(i);
        }

        public String getServiceName() {
            return this.name;
        }

        public ClientStubDescriptor getClientStubDescriptor() {
            return this.stubType;
        }

        public String getCurrentFeatures() {
            return this.currentFeatures;
        }

        public boolean[] getOptions() {
            return this.options;
        }

        public void setOptions(boolean[] options) {
            this.options = options;
        }

        public String getNewFeatures() {
            return this.newFeatures;
        }

        public List getAvailableFeatures() {
            return this.availableFeatures;
        }

        public List getImportantFeatures() {
            return this.importantFeatures;
        }

        public String toString() {
            return this.getServiceName();
        }

        public void setNewFeatures(String nf) {
            this.newFeatures = nf;
        }
    }
}

