/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui;

import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.testng.ui.Bundle;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Cancellable;

final class ProgressIndicator
implements Cancellable {
    private final ProgressHandle progressHandle;
    private volatile boolean cancelled = false;

    ProgressIndicator() {
        String msg = Bundle.LBL_generator_progress_title();
        this.progressHandle = ProgressHandleFactory.createHandle((String)msg);
    }

    public boolean cancel() {
        this.cancelled = true;
        return true;
    }

    synchronized boolean isCanceled() {
        return this.cancelled;
    }

    void displayStatusText(String statusText) {
        StatusDisplayer.getDefault().setStatusText(statusText);
    }

    synchronized void setMessage(String msg) {
        this.progressHandle.progress(msg);
    }

    synchronized void show() {
        this.progressHandle.start();
    }

    synchronized void hide() {
        this.progressHandle.finish();
    }
}

