/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.output.antutils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.netbeans.modules.testng.output.antutils.FileSet;
import org.netbeans.modules.testng.output.antutils.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileSetScanner {
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    private static final String[] EMPTY_STRING_ARR = new String[0];
    private final FileSet fileSet;
    private File baseDir;
    private boolean caseSensitive;
    private boolean followSymlinks;
    private AntPattern[] includePatterns;
    private AntPattern[] excludePatterns;
    private Collection<File> matchingFiles;

    static Collection<File> listFiles(FileSet fileSet) {
        return new FileSetScanner(fileSet).getMatchingFiles();
    }

    FileSetScanner(FileSet fileSet) {
        this.fileSet = fileSet;
    }

    Collection<File> getMatchingFiles() {
        File file = this.fileSet.getFile();
        if (file != null) {
            file = FileUtils.resolveFile(this.fileSet.getBaseDir(), file.getName());
            if (file.exists()) {
                return Collections.singleton(file);
            }
            return Collections.emptyList();
        }
        this.baseDir = this.fileSet.getBaseDir();
        this.caseSensitive = this.fileSet.isCaseSensitive();
        this.followSymlinks = this.fileSet.isFollowSymlinks();
        this.preparePatterns();
        this.findMatchingFiles();
        return this.matchingFiles;
    }

    private void findMatchingFiles() {
        this.matchingFiles = new ArrayList<File>(32);
        this.findMatchingFiles(this.baseDir, FileSetScanner.createPatternTests(this.includePatterns, this.excludePatterns));
    }

    private void findMatchingFiles(File directory, Collection<PatternTest> patternTests) {
        File[] children = directory.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            ArrayList<PatternTest> childTests;
            boolean matches;
            boolean isFile = child.isFile();
            boolean isDir = child.isDirectory();
            if (!isFile && !isDir || !(matches = this.checkFileAgainstPatterns(child, patternTests, childTests = isDir ? new ArrayList<PatternTest>(patternTests.size()) : null))) continue;
            if (isFile) {
                this.matchingFiles.add(child);
                continue;
            }
            this.findMatchingFiles(child, childTests);
        }
    }

    private boolean checkFileAgainstPatterns(File file, Collection<PatternTest> tests, Collection<PatternTest> childrenTests) {
        assert (!tests.isEmpty());
        assert (tests.iterator().next().includePattern);
        boolean isDir = childrenTests != null;
        boolean isFile = !isDir;
        boolean matches = false;
        for (PatternTest patternTest : tests) {
            boolean nameMatches;
            AntPattern pattern = patternTest.pattern;
            boolean isIncludePattern = patternTest.includePattern;
            int partIndex = patternTest.patternPartIndex;
            AntPattern.PatternPartType partType = pattern.patternPartTypes[partIndex];
            boolean isLastPart = pattern.isLastPart(partIndex);
            if (isIncludePattern && isLastPart && partType == AntPattern.PatternPartType.DOUBLE_STAR) {
                matches = true;
                if (childrenTests == null) continue;
                childrenTests.add(patternTest);
                continue;
            }
            if (isFile && (!isLastPart || matches && isIncludePattern) || isDir && isLastPart && partType != AntPattern.PatternPartType.DOUBLE_STAR || !(nameMatches = partType == AntPattern.PatternPartType.DOUBLE_STAR || this.isMatchingFile(file, pattern, partIndex))) continue;
            if (!isLastPart) {
                assert (isDir);
                if (isIncludePattern) {
                    matches = true;
                }
                int nextPartIndex = partIndex + 1;
                AntPattern.PatternPartType nextPartType = pattern.patternPartTypes[nextPartIndex];
                if (partType != AntPattern.PatternPartType.DOUBLE_STAR && nextPartType == AntPattern.PatternPartType.DOUBLE_STAR && pattern.isLastPart(nextPartIndex)) {
                    if (isIncludePattern) {
                        childrenTests.clear();
                        childrenTests.add(new PatternTest(pattern, isIncludePattern, nextPartIndex));
                        continue;
                    }
                    matches = false;
                    break;
                }
                childrenTests.add(new PatternTest(pattern, isIncludePattern, partIndex + 1));
                if (partType != AntPattern.PatternPartType.DOUBLE_STAR) continue;
                childrenTests.add(patternTest);
                continue;
            }
            if (isIncludePattern) {
                assert (!isDir);
                matches = true;
                continue;
            }
            matches = false;
            break;
        }
        return matches;
    }

    private boolean isMatchingFile(File file, AntPattern pattern, int partIndex) {
        assert (file.isDirectory() || file.isFile());
        String name = file.getName();
        AntPattern.PatternPartType patternType = pattern.patternPartTypes[partIndex];
        assert (patternType == AntPattern.PatternPartType.PLAIN || patternType == AntPattern.PatternPartType.REGEXP);
        if (patternType == AntPattern.PatternPartType.PLAIN) {
            String fileNamePattern = pattern.patternParts[partIndex];
            return this.caseSensitive ? name.equals(fileNamePattern) : name.equalsIgnoreCase(fileNamePattern);
        }
        Pattern patternPartMatcher = pattern.getPatternPartMatcher(partIndex, this.caseSensitive);
        assert (pattern.patternPartMatchers[partIndex] != null);
        return pattern.patternPartMatchers[partIndex].matcher(name).matches();
    }

    private static Collection<PatternTest> createPatternTests(AntPattern[] includePatterns, AntPattern[] excludePatterns) {
        ArrayList<PatternTest> result = new ArrayList<PatternTest>(includePatterns.length + excludePatterns.length);
        for (AntPattern pattern : includePatterns) {
            if (pattern.patternPartTypes[0] == AntPattern.PatternPartType.DOUBLE_STAR) {
                if (pattern.isLastPart(0)) {
                    result.clear();
                    result.add(new PatternTest(pattern, true, 0));
                    break;
                }
                result.add(new PatternTest(pattern, true, 1));
            }
            result.add(new PatternTest(pattern, true, 0));
        }
        for (AntPattern pattern : excludePatterns) {
            if (pattern.patternPartTypes[0] == AntPattern.PatternPartType.DOUBLE_STAR) {
                if (pattern.isLastPart(0)) {
                    return Collections.emptyList();
                }
                result.add(new PatternTest(pattern, false, 1));
            }
            result.add(new PatternTest(pattern, false, 0));
        }
        return result;
    }

    private void preparePatterns() {
        Collection<String> patterns = this.fileSet.getIncludePatterns();
        if (patterns.isEmpty()) {
            patterns = Collections.singletonList("**");
        }
        this.includePatterns = this.parsePatternStrings(patterns);
        patterns = this.fileSet.getExcludesPatterns();
        if (this.fileSet.isDefaultExcludes()) {
            List<String> defExcludes = Arrays.asList(DEFAULT_EXCLUDES);
            if (patterns.isEmpty()) {
                patterns = defExcludes;
            } else {
                patterns.addAll(defExcludes);
            }
        }
        this.excludePatterns = this.parsePatternStrings(patterns);
    }

    private AntPattern[] parsePatternStrings(Collection<String> patternStrings) {
        AntPattern[] patterns = new AntPattern[patternStrings.size()];
        Iterator<String> it = patternStrings.iterator();
        for (int i = 0; i < patterns.length; ++i) {
            patterns[i] = this.parsePatternString(it.next());
        }
        return patterns;
    }

    AntPattern parsePatternString(String patternString) {
        String token;
        if (patternString.length() != 0 && patternString.charAt(0) == File.separatorChar) assert (false) : "corner case - not implemented";
        ArrayList<String> tokens = new ArrayList<String>(6);
        boolean lastWasDoubleStar = false;
        int tokenStart = 0;
        int slashIndex = patternString.indexOf(File.separatorChar);
        while (slashIndex != -1) {
            token = patternString.substring(tokenStart, slashIndex);
            boolean isDoubleStar = token.equals("**");
            if (!isDoubleStar || !lastWasDoubleStar) {
                tokens.add(patternString.substring(tokenStart, slashIndex));
            }
            lastWasDoubleStar = isDoubleStar;
            tokenStart = slashIndex + 1;
            slashIndex = patternString.indexOf(File.separatorChar, tokenStart);
        }
        token = tokenStart == patternString.length() ? "**" : patternString.substring(tokenStart);
        if (!lastWasDoubleStar || !token.equals("**")) {
            tokens.add(token);
        }
        String[] patternParts = new String[tokens.size()];
        tokens.toArray(patternParts);
        return new AntPattern(patternParts);
    }

    static final class AntPattern {
        private static final int CASE_SENSITIVE_FLAGS = 0;
        private static final int CASE_INSENSITIVE_FLAGS = 66;
        final String[] patternParts;
        final PatternPartType[] patternPartTypes;
        private final Pattern[] patternPartMatchers;

        AntPattern(String[] patternParts) {
            if (patternParts == null) {
                throw new IllegalArgumentException("patternParts: null");
            }
            this.patternParts = patternParts;
            this.patternPartTypes = new PatternPartType[patternParts.length];
            this.patternPartMatchers = new Pattern[patternParts.length];
            for (int i = 0; i < patternParts.length; ++i) {
                String pattern = patternParts[i];
                PatternPartType patternPartType = pattern.equals("**") ? PatternPartType.DOUBLE_STAR : (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1 ? PatternPartType.REGEXP : PatternPartType.PLAIN);
                this.patternPartTypes[i] = patternPartType;
            }
        }

        Pattern getPatternPartMatcher(int partIndex, boolean caseSensitive) {
            Pattern matcher = this.patternPartMatchers[partIndex];
            if (matcher == null) {
                this.patternPartMatchers[partIndex] = matcher = Pattern.compile(AntPattern.makeJdkPattern(this.patternParts[partIndex]), caseSensitive ? 0 : 66);
            }
            return matcher;
        }

        static String makeJdkPattern(String antRegexp) {
            StringBuilder buf = new StringBuilder(antRegexp.length() + 16);
            StringTokenizer tokenizer = new StringTokenizer(antRegexp, "*?", true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.length() == 0) continue;
                if (token.equals("?")) {
                    buf.append(token);
                    continue;
                }
                if (token.equals("*")) {
                    buf.append(".*");
                    continue;
                }
                buf.append(AntPattern.quote(token));
            }
            return buf.toString();
        }

        static String quote(String str) {
            String SPECIAL_CHARS = "\\.[](){}+^$|?*";
            StringBuilder buf = null;
            char[] chars = str.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if ("\\.[](){}+^$|?*".indexOf(c) != -1) {
                    if (buf == null) {
                        buf = new StringBuilder(str.length() + 10);
                        buf.append(str.substring(0, i));
                    }
                    buf.append('\\');
                }
                if (buf == null) continue;
                buf.append(c);
            }
            return buf != null ? buf.toString() : str;
        }

        boolean isLastPart(int index) {
            return index == this.patternParts.length - 1;
        }

        public boolean equals(Object object) {
            return object != null && object.getClass() == AntPattern.class && Arrays.equals(this.patternParts, ((AntPattern)object).patternParts);
        }

        public int hashCode() {
            int hash = 131;
            for (int i = 0; i < this.patternParts.length; ++i) {
                hash += this.patternParts[i].hashCode() << i;
            }
            return hash;
        }

        public String toString() {
            String patternsString;
            if (this.patternParts.length == 0) {
                patternsString = "[]";
            } else {
                StringBuilder buf = new StringBuilder(256);
                buf.append('[');
                buf.append(this.patternParts[0]);
                for (int i = 1; i < this.patternParts.length; ++i) {
                    buf.append(',').append(this.patternParts[i]);
                }
                buf.append(']');
                patternsString = buf.toString();
            }
            return super.toString() + patternsString;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum PatternPartType {
            DOUBLE_STAR,
            REGEXP,
            PLAIN;

        }
    }

    static final class PatternTest {
        final AntPattern pattern;
        final boolean includePattern;
        int patternPartIndex;

        PatternTest(AntPattern pattern, boolean includePattern, int index) {
            this.pattern = pattern;
            this.includePattern = includePattern;
            this.patternPartIndex = index;
        }
    }
}

