/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.output.antutils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tools.ant.module.spi.TaskStructure;
import org.netbeans.modules.testng.output.antutils.AntProject;
import org.netbeans.modules.testng.output.antutils.FileSet;
import org.netbeans.modules.testng.output.antutils.FileSetScanner;

final class BatchTest {
    private final AntProject project;
    private Collection<FileSet> fileSets = new ArrayList<FileSet>();

    BatchTest(AntProject project) {
        this.project = project;
    }

    void handleChildrenAndAttrs(TaskStructure struct) {
        for (TaskStructure child : struct.getChildren()) {
            String childName = child.getName();
            if (!childName.equals("fileset")) continue;
            FileSet fs = new FileSet(this.project);
            this.fileSets.add(fs);
            fs.handleChildrenAndAttrs(child);
        }
    }

    int countTestClasses() {
        int count = 0;
        for (FileSet fileSet : this.fileSets) {
            Collection<File> matchingFiles = FileSetScanner.listFiles(fileSet);
            for (File file : matchingFiles) {
                String name = file.getName();
                if (!name.endsWith(".java") && !name.endsWith(".class")) continue;
                ++count;
            }
        }
        return count;
    }
}

