/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.output;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.testng.actions.TestConfigAccessor;
import org.netbeans.modules.testng.api.TestNGSupport;
import org.netbeans.modules.testng.spi.TestConfig;
import org.netbeans.modules.testng.spi.TestNGSupportImplementation;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGExecutionManager
implements RerunHandler {
    private File scriptFile = null;
    private String[] targets = null;
    private Properties properties;
    private TestSession testSession;
    private Lookup lookup = Lookup.EMPTY;
    private static final Logger LOGGER = Logger.getLogger(TestNGExecutionManager.class.getName());

    public TestNGExecutionManager(AntSession session, TestSession testSession, Properties props) {
        this.testSession = testSession;
        this.properties = props;
        this.properties.setProperty("ignore.failing.tests", "true");
        try {
            FileObject testFO;
            this.scriptFile = session.getOriginatingScript();
            this.targets = session.getOriginatingTargets();
            String testIncludes = this.properties.getProperty("test.includes");
            if (testIncludes != null && (testFO = testSession.getFileLocator().find(testIncludes)) != null) {
                this.lookup = Lookups.fixed((Object[])new Object[]{DataObject.find((FileObject)testFO)});
            }
            if (this.targets.length == 0) {
                String className = this.properties.getProperty("classname");
                String methodName = this.properties.getProperty("methodname");
                if (className != null) {
                    FileObject testFO2 = testSession.getFileLocator().find(className.replace('.', '/') + ".java");
                    if (methodName != null) {
                        SingleMethod methodSpec = new SingleMethod(testFO2, methodName);
                        this.lookup = Lookups.singleton((Object)methodSpec);
                    } else {
                        this.lookup = Lookups.fixed((Object[])new Object[]{DataObject.find((FileObject)testFO2)});
                    }
                }
                if (this.scriptFile.getName().equals("junit.xml")) {
                    this.targets = methodName != null ? new String[]{"run.single.method"} : new String[]{"test.single"};
                } else if (this.scriptFile.getName().equals("junit-debug.xml")) {
                    this.targets = methodName != null ? new String[]{"debug.single.method"} : new String[]{"debug.test.single"};
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, null, e);
        }
    }

    public void rerun() {
        if (this.properties.getProperty("test.includes") != null && this.properties.getProperty("test.includes").endsWith(".xml")) {
            try {
                TestNGExecutionManager.runAnt(FileUtil.toFileObject((File)this.scriptFile), this.targets, this.properties);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        } else {
            Project project = this.testSession.getProject();
            if (ProjectManager.getDefault().isValid(project)) {
                ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
                String[] actionNames = TestNGExecutionManager.getActionNames(this.targets);
                if (actionProvider != null && Arrays.asList(actionProvider.getSupportedActions()).contains(actionNames[0]) && actionProvider.isActionEnabled(actionNames[0], this.lookup)) {
                    actionProvider.invokeAction(actionNames[0], this.lookup);
                }
            }
        }
    }

    public void rerun(Set<Testcase> tests) {
        Project p = this.testSession.getProject();
        TestNGSupportImplementation.TestExecutor exec = TestNGSupport.findTestNGSupport(p).createExecutor(p);
        TestConfig conf = TestConfigAccessor.getDefault().createTestConfig(p.getProjectDirectory(), true, null, null, null);
        try {
            exec.execute(TestNGSupport.Action.RUN_FAILED, conf);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public boolean enabled(RerunType type) {
        switch (type) {
            case ALL: {
                return true;
            }
            case CUSTOM: {
                Project p = this.testSession.getProject();
                if (TestNGSupport.isActionSupported(TestNGSupport.Action.RUN_FAILED, p)) {
                    return TestNGSupport.findTestNGSupport(p).createExecutor(p).hasFailedTests();
                }
                return false;
            }
        }
        return false;
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    private static void runAnt(FileObject antScript, String[] antTargets, Properties antProps) throws IOException {
        AntTargetExecutor.Env execenv = new AntTargetExecutor.Env();
        Properties props = execenv.getProperties();
        props.putAll((Map<?, ?>)antProps);
        execenv.setProperties(props);
        AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)execenv).execute(AntScriptUtils.antProjectCookieFor((FileObject)antScript), antTargets);
    }

    private static String[] getActionNames(String[] targetNames) {
        String[] actions = new String[targetNames.length];
        for (int i = 0; i < targetNames.length; ++i) {
            actions[i] = targetNames[i].equals("test-single") ? "test.single" : (targetNames[i].equals("debug-test") ? "debug.test.single" : targetNames[i]);
        }
        return actions;
    }
}

