/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.actions;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.TestCreatorProvider;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.java.testrunner.CommonTestUtil;
import org.netbeans.modules.testng.actions.Bundle;
import org.netbeans.modules.testng.api.TestNGSupport;
import org.netbeans.modules.testng.ui.TestNGPlugin;
import org.netbeans.modules.testng.ui.TestNGPluginTrampoline;
import org.netbeans.modules.testng.ui.TestUtil;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class TestNGTestCreatorProvider
extends TestCreatorProvider {
    private static final Logger LOGGER = Logger.getLogger(TestNGTestCreatorProvider.class.getName());

    public boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        DataObject dataObject = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        if (dataObject != null) {
            Project p = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
            return TestNGSupport.isActionSupported(TestNGSupport.Action.CREATE_TEST, p);
        }
        return false;
    }

    public void createTests(TestCreatorProvider.Context context) {
        DataObject dataObject = (DataObject)context.getActivatedNodes()[0].getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return;
        }
        final FileObject[] filesToTest = TestNGTestCreatorProvider.getFileObjectsFromNodes(context.getActivatedNodes());
        if (filesToTest == null) {
            return;
        }
        final TestNGPlugin plugin = TestUtil.getPluginForProject(FileOwnerQuery.getOwner((FileObject)filesToTest[0]));
        if (!TestNGPluginTrampoline.DEFAULT.createTestActionCalled(plugin, filesToTest)) {
            return;
        }
        boolean singleClass = context.isSingleClass();
        final Map params = CommonTestUtil.getSettingsMap((!singleClass ? 1 : 0) != 0);
        if (singleClass) {
            String name = context.getTestClassName();
            params.put(CommonPlugin.CreateTestParam.CLASS_NAME, name);
        }
        final FileObject targetFolder = context.getTargetFolder();
        TestNGSupport.findTestNGSupport(FileOwnerQuery.getOwner((FileObject)targetFolder)).configureProject(targetFolder);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                FileObject[] testFileObjects = TestNGPluginTrampoline.DEFAULT.createTests(plugin, filesToTest, targetFolder, params);
                if (testFileObjects.length == 1) {
                    try {
                        DataObject dobj = DataObject.find((FileObject)testFileObjects[0]);
                        final EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                        if (ec != null) {
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    ec.open();
                                }
                            });
                        }
                    }
                    catch (DataObjectNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    private static FileObject[] getFileObjectsFromNodes(Node[] nodes) {
        FileObject[] fileObjects = new FileObject[nodes.length];
        ArrayList<FileObject> fileObjectsList = null;
        for (int i = 0; i < nodes.length; ++i) {
            FileObject fo;
            Node node = nodes[i];
            if (!TestNGTestCreatorProvider.hasParentAmongNodes(nodes, i) && (fo = TestNGTestCreatorProvider.getTestFileObject(node)) != null) {
                if (fileObjects != null) {
                    fileObjects[i] = fo;
                    continue;
                }
                if (fileObjectsList == null) {
                    fileObjectsList = new ArrayList<FileObject>(nodes.length - i);
                }
                fileObjectsList.add(fo);
                continue;
            }
            fileObjects = null;
        }
        if (fileObjects == null && fileObjectsList != null) {
            fileObjects = fileObjectsList.toArray(new FileObject[fileObjectsList.size()]);
            fileObjectsList = null;
        }
        return fileObjects;
    }

    private static boolean hasParentAmongNodes(Node[] nodes, int idx) {
        for (Node node = nodes[idx].getParentNode(); null != node; node = node.getParentNode()) {
            for (int i = 0; i < nodes.length; ++i) {
                if (i == idx || node != nodes[i]) continue;
                return true;
            }
        }
        return false;
    }

    private static FileObject getTestFileObject(Node node) {
        FileObject fo = TestUtil.getFileObjectFromNode((Node)node);
        if (fo == null) {
            TestUtil.notifyUser(Bundle.MSG_file_from_node_failed());
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp == null) {
            TestUtil.notifyUser(Bundle.MSG_no_project(fo));
            return null;
        }
        return fo;
    }
}

