/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.actions;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TestClassInfoTask
implements CancellableTask<CompilationController> {
    private final int caretPosition;
    private String packageName;
    private String className;
    private String methodName;
    private FileObject fo;
    static String ANNOTATION = "org.testng.annotations.Test";

    TestClassInfoTask(int caretPosition) {
        this.caretPosition = caretPosition;
    }

    public void cancel() {
    }

    public void run(CompilationController controller) throws Exception {
        TreePath tp;
        controller.toPhase(JavaSource.Phase.RESOLVED);
        this.fo = controller.getFileObject();
        TypeElement typeElement22 = null;
        List topLevelElements = controller.getTopLevelElements();
        for (TypeElement typeElement22 : topLevelElements) {
            if (typeElement22.getKind() != ElementKind.CLASS) continue;
            this.className = typeElement22.getSimpleName().toString();
            break;
        }
        Elements elements = controller.getElements();
        if (typeElement22 != null) {
            this.packageName = elements.getPackageOf(typeElement22).getQualifiedName().toString();
        }
        for (tp = controller.getTreeUtilities().pathFor(this.caretPosition); tp != null && tp.getLeaf().getKind() != Tree.Kind.METHOD; tp = tp.getParentPath()) {
        }
        if (tp != null) {
            Element element = controller.getTrees().getElement(tp);
            List<? extends AnnotationMirror> allAnnotationMirrors = elements.getAllAnnotationMirrors(element);
            for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
                typeElement22 = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (!typeElement22.getQualifiedName().contentEquals(ANNOTATION)) continue;
                this.methodName = element.getSimpleName().toString();
                break;
            }
        }
    }

    String getClassName() {
        return this.className;
    }

    String getMethodName() {
        return this.methodName;
    }

    String getPackageName() {
        return this.packageName;
    }

    FileObject getFileObject() {
        return this.fo;
    }
}

