/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.actions;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.testng.actions.TestClassInfoTask;
import org.netbeans.modules.testng.actions.TestConfigAccessor;
import org.netbeans.modules.testng.api.TestNGSupport;
import org.netbeans.modules.testng.spi.TestConfig;
import org.netbeans.modules.testng.spi.TestNGSupportImplementation;
import org.netbeans.spi.project.SingleMethod;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class RunTestMethodAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(RunTestMethodAction.class.getName());

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        Lookup l = activatedNodes[0].getLookup();
        DataObject dataObject = (DataObject)l.lookup(DataObject.class);
        if (dataObject != null) {
            Project p = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
            return TestNGSupport.isActionSupported(TestNGSupport.Action.RUN_TESTMETHOD, p);
        }
        SingleMethod sm = (SingleMethod)l.lookup(SingleMethod.class);
        if (sm != null) {
            Project p = FileOwnerQuery.getOwner((FileObject)sm.getFile());
            return TestNGSupport.isActionSupported(TestNGSupport.Action.RUN_TESTMETHOD, p);
        }
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        JEditorPane[] panes;
        Lookup l = activatedNodes[0].getLookup();
        EditorCookie ec = (EditorCookie)l.lookup(EditorCookie.class);
        SingleMethod sm = (SingleMethod)l.lookup(SingleMethod.class);
        if (ec == null && sm == null) {
            throw new UnsupportedOperationException();
        }
        FileObject fo = null;
        String testMethod = null;
        TestClassInfoTask task = new TestClassInfoTask(0);
        if (ec != null && (panes = ec.getOpenedPanes()).length > 0) {
            int cursor = panes[0].getCaret().getDot();
            JavaSource js = JavaSource.forDocument((Document)panes[0].getDocument());
            task = new TestClassInfoTask(cursor);
            try {
                js.runUserActionTask((Task)task, true);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
            if (task.getMethodName() == null) {
                // empty if block
            }
            DataObject dobj = (DataObject)l.lookup(DataObject.class);
            fo = dobj.getPrimaryFile();
            testMethod = task.getMethodName();
        }
        if (sm != null) {
            fo = sm.getFile();
            testMethod = sm.getMethodName();
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            try {
                js.runUserActionTask((Task)task, true);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        assert (fo != null);
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        TestNGSupportImplementation.TestExecutor exec = TestNGSupport.findTestNGSupport(p).createExecutor(p);
        TestConfig conf = TestConfigAccessor.getDefault().createTestConfig(fo, false, task.getPackageName(), task.getClassName(), testMethod);
        try {
            exec.execute(TestNGSupport.Action.RUN_TESTMETHOD, conf);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public String getName() {
        return NbBundle.getMessage(RunTestMethodAction.class, (String)"CTL_RunTestMethodAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

