/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.protocol.Protocol;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQDirectConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.OperationRunnableFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.QueueBrowserInfo;
import com.sun.messaging.jmq.jmsserver.service.imq.SessionListener;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.pool.ThreadPool;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSPacket;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceBootStrapContext;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.Xid;

public class IMQDirectService
extends IMQService
implements JMSService {
    private static boolean DEBUG = false;
    private boolean acEnabled = false;
    Map localConnectionList = Collections.synchronizedMap(new HashMap());
    Map queueBrowseList = Collections.synchronizedMap(new HashMap());
    Protocol protocol;
    protected ThreadPool pool = null;
    private ConnectionManager connectionList = Globals.getConnectionManager();
    private AuthCacheData authCacheData = new AuthCacheData();
    protected Thread listenThread = null;
    HashMap serviceprops = null;

    public IMQDirectService(String string, int n, int n2, int n3, boolean bl) {
        super(string, n);
        this.protocol = Globals.getProtocol();
        this.acEnabled = bl;
        OperationRunnableFactory operationRunnableFactory = new OperationRunnableFactory(true);
        this.pool = new ThreadPool(string, n2, n3, operationRunnableFactory);
    }

    public synchronized void startService(boolean bl) {
        if (this.isServiceRunning() || this.listenThread != null) {
            this.logger.log(4, "B3100", (Object)"unable to start service, already started.");
            return;
        }
        this.setState(2);
        Object[] objectArray = new String[]{this.getName(), "", String.valueOf(this.getMinThreadpool()), String.valueOf(this.getMaxThreadpool())};
        this.logger.log(8, "B1004", objectArray);
        try {
            this.logger.log(8, "B1227", (Object)AccessController.getInstance(this.getName(), this.getServiceType()).getUserRepository(), (Object)this.getName());
        }
        catch (BrokerException brokerException) {
            this.logger.log(16, "B2135", (Object)this.getName(), (Object)brokerException.getMessage());
        }
        if (bl) {
            this.setServiceRunning(false);
            this.setState(4);
            try {
                Globals.getPortMapper().updateServicePort(this.name, 0);
            }
            catch (Exception exception) {
                this.logger.logStack(16, "B3100", (Object)("starting paused service " + this), (Throwable)exception);
            }
        } else {
            this.setServiceRunning(true);
            this.setState(3);
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService(boolean bl) {
        int n;
        Object object;
        Object object2 = this;
        synchronized (object2) {
            if (this.isShuttingDown()) {
                return;
            }
            object = new String[]{this.getName(), ""};
            if (bl) {
                this.logger.log(8, "B1007", (Object[])object);
            } else if (!this.isShuttingDown()) {
                this.logger.log(8, "B1053", (Object[])object);
            }
            this.setShuttingDown(true);
        }
        if (this.getServiceType() == 0) {
            object2 = this.connectionList.getConnectionList(this);
            object = null;
            for (n = object2.size() - 1; n >= 0; --n) {
                object = (Connection)object2.get(n);
                ((Connection)object).stopConnection();
            }
        }
        object2 = this;
        synchronized (object2) {
            this.setState(5);
            this.notify();
        }
        if (!bl) {
            return;
        }
        if (this.getServiceType() == 0) {
            object2 = this.connectionList.getConnectionList(this);
            object = null;
            for (n = object2.size() - 1; n >= 0; --n) {
                object = (Connection)object2.get(n);
                ((Connection)object).destroyConnection(true, 1, Globals.getBrokerResources().getKString("B0060"));
            }
        }
        object2 = this;
        synchronized (object2) {
            this.setState(6);
            this.notify();
        }
        if (DEBUG) {
            this.logger.log(4, "Destroying Service {0}", (Object)this.getName());
        }
    }

    public void pauseService(boolean bl) {
        if (!this.isServiceRunning()) {
            this.logger.log(4, "B3100", (Object)("unable to pause service " + this.name + ", already paused."));
            return;
        }
        Object[] objectArray = new String[]{this.getName(), ""};
        this.logger.log(4, "B1005", objectArray);
        try {
            this.stopNewConnections();
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B3100", (Object)("pausing service " + this), (Throwable)exception);
        }
        this.setState(4);
        this.setServiceRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeService() {
        if (this.isServiceRunning()) {
            this.logger.log(4, "B3100", (Object)("unable to resume service " + this.name + ", already running."));
            return;
        }
        Object[] objectArray = new String[]{this.getName(), ""};
        this.logger.log(4, "B1006", objectArray);
        try {
            this.startNewConnections();
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B3100", (Object)("pausing service " + this), (Throwable)exception);
        }
        this.setServiceRunning(true);
        IMQDirectService iMQDirectService = this;
        synchronized (iMQDirectService) {
            this.setState(3);
            this.notify();
        }
    }

    public void updateService(int n, int n2, int n3) throws IOException, PropertyUpdateException, BrokerException {
        Globals.getPortMapper().updateServicePort(this.name, 0);
        Globals.getPortMapper().removeService(this.name);
        Globals.getPortMapper().addService(this.name, "none", Globals.getConfig().getProperty("imq." + this.name + ".servicetype"), 0, this.getServiceProperties());
    }

    public AuthCacheData getAuthCacheData() {
        return this.authCacheData;
    }

    public IMQConnection createDirectConnection(String string, String string2) throws BrokerException {
        IMQDirectConnection iMQDirectConnection = null;
        iMQDirectConnection = new IMQDirectConnection(this);
        this.connectionList.addConnection(iMQDirectConnection);
        this.localConnectionList.put(iMQDirectConnection.getConnectionUID(), iMQDirectConnection);
        try {
            iMQDirectConnection.authenticate(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string3 = "Authentication failed for username " + string + " in service " + this.getName() + ": " + exception;
            this.logger.log(16, string3);
            this.logger.log(16, "B2130", (Throwable)exception);
            this.connectionList.removeConnection(iMQDirectConnection.getConnectionUID(), true, 4, string3);
            this.localConnectionList.remove((Object)iMQDirectConnection.getConnectionUID());
            throw new SecurityException(string3);
        }
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.registerConnection(iMQDirectConnection.getConnectionUID().longValue());
            agent.notifyConnectionOpen(iMQDirectConnection.getConnectionUID().longValue());
        }
        return iMQDirectConnection;
    }

    public void removeConnection(ConnectionUID connectionUID, int n, String string) {
        this.connectionList.removeConnection(connectionUID, true, n, string);
        this.localConnectionList.remove((Object)connectionUID);
    }

    public boolean isDirect() {
        return true;
    }

    public String getJMSServiceID() {
        return this.getName();
    }

    public JMSServiceReply createConnection(String string, String string2, JMSServiceBootStrapContext jMSServiceBootStrapContext) throws JMSServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        IMQConnection iMQConnection = null;
        try {
            iMQConnection = this.createDirectConnection(string, string2);
        }
        catch (BrokerException brokerException) {
            String string3 = "Failed to create direct connection for user: " + string;
            this.logger.logStack(32, string3, (Throwable)brokerException);
            hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(string3, brokerException, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        hashMap.put("JMQConnectionID", iMQConnection.getConnectionUID().longValue());
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply destroyConnection(long l) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        if (this.getState() != 6) {
            IMQConnection iMQConnection = this.checkConnectionId(l, "destroyConnection");
            this.localConnectionList.remove((Object)iMQConnection.getConnectionUID());
            iMQConnection.destroyConnection(false, 5, Globals.getBrokerResources().getKString("B0059"));
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public long[] generateUID(long l, int n) throws JMSServiceException {
        IMQConnection iMQConnection = null;
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        iMQConnection = this.checkConnectionId(l, "generateUID");
        if (n < 0) {
            String string = "generateUID: quantity is less than 0: " + n;
            this.logger.log(32, string);
            hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(string, hashMap);
        }
        if (n == 0) {
            return null;
        }
        long[] lArray = new long[n];
        short s = UID.getPrefix();
        for (int i = 0; i < n; ++i) {
            lArray[i] = UniqueID.generateID((short)s);
        }
        return lArray;
    }

    public long generateUID(long l) throws JMSServiceException {
        long[] lArray = this.generateUID(l, 1);
        return lArray[0];
    }

    public JMSServiceReply setClientId(long l, String string, boolean bl, String string2) throws JMSServiceException {
        IMQConnection iMQConnection = null;
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        iMQConnection = this.checkConnectionId(l, "setClientId");
        try {
            this.protocol.setClientID(iMQConnection, string, string2, bl);
        }
        catch (BrokerException brokerException) {
            String string3 = "setClientId: set client ID failed. Connection ID: " + l + ", Client ID: " + string + ", Shareable: " + bl + ", nameSpace: " + string2;
            this.logger.logStack(32, string3, (Throwable)brokerException);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(brokerException));
            throw new JMSServiceException(string3, brokerException, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply unsetClientId(long l) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection iMQConnection = this.checkConnectionId(l, "unsetClientId");
        try {
            this.protocol.setClientID(iMQConnection, null, null, false);
        }
        catch (BrokerException brokerException) {
            String string = "unsetClientId: unset client ID failed. Connection ID: " + l;
            this.logger.logStack(32, string, (Throwable)brokerException);
            hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(string, brokerException, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply startConnection(long l) throws JMSServiceException {
        IMQConnection iMQConnection = this.checkConnectionId(l, "startConnection");
        this.protocol.resumeConnection(iMQConnection);
        SessionListener.startConnection(iMQConnection);
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply stopConnection(long l) throws JMSServiceException {
        IMQConnection iMQConnection = this.checkConnectionId(l, "stopConnection");
        this.protocol.pauseConnection(iMQConnection);
        SessionListener.stopConnection(iMQConnection);
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply createSession(long l, JMSService.SessionAckMode sessionAckMode) throws JMSServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        long l2 = 0L;
        IMQConnection iMQConnection = this.checkConnectionId(l, "createSession");
        try {
            int n = this.convertToBrokerAckMode(sessionAckMode);
            Session session = this.protocol.createSession(n, iMQConnection);
            new SessionListener(this, session);
            l2 = session.getSessionUID().longValue();
        }
        catch (BrokerException brokerException) {
            String string = "createSession: create session failed. Connection ID: " + l + ", acknowledge mode: " + (Object)((Object)sessionAckMode);
            this.logger.logStack(32, string, (Throwable)brokerException);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(brokerException));
            throw new JMSServiceException(string, brokerException, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        hashMap.put("JMQSessionID", l2);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply destroySession(long l, long l2) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection iMQConnection = this.checkConnectionId(l, "destroySession");
        SessionUID sessionUID = new SessionUID(l2);
        try {
            this.protocol.destroySession(sessionUID, iMQConnection);
            SessionListener.getListener(sessionUID).destroy();
        }
        catch (BrokerException brokerException) {
            String string = "destroySession: destroy session failed. Connection ID: " + l + ", Session ID: " + l2;
            this.logger.logStack(32, string, (Throwable)brokerException);
            hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(string, brokerException, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply startSession(long l, long l2) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection iMQConnection = this.checkConnectionId(l, "startSession");
        SessionUID sessionUID = new SessionUID(l2);
        try {
            SessionListener.getListener(sessionUID).startSession();
        }
        catch (Exception exception) {
            String string = "startSession: Start of session failed. Session ID: " + l2;
            this.logger.logStack(32, string, (Throwable)exception);
            hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(string, exception, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply stopSession(long l, long l2) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection iMQConnection = this.checkConnectionId(l, "stopSession");
        SessionUID sessionUID = new SessionUID(l2);
        try {
            SessionListener.getListener(sessionUID).stopSession();
        }
        catch (Exception exception) {
            String string = "stopSession: Stop of session failed. Session ID: " + l2;
            this.logger.logStack(32, string, (Throwable)exception);
            hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(string, exception, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply verifyDestination(long l, Destination destination) throws JMSServiceException {
        Integer n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap hashMap2 = null;
        IMQConnection iMQConnection = this.checkConnectionId(l, "verifyDestination");
        try {
            hashMap2 = this.protocol.verifyDestination(destination.getName(), destination.getType() == Destination.Type.QUEUE ? 1 : 2, null);
        }
        catch (Exception exception) {
            String string = "verifyDestination: verify of destination failed. Destination name: " + destination.getName() + ", type: " + (Object)((Object)destination.getType());
            this.logger.logStack(32, string, (Throwable)exception);
            hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(string, exception, hashMap);
        }
        if (hashMap2 != null && (n = (Integer)hashMap2.get("JMQStatus")) != null) {
            if (n == 200) {
                hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
            } else if (n == 404) {
                Boolean bl = (Boolean)hashMap2.get("JMQCanCreate");
                hashMap.put("JMQStatus", JMSServiceReply.Status.NOT_FOUND);
                if (bl != null) {
                    hashMap.put("JMQCanCreate", bl);
                }
            }
        }
        hashMap.put("JMQDestination", destination.getName());
        hashMap.put("JMQDestType", (Object)destination.getType());
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply createDestination(long l, Destination destination) throws JMSServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        IMQConnection iMQConnection = this.checkConnectionId(l, "createDestination");
        int n = destination.getType() == Destination.Type.QUEUE ? 1 : 2;
        if (destination.getLife() == Destination.Life.TEMPORARY) {
            n |= 0x10;
        }
        if (iMQConnection.isAdminConnection()) {
            n |= 0x20A0;
        }
        String string = "createDestination: Destination creation failed. Destination name: " + destination.getName() + ", type: " + (Object)((Object)destination.getType()) + ", lifespan: " + (Object)((Object)destination.getLife());
        try {
            com.sun.messaging.jmq.jmsserver.core.Destination destination2 = null;
            destination2 = this.protocol.createDestination(destination.getName(), n, iMQConnection, this.acEnabled);
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(32, string, (Throwable)brokerException);
            int n2 = brokerException.getStatusCode();
            if (n2 == 409) {
                hashMap.put("JMQStatus", JMSServiceReply.Status.CONFLICT);
            } else if (n2 == 403) {
                hashMap.put("JMQStatus", JMSServiceReply.Status.FORBIDDEN);
            } else {
                hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            }
            throw new JMSServiceException(string, brokerException, hashMap);
        }
        catch (IOException iOException) {
            this.logger.logStack(32, string, (Throwable)iOException);
            hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(string, iOException, hashMap);
        }
        catch (AccessControlException accessControlException) {
            this.logger.logStack(32, string, (Throwable)accessControlException);
            hashMap.put("JMQStatus", JMSServiceReply.Status.FORBIDDEN);
            throw new JMSServiceException(string, accessControlException, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        hashMap.put("JMQDestination", destination.getName());
        hashMap.put("JMQDestType", (Object)destination.getType());
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply destroyDestination(long l, Destination destination) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection iMQConnection = this.checkConnectionId(l, "destroyDestination");
        try {
            Object var7_5 = null;
            DestinationUID destinationUID = DestinationUID.getUID(destination.getName(), destination.getType() == Destination.Type.QUEUE);
            assert (com.sun.messaging.jmq.jmsserver.core.Destination.getDestination(destinationUID) != null);
            com.sun.messaging.jmq.jmsserver.core.Destination.removeDestination(destinationUID, true, Globals.getBrokerResources().getString("B0067", (Object)iMQConnection.getConnectionUID()));
        }
        catch (Exception exception) {
            String string = "destroyDestination: Destination destroy failed. Destination name: " + destination.getName() + ", type: " + (Object)((Object)destination.getType()) + ", lifespan: " + (Object)((Object)destination.getLife());
            this.logger.logStack(32, string, (Throwable)exception);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(exception));
            throw new JMSServiceException(string, exception, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply addProducer(long l, long l2, Destination destination) throws JMSServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Producer producer = null;
        long l3 = 0L;
        IMQConnection iMQConnection = this.checkConnectionId(l, "addProducer");
        Session session = this.checkSessionId(l2, "addProducer");
        try {
            com.sun.messaging.jmq.jmsserver.core.Destination destination2 = com.sun.messaging.jmq.jmsserver.core.Destination.getDestination(destination.getName(), destination.getType() == Destination.Type.QUEUE);
            producer = this.protocol.addProducer(destination2, iMQConnection, new Object().toString(), this.acEnabled);
            l3 = producer.getProducerUID().longValue();
        }
        catch (Exception exception) {
            String string = "addProducer: Add producer failed. Connection ID: " + l + ", session ID: " + l2;
            this.logger.logStack(32, string, (Throwable)exception);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(exception));
            throw new JMSServiceException(string, exception, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        hashMap.put("JMQProducerID", l3);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply deleteProducer(long l, long l2, long l3) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection iMQConnection = this.checkConnectionId(l, "deleteProducer");
        try {
            this.protocol.removeProducer(new ProducerUID(l3), iMQConnection, new Object().toString());
        }
        catch (Exception exception) {
            String string = "deleteProducer: Delete producer failed. Connection ID: " + l + ", session ID: " + l2 + ", producer ID: " + l3;
            this.logger.logStack(32, string, (Throwable)exception);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(exception));
            throw new JMSServiceException(string, exception, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply addConsumer(long l, long l2, Destination destination, String string, String string2, String string3, boolean bl, boolean bl2) throws JMSServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = 1000;
        long l3 = 0L;
        IMQConnection iMQConnection = this.checkConnectionId(l, "addConsumer");
        Session session = this.checkSessionId(l2, "addConsumer");
        try {
            com.sun.messaging.jmq.jmsserver.core.Destination destination2 = com.sun.messaging.jmq.jmsserver.core.Destination.getDestination(destination.getName(), destination.getType() == Destination.Type.QUEUE);
            boolean bl3 = false;
            Consumer consumer = this.protocol.createConsumer(destination2, iMQConnection, session, string, string3, string2, bl, n, bl2, new Object().toString(), this.acEnabled, bl3);
            l3 = consumer.getConsumerUID().longValue();
        }
        catch (Exception exception) {
            String string4 = "addConsumer: Add consumer failed. Connection ID: " + l + ", session ID: " + l2;
            this.logger.logStack(32, string4, (Throwable)exception);
            if (exception instanceof SelectorFormatException) {
                hashMap.put("JMQStatus", JMSServiceReply.Status.BAD_REQUEST);
            } else {
                hashMap.put("JMQStatus", this.getErrorReplyStatus(exception));
            }
            throw new JMSServiceException(string4, exception, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        hashMap.put("JMQConsumerID", l3);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply deleteConsumer(long l, long l2, long l3, String string, String string2) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection iMQConnection = this.checkConnectionId(l, "deleteConsumer");
        Session session = this.checkSessionId(l2, "deleteConsumer");
        try {
            if (string == null) {
                ConsumerUID consumerUID = new ConsumerUID(l3);
                this.protocol.destroyConsumer(consumerUID, session, iMQConnection);
            } else {
                this.protocol.unsubscribe(string, string2);
            }
        }
        catch (Exception exception) {
            String string3 = "deleteConsumer: Delete consumer failed. Connection ID: " + l + ", session ID: " + l2 + ", consumer ID: " + l3 + ", durable name: " + string + ", client ID: " + string2;
            this.logger.logStack(32, string3, (Throwable)exception);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(exception));
            throw new JMSServiceException(string3, exception, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply setConsumerAsync(long l, long l2, long l3, com.sun.messaging.jmq.jmsservice.Consumer consumer) throws JMSServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = -1;
        IMQConnection iMQConnection = this.checkConnectionId(l, "setConsumerAsync");
        Session session = this.checkSessionId(l2, "setConsumerAsync");
        try {
            ConsumerUID consumerUID = new ConsumerUID(l3);
            Consumer consumer2 = Consumer.getConsumer(consumerUID);
            SessionListener sessionListener = SessionListener.getListener(session.getSessionUID());
            sessionListener.setAsyncListener(consumer2, consumer);
        }
        catch (Exception exception) {
            String string = "setConsumerAsync: Set Async consumer failed. Connection ID: " + l + ", session ID: " + l2 + ", consumer ID: " + l3;
            this.logger.logStack(32, string, (Throwable)exception);
            hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(string, exception, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        hashMap.put("JMQConsumerID", l3);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply startTransaction(long l, long l2, Xid xid, int n, JMSService.TransactionAutoRollback transactionAutoRollback, long l3) throws JMSServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        TransactionUID transactionUID = null;
        JMQXid jMQXid = null;
        Integer n2 = null;
        boolean bl = false;
        AutoRollbackType autoRollbackType = null;
        IMQConnection iMQConnection = this.checkConnectionId(l, "startTransaction");
        if (xid != null) {
            bl = true;
            jMQXid = new JMQXid(xid);
            n2 = new Integer(n);
        }
        try {
            transactionUID = this.protocol.startTransaction(jMQXid, n2, autoRollbackType, l3, iMQConnection);
        }
        catch (BrokerException brokerException) {
            String string = "startTransaction: start transaction failed. Connection ID: " + l + ", session ID: " + l2 + ", XID: " + xid;
            this.logger.logStack(32, string, (Throwable)brokerException);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(brokerException));
            throw new JMSServiceException(string, brokerException, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        hashMap.put("JMQTransactionID", transactionUID.longValue());
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply endTransaction(long l, long l2, Xid xid, int n) throws JMSServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        TransactionUID transactionUID = null;
        JMQXid jMQXid = null;
        Integer n2 = null;
        long l3 = 0L;
        IMQConnection iMQConnection = this.checkConnectionId(l, "endTransaction");
        transactionUID = new TransactionUID(l2);
        if (xid != null) {
            jMQXid = new JMQXid(xid);
            n2 = new Integer(n);
        }
        try {
            this.protocol.endTransaction(transactionUID, jMQXid, n2);
        }
        catch (BrokerException brokerException) {
            String string = "endTransaction: end transaction failed. Connection ID: " + l + ", Transaction ID: " + l2 + ", XID: " + xid;
            this.logger.logStack(32, string, (Throwable)brokerException);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(brokerException));
            throw new JMSServiceException(string, brokerException, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        hashMap.put("JMQTransactionID", transactionUID.longValue());
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply prepareTransaction(long l, long l2, Xid xid) throws JMSServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        TransactionUID transactionUID = null;
        JMQXid jMQXid = null;
        Integer n = null;
        IMQConnection iMQConnection = this.checkConnectionId(l, "prepareTransaction");
        if (l2 == 0L) {
            jMQXid = new JMQXid(xid);
            transactionUID = Globals.getTransactionList().xidToUID(jMQXid);
        } else {
            transactionUID = new TransactionUID(l2);
        }
        try {
            this.protocol.prepareTransaction(transactionUID, n, iMQConnection);
        }
        catch (BrokerException brokerException) {
            String string = "prepareTransaction: prepare transaction failed. Connection ID: " + l + ", Transaction ID: " + l2 + ", XID: " + xid;
            this.logger.logStack(32, string, (Throwable)brokerException);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(brokerException));
            throw new JMSServiceException(string, brokerException, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        hashMap.put("JMQTransactionID", transactionUID.longValue());
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply commitTransaction(long l, long l2, Xid xid, int n) throws JMSServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        TransactionUID transactionUID = null;
        JMQXid jMQXid = null;
        long l3 = 0L;
        IMQConnection iMQConnection = this.checkConnectionId(l, "commitTransaction");
        transactionUID = new TransactionUID(l2);
        if (xid != null) {
            jMQXid = new JMQXid(xid);
        }
        Integer n2 = new Integer(n);
        try {
            this.protocol.commitTransaction(transactionUID, jMQXid, n2, iMQConnection);
        }
        catch (BrokerException brokerException) {
            String string = "CommitTransaction: commit failed. Connection ID: " + l + ", Transaction ID: " + l2;
            this.logger.logStack(32, string, (Throwable)brokerException);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(brokerException));
            throw new JMSServiceException(string, brokerException, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        hashMap.put("JMQTransactionID", transactionUID.longValue());
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply rollbackTransaction(long l, long l2, Xid xid, boolean bl, boolean bl2) throws JMSServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        TransactionUID transactionUID = null;
        JMQXid jMQXid = null;
        Integer n = null;
        IMQConnection iMQConnection = this.checkConnectionId(l, "rollbackTransaction");
        transactionUID = new TransactionUID(l2);
        if (xid != null) {
            jMQXid = new JMQXid(xid);
        }
        try {
            this.protocol.rollbackTransaction(transactionUID, jMQXid, n, iMQConnection, bl, bl2);
        }
        catch (BrokerException brokerException) {
            String string = "rollbackTransaction: rollback transaction failed. Connection ID: " + l + ", Transaction ID: " + l2 + ", XID: " + xid;
            this.logger.logStack(32, string, (Throwable)brokerException);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(brokerException));
            throw new JMSServiceException(string, brokerException, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        hashMap.put("JMQTransactionID", transactionUID.longValue());
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public Xid[] recoverXATransactions(long l, int n) throws JMSServiceException {
        JMQXid[] jMQXidArray = null;
        IMQConnection iMQConnection = this.checkConnectionId(l, "recoverXATransactions");
        try {
            jMQXidArray = this.protocol.recoverTransaction(null);
        }
        catch (Exception exception) {
            HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
            String string = "recoverXATransactions: recover XA transactions failed. Connection ID: " + l;
            this.logger.logStack(32, string, (Throwable)exception);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(exception));
            throw new JMSServiceException(string, exception, hashMap);
        }
        return jMQXidArray;
    }

    public long recoverTransaction(long l, long l2) throws JMSServiceException {
        TransactionUID transactionUID = null;
        long l3 = 0L;
        IMQConnection iMQConnection = this.checkConnectionId(l, "recoverTransaction");
        transactionUID = new TransactionUID(l2);
        try {
            JMQXid[] jMQXidArray = this.protocol.recoverTransaction(transactionUID);
            if (jMQXidArray.length > 0) {
                return l2;
            }
        }
        catch (Exception exception) {
            String string = "recoverTransaction: recover transaction failed. Connection ID:" + l + ", Transaction ID: " + l2;
            this.logger.logStack(32, string, (Throwable)exception);
            HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
            hashMap.put("JMQStatus", this.getErrorReplyStatus(exception));
            throw new JMSServiceException(string, exception, hashMap);
        }
        return 0L;
    }

    public JMSServiceReply sendMessage(long l, JMSPacket jMSPacket) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection iMQConnection = this.checkConnectionId(l, "sendMessage");
        try {
            Packet packet = new Packet();
            packet.fill(jMSPacket.getPacket());
            this.protocol.processMessage(iMQConnection, packet);
        }
        catch (Exception exception) {
            String string = "sendMessage: Sending message failed. Connection ID: " + l;
            this.logger.logStack(32, string, (Throwable)exception);
            hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(string, exception, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSPacket fetchMessage(long l, long l2, long l3, long l4, boolean bl, long l5) throws JMSServiceException {
        Packet packet = null;
        IMQConnection iMQConnection = this.checkConnectionId(l, "fetchMessage");
        Session session = this.checkSessionId(l2, "fetchMessage");
        SessionListener sessionListener = SessionListener.getListener(session.getSessionUID());
        try {
            ConsumerUID consumerUID = new ConsumerUID(l3);
            packet = sessionListener.getNextConsumerPacket(consumerUID, l4);
            if (packet != null && bl) {
                TransactionUID transactionUID = null;
                if (l5 != 0L) {
                    transactionUID = new TransactionUID(l5);
                }
                SysMessageID[] sysMessageIDArray = new SysMessageID[]{packet.getSysMessageID()};
                ConsumerUID[] consumerUIDArray = new ConsumerUID[]{consumerUID};
                Globals.getProtocol().acknowledge(iMQConnection, transactionUID, false, 0, null, null, 0, sysMessageIDArray, consumerUIDArray);
            }
        }
        catch (Exception exception) {
            HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
            String string = "fetchMessage: Fetch Message failed. Connection ID: " + l + ", session ID: " + l2 + ", consumer ID: " + l3;
            this.logger.logStack(32, string, (Throwable)exception);
            hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(string, exception, hashMap);
        }
        return packet;
    }

    public JMSServiceReply acknowledgeMessage(long l, long l2, long l3, SysMessageID sysMessageID, long l4, JMSService.MessageAckType messageAckType) throws JMSServiceException {
        boolean bl = false;
        TransactionUID transactionUID = null;
        int n = -1;
        SysMessageID[] sysMessageIDArray = null;
        ConsumerUID[] consumerUIDArray = null;
        Throwable throwable = null;
        String string = null;
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection iMQConnection = this.checkConnectionId(l, "acknowledgeMessage");
        if (l4 != 0L) {
            transactionUID = new TransactionUID(l4);
        }
        int n2 = this.convertToBrokerAckType(messageAckType);
        sysMessageIDArray = new SysMessageID[]{sysMessageID};
        consumerUIDArray = new ConsumerUID[]{new ConsumerUID(l3)};
        try {
            this.protocol.acknowledge(iMQConnection, transactionUID, bl, n2, throwable, string, n, sysMessageIDArray, consumerUIDArray);
        }
        catch (Exception exception) {
            String string2 = "acknowledgeMessage: Sending Acknowledgement failed. Connection ID: " + l;
            this.logger.logStack(32, string2, (Throwable)exception);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(exception));
            throw new JMSServiceException(string2, exception, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply sendAcknowledgement(long l, JMSService.MessageAckType messageAckType, JMSPacket jMSPacket) throws JMSServiceException {
        boolean bl = false;
        long l2 = -1L;
        TransactionUID transactionUID = null;
        int n = -1;
        SysMessageID[] sysMessageIDArray = null;
        ConsumerUID[] consumerUIDArray = null;
        Throwable throwable = null;
        String string = null;
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        IMQConnection iMQConnection = this.checkConnectionId(l, "sendAcknowledgement");
        if (l2 != -1L) {
            transactionUID = new TransactionUID(l2);
        }
        int n2 = this.convertToBrokerAckType(messageAckType);
        try {
            this.protocol.acknowledge(iMQConnection, transactionUID, bl, n2, throwable, string, n, sysMessageIDArray, consumerUIDArray);
        }
        catch (Exception exception) {
            String string2 = "sendAcknowledgement: Sending Acknowledgement failed. Connection ID: " + l;
            this.logger.logStack(32, string2, (Throwable)exception);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(exception));
            throw new JMSServiceException(string2, exception, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply addBrowser(long l, long l2, Destination destination, String string) throws JMSServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        IMQConnection iMQConnection = this.checkConnectionId(l, "addBrowser");
        Session session = this.checkSessionId(l2, "addBrowser");
        try {
            Selector selector = Selector.compile((String)string);
        }
        catch (SelectorFormatException selectorFormatException) {
            String string2 = "addBrowser: Add browser failed. Connection ID: " + l + ", session ID: " + l2 + ", destination: " + destination + ", selector: " + string;
            this.logger.logStack(32, string2, (Throwable)selectorFormatException);
            hashMap.put("JMQStatus", JMSServiceReply.Status.BAD_REQUEST);
            throw new JMSServiceException(string2, selectorFormatException, hashMap);
        }
        ConsumerUID consumerUID = new ConsumerUID();
        this.queueBrowseList.put(consumerUID, new QueueBrowserInfo(destination, string));
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        hashMap.put("JMQConsumerID", consumerUID.longValue());
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    public JMSServiceReply deleteBrowser(long l, long l2, long l3) throws JMSServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        IMQConnection iMQConnection = this.checkConnectionId(l, "deleteBrowser");
        Session session = this.checkSessionId(l2, "deleteBrowser");
        ConsumerUID consumerUID = new ConsumerUID(l3);
        if (!this.queueBrowseList.containsKey(consumerUID)) {
            String string = "deleteBrowser: consumer ID not found. Connection ID:" + l + ", Session ID: " + l2 + ", Consumer ID: " + l3;
            this.logger.log(32, string);
            hashMap.put("JMQStatus", JMSServiceReply.Status.NOT_FOUND);
            throw new JMSServiceException(string, hashMap);
        }
        this.queueBrowseList.remove(consumerUID);
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        hashMap.put("JMQConsumerID", consumerUID.longValue());
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JMSPacket[] browseMessages(long l, long l2, long l3) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        JMSPacket[] jMSPacketArray = null;
        IMQConnection iMQConnection = this.checkConnectionId(l, "browseMessages");
        Session session = this.checkSessionId(l2, "browseMessages");
        ConsumerUID consumerUID = new ConsumerUID(l3);
        if (this.queueBrowseList.containsKey(consumerUID)) {
            QueueBrowserInfo queueBrowserInfo = (QueueBrowserInfo)this.queueBrowseList.get(consumerUID);
            try {
                Destination destination = queueBrowserInfo.dest;
                String string = queueBrowserInfo.selector;
                com.sun.messaging.jmq.jmsserver.core.Destination destination2 = com.sun.messaging.jmq.jmsserver.core.Destination.getDestination(destination.getName(), destination.getType() == Destination.Type.QUEUE);
                if (destination2 == null) {
                    String string2 = "browseMessages: destination not found. Connection ID:" + l + ", Session ID: " + l2 + ", Consumer ID: " + l3 + "destination: " + destination.toString();
                    this.logger.log(32, string2);
                    hashMap.put("JMQStatus", JMSServiceReply.Status.NOT_FOUND);
                    throw new JMSServiceException(string2, hashMap);
                }
                ArrayList arrayList = this.protocol.browseQueue(destination2, string, iMQConnection, this.acEnabled);
                if (arrayList == null) return jMSPacketArray;
                int n = arrayList.size();
                if (n == 0) {
                    return null;
                }
                jMSPacketArray = new JMSPacket[n];
                for (int i = 0; i < n; ++i) {
                    PacketReference packetReference = com.sun.messaging.jmq.jmsserver.core.Destination.get((SysMessageID)arrayList.get(i));
                    jMSPacketArray[i] = packetReference.getPacket();
                }
                return jMSPacketArray;
            }
            catch (Exception exception) {
                String string = "browseMessages: Browse queue failed. Connection ID: " + l + ", session ID: " + l2 + ", consumer ID: " + l3;
                this.logger.logStack(32, string, (Throwable)exception);
                if (exception instanceof SelectorFormatException) {
                    hashMap.put("JMQStatus", JMSServiceReply.Status.BAD_REQUEST);
                    throw new JMSServiceException(string, exception, hashMap);
                } else {
                    hashMap.put("JMQStatus", this.getErrorReplyStatus(exception));
                }
                throw new JMSServiceException(string, exception, hashMap);
            }
        } else {
            String string = "browseMessages: consumer ID not found. Connection ID:" + l + ", Session ID: " + l2 + ", Consumer ID: " + l3;
            this.logger.log(32, string);
            hashMap.put("JMQStatus", JMSServiceReply.Status.NOT_FOUND);
            throw new JMSServiceException(string, hashMap);
        }
    }

    public JMSServiceReply redeliverMessages(long l, long l2, SysMessageID[] sysMessageIDArray, Long[] longArray, long l3, boolean bl) throws JMSServiceException {
        HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
        ConsumerUID[] consumerUIDArray = null;
        TransactionUID transactionUID = null;
        IMQConnection iMQConnection = this.checkConnectionId(l, "redeliverMessages");
        Session session = this.checkSessionId(l2, "redeliverMessages");
        if (longArray != null) {
            consumerUIDArray = new ConsumerUID[longArray.length];
            for (int i = 0; i < longArray.length; ++i) {
                consumerUIDArray[i] = new ConsumerUID(longArray[i]);
            }
        }
        if (l3 != -1L) {
            transactionUID = new TransactionUID(l3);
        }
        try {
            this.protocol.redeliver(consumerUIDArray, sysMessageIDArray, iMQConnection, transactionUID, true);
        }
        catch (Exception exception) {
            String string = "redeliverMessages: Redeliver failed. Connection ID: " + l + ", session ID: " + l2 + ", transaction ID: " + l3;
            this.logger.logStack(32, string, (Throwable)exception);
            hashMap.put("JMQStatus", this.getErrorReplyStatus(exception));
            throw new JMSServiceException(string, exception, hashMap);
        }
        hashMap.put("JMQStatus", JMSServiceReply.Status.OK);
        JMSServiceReply jMSServiceReply = new JMSServiceReply(hashMap, null);
        return jMSServiceReply;
    }

    IMQConnection checkConnectionId(long l, String string) throws JMSServiceException {
        ConnectionManager connectionManager = Globals.getConnectionManager();
        IMQConnection iMQConnection = (IMQConnection)connectionManager.getConnection(new ConnectionUID(l));
        if (iMQConnection == null) {
            String string2 = string + ": connection ID not found: " + l;
            this.logger.log(32, string2);
            HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
            hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(string2, hashMap);
        }
        return iMQConnection;
    }

    private Session checkSessionId(long l, String string) throws JMSServiceException {
        Session session = Session.getSession(new SessionUID(l));
        if (session == null) {
            String string2 = string + ": session ID not found: " + l;
            this.logger.log(32, string2);
            HashMap<String, JMSServiceReply.Status> hashMap = new HashMap<String, JMSServiceReply.Status>();
            hashMap.put("JMQStatus", JMSServiceReply.Status.ERROR);
            throw new JMSServiceException(string2, hashMap);
        }
        return session;
    }

    private int convertToBrokerAckMode(JMSService.SessionAckMode sessionAckMode) {
        switch (sessionAckMode) {
            case AUTO_ACKNOWLEDGE: {
                return 1;
            }
            case CLIENT_ACKNOWLEDGE: {
                return 2;
            }
            case DUPS_OK_ACKNOWLEDGE: {
                return 3;
            }
            case NO_ACKNOWLEDGE: {
                return 32768;
            }
            case UNSPECIFIED: {
                return 0;
            }
        }
        return 0;
    }

    private int convertToBrokerAckType(JMSService.MessageAckType messageAckType) {
        switch (messageAckType) {
            case ACKNOWLEDGE: {
                return 0;
            }
            case UNDELIVERABLE: {
                return 1;
            }
            case DEAD: {
                return 2;
            }
        }
        return 0;
    }

    private JMSServiceReply.Status getErrorReplyStatus(Exception exception) {
        JMSServiceReply.Status status = JMSServiceReply.Status.ERROR;
        if (exception instanceof BrokerException) {
            BrokerException brokerException = (BrokerException)exception;
            int n = brokerException.getStatusCode();
            switch (n) {
                case 403: {
                    status = JMSServiceReply.Status.FORBIDDEN;
                    break;
                }
                case 409: {
                    status = JMSServiceReply.Status.CONFLICT;
                    break;
                }
                case 400: {
                    status = JMSServiceReply.Status.BAD_REQUEST;
                    break;
                }
                case 404: {
                    status = JMSServiceReply.Status.NOT_FOUND;
                    break;
                }
                case 405: {
                    status = JMSServiceReply.Status.NOT_ALLOWED;
                    break;
                }
                case 412: {
                    status = JMSServiceReply.Status.PRECONDITION_FAILED;
                    break;
                }
                case 304: {
                    status = JMSServiceReply.Status.NOT_MODIFIED;
                    break;
                }
                case 501: {
                    status = JMSServiceReply.Status.NOT_IMPLEMENTED;
                    break;
                }
                case 408: {
                    status = JMSServiceReply.Status.TIMEOUT;
                }
            }
        }
        return status;
    }

    private void startAllConnections() {
        for (IMQConnection iMQConnection : this.localConnectionList.values()) {
            SessionListener.startConnection(iMQConnection);
        }
    }

    private void stopAllConnections() {
        for (IMQConnection iMQConnection : this.localConnectionList.values()) {
            SessionListener.stopConnection(iMQConnection);
        }
    }
}

