/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.MQThread;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class ConsumerInfoNotifyManager
implements Runnable {
    private static final int CONSUMER_NOT_READY = 0;
    private static final int CONSUMER_READY = 1;
    private static final int CONSUMER_ALL_EVENT = -1;
    private static boolean DEBUG = false;
    private Logger logger = Globals.getLogger();
    private MQThread notifyThread = null;
    private Vector eventQueue = new Vector();
    private ConnectionManager cm = null;
    private boolean shutdown = false;
    private boolean requested = false;

    public ConsumerInfoNotifyManager(ConnectionManager connectionManager) {
        this.cm = connectionManager;
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
    }

    private synchronized void wakeup() {
        this.createNotifyThread();
        this.notifyAll();
    }

    private void createNotifyThread() {
        if (this.notifyThread == null) {
            this.notifyThread = new MQThread(this, "ConsumerInfoNotifyManager");
            this.notifyThread.setDaemon(true);
            this.notifyThread.start();
        }
    }

    protected synchronized void shutdown() {
        this.shutdown = true;
        this.eventQueue.clear();
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = new ArrayList<Object>();
        while (!this.shutdown) {
            var2_2 = true;
            var3_3 = null;
            var4_4 = this.eventQueue;
            synchronized (var4_4) {
                var3_3 = new ArrayList<E>(this.eventQueue);
            }
            if (var3_3.size() > 0 && var1_1.size() > 0) {
                var4_4 = var3_3.iterator();
                var5_5 = null;
                while (var4_4.hasNext()) {
                    var5_5 = (Object[])var4_4.next();
                    if (var1_1.contains(var5_5)) continue;
                    var2_2 = false;
                    break;
                }
            } else if (var1_1.size() == 0) {
                var2_2 = this.eventQueue.isEmpty();
            }
            var4_4 = this;
            synchronized (var4_4) {
                if (var2_2 || this.eventQueue.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var5_7) {
                        // empty catch block
                    }
                }
            }
            if (this.shutdown) {
                return;
            }
            var4_4 = new HashMap<DestinationUID, ConsumerInfoNotification>();
            var5_5 = this.eventQueue.toArray();
            var6_8 = null;
            for (var7_11 = 0; var7_11 < var5_5.length && !this.shutdown; ++var7_11) {
                block35: {
                    var6_8 = var5_5[var7_11];
                    if (ConsumerInfoNotifyManager.DEBUG) {
                        this.logger.log(8, "Processing " + var6_8);
                    }
                    if (!(var6_8 instanceof ConsumerAddedEvent)) break block35;
                    var8_13 = (ConsumerAddedEvent)var6_8;
                    var9_18 = (IMQConnection)this.cm.getConnection(var8_13.connid);
                    if (var8_13.dest.getAllActiveConsumerCount() <= 0) ** GOTO lbl57
                    if (var9_18 == null || var9_18.isConnectionStarted()) {
                        var4_4.put(var8_13.dest.getDestinationUID(), new ConsumerInfoNotification(var8_13.dest.getDestinationUID(), var8_13.dest.getType(), 1));
                    } else {
                        var1_1.add(var6_8);
                        continue;
lbl57:
                        // 1 sources

                        var4_4.put(var8_13.dest.getDestinationUID(), new ConsumerInfoNotification(var8_13.dest.getDestinationUID(), var8_13.dest.getType(), 0));
                    }
                    this.eventQueue.remove(var6_8);
                    var1_1.remove(var6_8);
                    continue;
                }
                if (var6_8 instanceof RemoteConsumerAddedEvent) {
                    var8_14 = (RemoteConsumerAddedEvent)var6_8;
                    if (var8_14.dest.getAllActiveConsumerCount() > 0) {
                        var4_4.put(var8_14.dest.getDestinationUID(), new ConsumerInfoNotification(var8_14.dest.getDestinationUID(), var8_14.dest.getType(), 1));
                    } else {
                        var4_4.put(var8_14.dest.getDestinationUID(), new ConsumerInfoNotification(var8_14.dest.getDestinationUID(), var8_14.dest.getType(), 0));
                    }
                    this.eventQueue.remove(var6_8);
                    continue;
                }
                if (var6_8 instanceof ConsumerRemovedEvent) {
                    var8_15 = (ConsumerRemovedEvent)var6_8;
                    if (var8_15.dest.getAllActiveConsumerCount() == 0) {
                        var4_4.put(var8_15.dest.getDestinationUID(), new ConsumerInfoNotification(var8_15.dest.getDestinationUID(), var8_15.dest.getType(), 0));
                    }
                    this.eventQueue.remove(var6_8);
                    continue;
                }
                if (var6_8 instanceof ConnectionStartedEvent) {
                    var8_16 = (ConnectionStartedEvent)var6_8;
                    for (var9_19 = 0; var9_19 < var5_5.length && !this.shutdown; ++var9_19) {
                        var10_21 = var5_5[var9_19];
                        if (!(var10_21 instanceof ConsumerAddedEvent)) continue;
                        var11_23 = (ConsumerAddedEvent)var10_21;
                        var12_24 = (IMQConnection)this.cm.getConnection(var11_23.connid);
                        if (var12_24 == null || var12_24 != var8_16.conn || var11_23.dest.getAllActiveConsumerCount() <= 0) continue;
                        var4_4.put(var11_23.dest.getDestinationUID(), new ConsumerInfoNotification(var11_23.dest.getDestinationUID(), var11_23.dest.getType(), 1));
                        var1_1.remove(var11_23);
                    }
                    this.eventQueue.remove(var8_16);
                    continue;
                }
                if (!(var6_8 instanceof ConsumerInfoRequestEvent)) continue;
                var8_17 = false;
                var9_20 = false;
                var10_22 = false;
                var11_23 = (ConsumerInfoRequestEvent)var6_8;
                var12_24 = Destination.getAllDestinations();
                block12: while (var12_24.hasNext()) {
                    var13_25 = (Destination)var12_24.next();
                    if (var13_25.isInternal()) continue;
                    if (!var11_23.duid.isWildcard() && var13_25.getDestinationUID().equals(var11_23.duid)) {
                        var8_17 = true;
                        if (var13_25.getAllActiveConsumerCount() == 0) {
                            var4_4.put(var13_25.getDestinationUID(), new ConsumerInfoNotification(var13_25.getDestinationUID(), var13_25.getType(), 0, ((ConsumerInfoRequestEvent)var6_8).infoType, true));
                            var10_22 = true;
                            break;
                        }
                        var9_20 = true;
                        for (Consumer var15_27 : var13_25.getAllActiveConsumers()) {
                            var16_28 = (IMQConnection)this.cm.getConnection(var15_27.getConnectionUID());
                            var17_29 = var15_27.getConsumerUID().getBrokerAddress();
                            if ((var16_28 == null || !var16_28.isConnectionStarted()) && (var17_29 == null || var17_29 == Globals.getMyAddress())) continue;
                            var4_4.put(var13_25.getDestinationUID(), new ConsumerInfoNotification(var13_25.getDestinationUID(), var13_25.getType(), 1, ((ConsumerInfoRequestEvent)var6_8).infoType, true));
                            var10_22 = true;
                            break block12;
                        }
                        break;
                    }
                    if (!var11_23.duid.isWildcard() || !DestinationUID.match(var13_25.getDestinationUID(), var11_23.duid)) continue;
                    var8_17 = true;
                    if (var13_25.getAllActiveConsumerCount() == 0) continue;
                    var9_20 = true;
                    for (Consumer var15_27 : var13_25.getAllActiveConsumers()) {
                        var16_28 = (IMQConnection)this.cm.getConnection(var15_27.getConnectionUID());
                        var17_29 = var15_27.getConsumerUID().getBrokerAddress();
                        if ((var16_28 == null || !var16_28.isConnectionStarted()) && (var17_29 == null || var17_29 == Globals.getMyAddress())) continue;
                        var4_4.put(var13_25.getDestinationUID(), new ConsumerInfoNotification(var13_25.getDestinationUID(), var11_23.destType, 1, ((ConsumerInfoRequestEvent)var6_8).infoType, true));
                        var10_22 = true;
                        break;
                    }
                    if (!var10_22) continue;
                    break;
                }
                if (!var8_17 || var8_17 && !var9_20 && !var10_22) {
                    var4_4.put(var11_23.duid, new ConsumerInfoNotification(var11_23.duid, var11_23.destType, 0, ((ConsumerInfoRequestEvent)var6_8).infoType, true));
                }
                this.eventQueue.remove(var6_8);
            }
            var7_10 = var4_4.values().iterator();
            var8_12 = null;
            while (var7_10.hasNext()) {
                var8_12 = (ConsumerInfoNotification)var7_10.next();
                if (ConsumerInfoNotifyManager.DEBUG) {
                    this.logger.log(8, "Sending " + var8_12);
                }
                if (!var8_12.shouldNotify()) continue;
                this.cm.sendConsumerInfo(3, var8_12.duid, var8_12.destType, var8_12.infoType, var8_12.sendToWildcard);
            }
            var4_4.clear();
        }
    }

    public void remoteConsumerAdded(Destination destination) {
        if (!this.requested) {
            return;
        }
        this.eventQueue.add(new RemoteConsumerAddedEvent(destination));
        this.wakeup();
    }

    public void consumerAdded(Destination destination, Connection connection) {
        if (!this.requested) {
            return;
        }
        this.eventQueue.add(new ConsumerAddedEvent(destination, connection == null ? null : connection.getConnectionUID()));
        this.wakeup();
    }

    public void consumerRemoved(Destination destination) {
        if (!this.requested) {
            return;
        }
        this.eventQueue.add(new ConsumerRemovedEvent(destination));
        this.wakeup();
    }

    public void connectionStarted(Connection connection) {
        if (!this.requested) {
            return;
        }
        this.eventQueue.add(new ConnectionStartedEvent(connection));
        this.wakeup();
    }

    public void consumerInfoRequested(Connection connection, DestinationUID destinationUID, int n) {
        this.consumerInfoRequested(connection, destinationUID, n, -1);
    }

    public void consumerInfoRequested(Connection connection, DestinationUID destinationUID, int n, int n2) {
        this.requested = true;
        this.eventQueue.add(new ConsumerInfoRequestEvent(connection, destinationUID, n, n2));
        this.wakeup();
    }

    protected static String toString(int n) {
        switch (n) {
            case 0: {
                return "CONSUMER_NOT_READY";
            }
            case 1: {
                return "CONSUMER_READY";
            }
            case -1: {
                return "CONSUMER_ALL_EVENT";
            }
        }
        return "UNKNOWN";
    }

    class ConnectionStartedEvent {
        Connection conn = null;

        public ConnectionStartedEvent(Connection connection) {
            this.conn = connection;
        }

        public String toString() {
            return "ConnectionStartedEvent: conn=" + this.conn;
        }
    }

    class ConsumerAddedEvent {
        Destination dest = null;
        ConnectionUID connid = null;

        public ConsumerAddedEvent(Destination destination, ConnectionUID connectionUID) {
            this.dest = destination;
            this.connid = connectionUID;
        }

        public String toString() {
            return "ConsumerAddedEvent: dest=" + this.dest + ", conn=" + (Object)((Object)this.connid);
        }
    }

    class ConsumerInfoNotification {
        DestinationUID duid = null;
        int destType;
        int infoType;
        int requestInfoType = -1;
        boolean sendToWildcard = false;

        public ConsumerInfoNotification(DestinationUID destinationUID, int n, int n2) {
            this.duid = destinationUID;
            this.destType = n;
            this.infoType = n2;
            if (n2 != 0) {
                this.sendToWildcard = true;
            }
        }

        public ConsumerInfoNotification(DestinationUID destinationUID, int n, int n2, int n3, boolean bl) {
            this.duid = destinationUID;
            this.destType = n;
            this.infoType = n2;
            this.requestInfoType = n3;
            this.sendToWildcard = bl;
        }

        public boolean shouldNotify() {
            if (this.requestInfoType == -1) {
                return true;
            }
            return this.requestInfoType == this.infoType;
        }

        public String toString() {
            return "ConsumerInfoNotification: duid=" + this.duid + ", destType=" + DestType.toString((int)this.destType) + ", infoType=" + ConsumerInfoNotifyManager.toString(this.infoType);
        }
    }

    class ConsumerInfoRequestEvent {
        Connection conn = null;
        DestinationUID duid = null;
        int destType;
        int infoType;

        public ConsumerInfoRequestEvent(Connection connection, DestinationUID destinationUID, int n, int n2) {
            this.conn = connection;
            this.duid = destinationUID;
            this.destType = n;
            this.infoType = n2;
        }

        public String toString() {
            return "ConsumerInfoRequestEvent: conn=" + this.conn + ", duid=" + this.duid + ", destType=" + DestType.toString((int)this.destType) + ", infoType=" + ConsumerInfoNotifyManager.toString(this.infoType);
        }
    }

    class ConsumerRemovedEvent {
        Destination dest = null;

        public ConsumerRemovedEvent(Destination destination) {
            this.dest = destination;
        }

        public String toString() {
            return "ConsumerRemovedEvent: dest=" + this.dest;
        }
    }

    class RemoteConsumerAddedEvent {
        Destination dest = null;

        public RemoteConsumerAddedEvent(Destination destination) {
            this.dest = destination;
        }

        public String toString() {
            return "RemoteConsumerAddedEvent: dest=" + this.dest;
        }
    }
}

