/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ConsumerDAOImpl
extends BaseDAOImpl
implements ConsumerDAO {
    protected String tableName;
    protected String insertSQL;
    protected String insertNoDupSQLDual;
    protected String insertNoDupSQL;
    protected String deleteSQL;
    protected String selectSQL;
    protected String selectAllSQL;
    protected String selectExistSQL;
    protected String selectExistByIDSQL;

    ConsumerDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQCON41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("CONSUMER").append(", ").append("DURABLE_NAME").append(", ").append("CLIENT_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        this.insertNoDupSQLDual = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("CONSUMER").append(", ").append("DURABLE_NAME").append(", ").append("CLIENT_ID").append(", ").append("CREATED_TS").append(" ) SELECT ?, ?, ?, ?, ? FROM DUAL ").append(" WHERE NOT EXISTS ").append("(SELECT 1 FROM ").append(this.tableName).append(" WHERE ").append("DURABLE_NAME").append(" = ? ").append(" AND ").append("CLIENT_ID").append(" = ? )").toString();
        this.insertNoDupSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("CONSUMER").append(", ").append("DURABLE_NAME").append(", ").append("CLIENT_ID").append(", ").append("CREATED_TS").append(" ) SELECT ?, ?, ?, ?, ? FROM ").append(this.tableName).append(" WHERE ").append("DURABLE_NAME").append(" = ? ").append(" AND ").append("CLIENT_ID").append(" = ? ").append(" HAVING COUNT(*) ").append(" = 0 ").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER").append(" FROM ").append(this.tableName).toString();
        this.selectExistSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("DURABLE_NAME").append(" = ?").append(" AND ").append("CLIENT_ID").append(" = ?").toString();
        this.selectExistByIDSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
    }

    public final String getTableNamePrefix() {
        return "MQCON41";
    }

    public String getTableName() {
        return this.tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(Connection connection, Consumer consumer, long l) throws BrokerException {
        Exception exception;
        PreparedStatement preparedStatement;
        block20: {
            ConsumerUID consumerUID = consumer.getConsumerUID();
            String string2 = null;
            String string3 = null;
            if (consumer instanceof Subscription) {
                Subscription subscription = (Subscription)consumer;
                string2 = subscription.getDurableName();
                string3 = subscription.getClientID();
            }
            boolean bl = false;
            String string = this.insertSQL;
            preparedStatement = null;
            exception = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    if (this.checkConsumer(connection, consumer, true)) {
                        throw new BrokerException(this.br.getKString("B3010", "[" + consumer.toString() + "]", consumer.getDestinationUID()), 409);
                    }
                    if (string2 != null && this.checkConsumer(connection, consumer, false)) {
                        throw new BrokerException(this.br.getKString("B4392", "[" + string2 + ", " + string3 + "]"));
                    }
                    if (string2 != null && !dBManager.isHADB() && !dBManager.isDB2()) {
                        string = this.insertNoDupSQL;
                    }
                    preparedStatement = connection.prepareStatement(string);
                    preparedStatement.setLong(1, consumerUID.longValue());
                    Util.setObject(preparedStatement, 2, consumer);
                    Util.setString(preparedStatement, 3, string2);
                    Util.setString(preparedStatement, 4, string3);
                    preparedStatement.setLong(5, l);
                    if (string2 != null && !dBManager.isHADB() && !dBManager.isDB2()) {
                        preparedStatement.setString(6, string2);
                        preparedStatement.setString(7, string3);
                    }
                    if (preparedStatement.executeUpdate() == 0) {
                        if (this.checkConsumer(connection, consumer, true)) {
                            throw new BrokerException(this.br.getKString("B3010", consumer.toString(), "" + consumer.getDestinationUID()), 409);
                        }
                        if (string2 == null) throw new BrokerException(this.br.getKString("B4012", consumerUID));
                        if (!this.checkConsumer(connection, consumer, false)) throw new BrokerException(this.br.getKString("B4012", consumerUID));
                        throw new BrokerException(this.br.getKString("B4012", consumer.toString()) + ": " + this.br.getKString("B4392", "[" + string2 + ", " + string3 + "]"));
                    }
                    Object var15_14 = null;
                    if (!bl) break block20;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", (Throwable)sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof IOException) {
                        exception3 = DBManager.wrapIOException("[" + string + "]", (IOException)exception2);
                        throw new BrokerException(this.br.getKString("B4012", consumerUID), exception3);
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + string + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4012", consumerUID), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4012", consumerUID), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection, exception);
            return;
        }
        Util.close(null, preparedStatement, null, exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Connection connection, Consumer consumer) throws BrokerException {
        boolean bl;
        ConsumerUID consumerUID;
        block13: {
            Exception exception;
            PreparedStatement preparedStatement;
            block12: {
                consumerUID = consumer.getConsumerUID();
                bl = false;
                boolean bl2 = false;
                preparedStatement = null;
                exception = null;
                try {
                    try {
                        if (connection == null) {
                            connection = DBManager.getDBManager().getConnection(true);
                            bl2 = true;
                        }
                        preparedStatement = connection.prepareStatement(this.deleteSQL);
                        preparedStatement.setLong(1, consumerUID.longValue());
                        if (preparedStatement.executeUpdate() > 0) {
                            bl = true;
                        }
                    }
                    catch (Exception exception2) {
                        Exception exception3;
                        exception = exception2;
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", (Throwable)sQLException);
                        }
                        if (exception2 instanceof BrokerException) {
                            throw (BrokerException)exception2;
                        }
                        if (exception2 instanceof SQLException) {
                            exception3 = DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)exception2);
                            throw new BrokerException(this.br.getKString("B4034", consumerUID), exception3);
                        }
                        exception3 = exception2;
                        throw new BrokerException(this.br.getKString("B4034", consumerUID), exception3);
                    }
                    Object var11_8 = null;
                    if (!bl2) break block12;
                }
                catch (Throwable throwable) {
                    Object var11_9 = null;
                    if (bl2) {
                        Util.close(null, preparedStatement, connection, exception);
                        throw throwable;
                    }
                    Util.close(null, preparedStatement, null, exception);
                    throw throwable;
                }
                Util.close(null, preparedStatement, connection, exception);
                break block13;
            }
            Util.close(null, preparedStatement, null, exception);
        }
        if (bl) return;
        DestinationUID destinationUID = consumer.getDestinationUID();
        throw new BrokerException(this.br.getKString("B3011", consumerUID, destinationUID), 404);
    }

    public void deleteAll(Connection connection) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(connection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Consumer getConsumer(Connection connection, ConsumerUID consumerUID) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Consumer consumer;
        block15: {
            consumer = null;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setLong(1, consumerUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        try {
                            consumer = (Consumer)Util.readObject(resultSet, 1);
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4125", (Throwable)iOException);
                        }
                    }
                    Object var11_10 = null;
                    if (!bl) break block15;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", (Throwable)sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4013", consumerUID), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4013", consumerUID), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return consumer;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return consumer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getAllConsumers(Connection connection) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        ArrayList<Consumer> arrayList;
        block15: {
            arrayList = new ArrayList<Consumer>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectAllSQL);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        try {
                            Consumer consumer = (Consumer)Util.readObject(resultSet, 1);
                            arrayList.add(consumer);
                        }
                        catch (IOException iOException) {
                            this.logger.logStack(32, "B4125", (Throwable)iOException);
                        }
                    }
                    Object var10_10 = null;
                    if (!bl) break block15;
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", (Throwable)sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4035"), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4035"), exception3);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return arrayList;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkConsumer(Connection connection, Consumer consumer, boolean bl) throws BrokerException {
        Exception exception;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        boolean bl2;
        block16: {
            bl2 = false;
            ConsumerUID consumerUID = consumer.getConsumerUID();
            boolean bl3 = false;
            String string = this.selectExistByIDSQL;
            preparedStatement = null;
            resultSet = null;
            exception = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl3 = true;
                    }
                    if (!bl) {
                        string = this.selectExistSQL;
                    }
                    preparedStatement = connection.prepareStatement(string);
                    if (bl) {
                        preparedStatement.setLong(1, consumerUID.longValue());
                    } else {
                        preparedStatement.setString(1, ((Subscription)consumer).getDurableName());
                        preparedStatement.setString(2, ((Subscription)consumer).getClientID());
                    }
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl2 = true;
                    }
                }
                catch (Exception exception2) {
                    Exception exception3;
                    exception = exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080[" + string + "]", (Throwable)sQLException);
                    }
                    if (exception2 instanceof BrokerException) {
                        throw (BrokerException)exception2;
                    }
                    if (exception2 instanceof SQLException) {
                        exception3 = DBManager.wrapSQLException("[" + string + "]", (SQLException)exception2);
                        throw new BrokerException(this.br.getKString("B4013", consumerUID), exception3);
                    }
                    exception3 = exception2;
                    throw new BrokerException(this.br.getKString("B4013", consumerUID), exception3);
                }
                Object var14_11 = null;
                if (!bl3) break block16;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                if (bl3) {
                    Util.close(resultSet, preparedStatement, connection, exception);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null, exception);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection, exception);
            return bl2;
        }
        Util.close(resultSet, preparedStatement, null, exception);
        return bl2;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Consumers(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }
}

