/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTakeoverInfo;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

class TakingoverEntry {
    protected String brokerID;
    protected UID storeSession;
    private boolean takeoverComplete = false;
    private Map xids = null;
    private long timeout = 0L;
    private static int DEFAULT_TAKEOVER_PENDING_TIMEOUT = 60;

    public static int getTakeoverTimeout() {
        HAMonitorService hAMonitorService = Globals.getHAMonitorService();
        if (hAMonitorService == null) {
            return DEFAULT_TAKEOVER_PENDING_TIMEOUT;
        }
        int n = 2 * hAMonitorService.getMonitorInterval();
        if (n < DEFAULT_TAKEOVER_PENDING_TIMEOUT) {
            return DEFAULT_TAKEOVER_PENDING_TIMEOUT;
        }
        return n;
    }

    public String toString() {
        return "brokerID=" + this.brokerID + ", storeSession=" + this.storeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toLongString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("brokerID=" + this.brokerID + ", storeSession=" + this.storeSession + ", takeoverComplete=" + this.takeoverComplete + ", timeout=" + this.timeout);
        ArrayList arrayList = null;
        Map map = this.xids;
        synchronized (map) {
            arrayList = new ArrayList(this.xids.keySet());
        }
        stringBuffer.append("\nxidsSize=" + arrayList.size());
        for (Long l : arrayList) {
            XidEntry xidEntry = (XidEntry)this.xids.get(l);
            stringBuffer.append("\n(xid)").append(l).append(": ").append(xidEntry).append("\n");
        }
        return stringBuffer.toString();
    }

    public TakingoverEntry(String string, UID uID) {
        this(string, uID, 0);
    }

    public TakingoverEntry(String string, UID uID, int n) {
        this.brokerID = string;
        this.storeSession = uID;
        this.timeout = (long)n * 1000L;
        this.xids = Collections.synchronizedMap(new LinkedHashMap());
    }

    public synchronized boolean addXid(Long l, String string, UID uID, boolean bl) {
        if (l == null) {
            return false;
        }
        XidEntry xidEntry = (XidEntry)this.xids.get(l);
        if (xidEntry != null) {
            if (bl) {
                xidEntry.expire = System.currentTimeMillis();
            }
            return false;
        }
        XidEntry xidEntry2 = new XidEntry(string, uID, bl);
        this.xids.put(l, xidEntry2);
        return true;
    }

    public synchronized boolean isTakeoverTarget(BrokerAddress brokerAddress) {
        if (!brokerAddress.getBrokerID().equals(this.brokerID) || !brokerAddress.getStoreSessionUID().equals((Object)this.storeSession)) {
            return false;
        }
        if (this.takeoverComplete) {
            return true;
        }
        if (this.xids.size() == 0) {
            return false;
        }
        long l = 0L;
        Collection collection = this.xids.values();
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, new ExpireComparator());
        l = ((XidEntry)arrayList.get((int)0)).expire;
        if (l != 0L) {
            l = ((XidEntry)arrayList.get((int)(arrayList.size() - 1))).expire;
        }
        if (l == 0L) {
            return true;
        }
        if (System.currentTimeMillis() <= l) {
            return true;
        }
        if (Globals.getHAMonitorService().isTakingoverTarget(brokerAddress.getBrokerID(), brokerAddress.getStoreSessionUID())) {
            return true;
        }
        ArrayList<XidEntry> arrayList2 = new ArrayList<XidEntry>();
        XidEntry xidEntry2 = null;
        for (XidEntry xidEntry2 : arrayList) {
            if (!xidEntry2.brokerHost.equals(brokerAddress.getMQAddress().getHost().getHostAddress())) continue;
            arrayList2.add(xidEntry2);
        }
        if (arrayList2.size() == 0) {
            return !this.ifOwnStoreSession(brokerAddress);
        }
        Collections.sort(arrayList2, new SessionComparator());
        if (brokerAddress.getBrokerSessionUID().getTimestamp() <= ((XidEntry)arrayList2.get((int)(arrayList2.size() - 1))).brokerSession.getTimestamp()) {
            return true;
        }
        return !this.ifOwnStoreSession(brokerAddress);
    }

    private boolean ifOwnStoreSession(BrokerAddress brokerAddress) {
        try {
            if (Globals.getStore().ifOwnStoreSession(brokerAddress.getStoreSessionUID().longValue(), brokerAddress.getBrokerID())) {
                return true;
            }
        }
        catch (Exception exception) {
            Globals.getLogger().log(16, exception.getMessage(), (Throwable)exception);
        }
        return false;
    }

    public synchronized void preTakeoverDone(Long l) {
        XidEntry xidEntry = (XidEntry)this.xids.get(l);
        if (xidEntry == null) {
            return;
        }
        if (xidEntry.expire != 0L) {
            return;
        }
        xidEntry.expire = System.currentTimeMillis() + this.timeout;
    }

    public synchronized boolean takeoverComplete() {
        boolean bl = this.takeoverComplete;
        this.takeoverComplete = true;
        return bl;
    }

    public synchronized void takeoverAbort(Long l) {
        XidEntry xidEntry = (XidEntry)this.xids.get(l);
        if (xidEntry != null) {
            xidEntry.expire = System.currentTimeMillis();
        }
    }

    public synchronized GPacket[] getGPackets() {
        ArrayList<GPacket> arrayList = new ArrayList<GPacket>();
        ClusterTakeoverInfo clusterTakeoverInfo = null;
        if (this.takeoverComplete) {
            clusterTakeoverInfo = ClusterTakeoverInfo.newInstance(this.brokerID, this.storeSession);
            try {
                arrayList.add(clusterTakeoverInfo.getGPacket((short)41));
            }
            catch (BrokerException brokerException) {
                // empty catch block
            }
            return arrayList.toArray(new GPacket[0]);
        }
        Long l2 = null;
        XidEntry xidEntry = null;
        for (Long l2 : this.xids.keySet()) {
            xidEntry = (XidEntry)this.xids.get(l2);
            boolean bl = false;
            if (xidEntry.expire != 0L && System.currentTimeMillis() > xidEntry.expire) {
                bl = true;
            }
            clusterTakeoverInfo = ClusterTakeoverInfo.newInstance(this.brokerID, this.storeSession, xidEntry.brokerHost, xidEntry.brokerSession, l2, false, bl);
            try {
                arrayList.add(clusterTakeoverInfo.getGPacket((short)39));
            }
            catch (BrokerException brokerException) {}
        }
        return arrayList.toArray(new GPacket[0]);
    }

    public synchronized GPacket getGPacket(BrokerAddress brokerAddress) {
        if (!brokerAddress.getBrokerID().equals(this.brokerID) || !brokerAddress.getStoreSessionUID().equals((Object)this.storeSession)) {
            return null;
        }
        ClusterTakeoverInfo clusterTakeoverInfo = null;
        if (this.takeoverComplete) {
            clusterTakeoverInfo = ClusterTakeoverInfo.newInstance(this.brokerID, this.storeSession);
            try {
                return clusterTakeoverInfo.getGPacket((short)41);
            }
            catch (BrokerException brokerException) {
                return null;
            }
        }
        Long l2 = null;
        XidEntry xidEntry = null;
        for (Long l2 : this.xids.keySet()) {
            xidEntry = (XidEntry)this.xids.get(l2);
            if (!xidEntry.brokerHost.equals(brokerAddress.getMQAddress().getHost().getHostAddress())) continue;
            clusterTakeoverInfo = ClusterTakeoverInfo.newInstance(this.brokerID, this.storeSession, xidEntry.brokerHost, xidEntry.brokerSession, l2, false);
            try {
                return clusterTakeoverInfo.getGPacket((short)39);
            }
            catch (BrokerException brokerException) {
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TakingoverEntry)) {
            return false;
        }
        TakingoverEntry takingoverEntry = (TakingoverEntry)object;
        return this.brokerID.equals(takingoverEntry.brokerID) && this.storeSession.equals((Object)takingoverEntry.storeSession);
    }

    public int hashCode() {
        return this.brokerID.hashCode() + (int)(this.storeSession.longValue() ^ this.storeSession.longValue() >>> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TakingoverEntry addTakingoverEntry(Map map, ClusterTakeoverInfo clusterTakeoverInfo) {
        boolean bl = false;
        TakingoverEntry takingoverEntry = new TakingoverEntry(clusterTakeoverInfo.getBrokerID(), clusterTakeoverInfo.getStoreSession(), TakingoverEntry.getTakeoverTimeout());
        Map map2 = map;
        synchronized (map2) {
            TakingoverEntry takingoverEntry2 = (TakingoverEntry)map.get(takingoverEntry);
            if (takingoverEntry2 != null) {
                takingoverEntry = takingoverEntry2;
            } else {
                map.put(takingoverEntry, takingoverEntry);
            }
            if (takingoverEntry.addXid(clusterTakeoverInfo.getXid(), clusterTakeoverInfo.getBrokerHost(), clusterTakeoverInfo.getBrokerSession(), clusterTakeoverInfo.isTimedout())) {
                return takingoverEntry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTakingoverEntry(Map map, ClusterTakeoverInfo clusterTakeoverInfo) {
        TakingoverEntry takingoverEntry = new TakingoverEntry(clusterTakeoverInfo.getBrokerID(), clusterTakeoverInfo.getStoreSession());
        Map map2 = map;
        synchronized (map2) {
            TakingoverEntry takingoverEntry2 = (TakingoverEntry)map.get(takingoverEntry);
            if (takingoverEntry2 == null) {
                return;
            }
            takingoverEntry2.takeoverAbort(clusterTakeoverInfo.getXid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TakingoverEntry takeoverComplete(Map map, ClusterTakeoverInfo clusterTakeoverInfo) {
        Map map2 = map;
        synchronized (map2) {
            TakingoverEntry takingoverEntry = (TakingoverEntry)map.get(new TakingoverEntry(clusterTakeoverInfo.getBrokerID(), clusterTakeoverInfo.getStoreSession()));
            if (takingoverEntry == null) {
                takingoverEntry = new TakingoverEntry(clusterTakeoverInfo.getBrokerID(), clusterTakeoverInfo.getStoreSession(), TakingoverEntry.getTakeoverTimeout());
                map.put(takingoverEntry, takingoverEntry);
            }
            if (takingoverEntry.takeoverComplete()) {
                return null;
            }
            return takingoverEntry;
        }
    }

    class ExpireComparator
    implements Comparator {
        ExpireComparator() {
        }

        public int compare(Object object, Object object2) {
            XidEntry xidEntry = (XidEntry)object;
            XidEntry xidEntry2 = (XidEntry)object2;
            return new Long(xidEntry.expire).compareTo(new Long(xidEntry2.expire));
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }
    }

    class SessionComparator
    implements Comparator {
        SessionComparator() {
        }

        public int compare(Object object, Object object2) {
            XidEntry xidEntry = (XidEntry)object;
            XidEntry xidEntry2 = (XidEntry)object2;
            return new Long(xidEntry.brokerSession.getTimestamp()).compareTo(new Long(xidEntry2.brokerSession.getTimestamp()));
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }
    }

    class XidEntry {
        String brokerHost = null;
        UID brokerSession = null;
        long expire = 0L;

        public XidEntry(String string, UID uID, boolean bl) {
            this.brokerHost = string;
            this.brokerSession = uID;
            this.expire = 0L;
            if (bl) {
                this.expire = System.currentTimeMillis();
            }
        }

        public String toString() {
            return "brokerHost=" + this.brokerHost + ", brokerSession=" + this.brokerSession + ", expire=" + this.expire;
        }
    }
}

