/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import java.util.Hashtable;

public class UpdateDestinationHandler
extends AdminCmdHandler {
    private static boolean DEBUG = UpdateDestinationHandler.getDEBUG();

    public UpdateDestinationHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        Destination destination;
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + hashtable);
        }
        String string = (String)hashtable.get("JMQDestination");
        DestinationInfo destinationInfo = (DestinationInfo)this.getBodyObject(packet);
        int n = 200;
        String string2 = null;
        HAMonitorService hAMonitorService = Globals.getHAMonitorService();
        if (hAMonitorService != null && hAMonitorService.inTakeover()) {
            n = 500;
            string2 = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + string2);
        } else {
            try {
                destination = Destination.getDestination(destinationInfo.name, DestType.isQueue((int)destinationInfo.type));
                if (destination == null) {
                    string2 = this.rb.getString("B4017", destinationInfo.name);
                    n = 404;
                } else {
                    if (destinationInfo.isModified(4)) {
                        int bl = destinationInfo.maxMessages;
                        destination.setCapacity(bl);
                    }
                    if (destinationInfo.isModified(16)) {
                        SizeString sizeString = new SizeString();
                        sizeString.setBytes(destinationInfo.maxMessageSize);
                        destination.setMaxByteSize(sizeString);
                    }
                    if (destinationInfo.isModified(8)) {
                        SizeString sizeString = new SizeString();
                        sizeString.setBytes(destinationInfo.maxMessageBytes);
                        destination.setByteCapacity(sizeString);
                    }
                    if (destinationInfo.isModified(32)) {
                        int n2 = destinationInfo.destScope;
                        destination.setScope(n2);
                    }
                    if (destinationInfo.isModified(64)) {
                        int n3 = destinationInfo.destLimitBehavior;
                        destination.setLimitBehavior(n3);
                    }
                    if (destinationInfo.isModified(128)) {
                        int n4 = destinationInfo.maxPrefetch;
                        destination.setMaxPrefetch(n4);
                    }
                    if (destinationInfo.isModified(256)) {
                        int n5 = destinationInfo.destCDP;
                        destination.setClusterDeliveryPolicy(n5);
                    }
                    if (destinationInfo.isModified(512)) {
                        int n6 = destinationInfo.maxActiveConsumers;
                        destination.setMaxActiveConsumers(n6);
                    }
                    if (destinationInfo.isModified(1024)) {
                        int n7 = destinationInfo.maxFailoverConsumers;
                        destination.setMaxFailoverConsumers(n7);
                    }
                    if (destinationInfo.isModified(2048)) {
                        int n8 = destinationInfo.maxProducers;
                        destination.setMaxProducers(n8);
                    }
                    if (destinationInfo.isModified(4096)) {
                        int n9 = destinationInfo.maxNumSharedConsumers;
                        destination.setMaxSharedConsumers(n9);
                    }
                    if (destinationInfo.isModified(8192)) {
                        int n10 = destinationInfo.sharedConsumerFlowLimit;
                        destination.setSharedFlowLimit(n10);
                    }
                    if (destinationInfo.isModified(16384)) {
                        boolean bl = destinationInfo.useDMQ;
                        destination.setUseDMQ(bl);
                    }
                    if (destinationInfo.isModified(32768)) {
                        destination.setValidateXMLSchemaEnabled(destinationInfo.validateXMLSchemaEnabled);
                    }
                    if (destinationInfo.isModified(65536)) {
                        destination.setXMLSchemaUriList(destinationInfo.XMLSchemaUriList);
                    }
                    if (destinationInfo.isModified(131072)) {
                        destination.setReloadXMLSchemaOnFailure(destinationInfo.reloadXMLSchemaOnFailure);
                    }
                    destination.update();
                }
            }
            catch (Exception exception) {
                string2 = UpdateDestinationHandler.getMessageFromException(exception);
                n = 500;
            }
        }
        destination = new Packet(iMQConnection.useDirectBuffers());
        destination.setPacketType(5);
        UpdateDestinationHandler.setProperties((Packet)destination, 41, n, string2);
        this.parent.sendReply(iMQConnection, packet, (Packet)destination);
        return true;
    }
}

